# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v41</h1>       <p>Introduced in Cloudera Manager 7.1.1</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.1.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiParcelUsageRole(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'role_ref': 'ApiRoleRef',
        'parcel_refs': 'list[ApiParcelRef]'
    }

    attribute_map = {
        'role_ref': 'roleRef',
        'parcel_refs': 'parcelRefs'
    }

    def __init__(self, role_ref=None, parcel_refs=None):
        """
        ApiParcelUsageRole - a model defined in Swagger
        """

        self._role_ref = None
        self._parcel_refs = None

        if role_ref is not None:
          self.role_ref = role_ref
        if parcel_refs is not None:
          self.parcel_refs = parcel_refs

    @property
    def role_ref(self):
        """
        Gets the role_ref of this ApiParcelUsageRole.
        A reference to the corresponding Role object.

        :return: The role_ref of this ApiParcelUsageRole.
        :rtype: ApiRoleRef
        """
        return self._role_ref

    @role_ref.setter
    def role_ref(self, role_ref):
        """
        Sets the role_ref of this ApiParcelUsageRole.
        A reference to the corresponding Role object.

        :param role_ref: The role_ref of this ApiParcelUsageRole.
        :type: ApiRoleRef
        """

        self._role_ref = role_ref

    @property
    def parcel_refs(self):
        """
        Gets the parcel_refs of this ApiParcelUsageRole.
        A collection of references to the parcels being used by the role.

        :return: The parcel_refs of this ApiParcelUsageRole.
        :rtype: list[ApiParcelRef]
        """
        return self._parcel_refs

    @parcel_refs.setter
    def parcel_refs(self, parcel_refs):
        """
        Sets the parcel_refs of this ApiParcelUsageRole.
        A collection of references to the parcels being used by the role.

        :param parcel_refs: The parcel_refs of this ApiParcelUsageRole.
        :type: list[ApiParcelRef]
        """

        self._parcel_refs = parcel_refs

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiParcelUsageRole):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
