# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v41</h1>       <p>Introduced in Cloudera Manager 7.1.1</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.1.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiParcelUsage(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'racks': 'list[ApiParcelUsageRack]',
        'parcels': 'list[ApiParcelUsageParcel]'
    }

    attribute_map = {
        'racks': 'racks',
        'parcels': 'parcels'
    }

    def __init__(self, racks=None, parcels=None):
        """
        ApiParcelUsage - a model defined in Swagger
        """

        self._racks = None
        self._parcels = None

        if racks is not None:
          self.racks = racks
        if parcels is not None:
          self.parcels = parcels

    @property
    def racks(self):
        """
        Gets the racks of this ApiParcelUsage.
        The racks that contain hosts that are part of this cluster.

        :return: The racks of this ApiParcelUsage.
        :rtype: list[ApiParcelUsageRack]
        """
        return self._racks

    @racks.setter
    def racks(self, racks):
        """
        Sets the racks of this ApiParcelUsage.
        The racks that contain hosts that are part of this cluster.

        :param racks: The racks of this ApiParcelUsage.
        :type: list[ApiParcelUsageRack]
        """

        self._racks = racks

    @property
    def parcels(self):
        """
        Gets the parcels of this ApiParcelUsage.
        The parcel's that are activated and/or in-use on this cluster.

        :return: The parcels of this ApiParcelUsage.
        :rtype: list[ApiParcelUsageParcel]
        """
        return self._parcels

    @parcels.setter
    def parcels(self, parcels):
        """
        Sets the parcels of this ApiParcelUsage.
        The parcel's that are activated and/or in-use on this cluster.

        :param parcels: The parcels of this ApiParcelUsage.
        :type: list[ApiParcelUsageParcel]
        """

        self._parcels = parcels

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiParcelUsage):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
