# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v41</h1>       <p>Introduced in Cloudera Manager 7.1.1</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.1.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiParcelRef(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'cluster_name': 'str',
        'parcel_name': 'str',
        'parcel_version': 'str',
        'parcel_display_name': 'str'
    }

    attribute_map = {
        'cluster_name': 'clusterName',
        'parcel_name': 'parcelName',
        'parcel_version': 'parcelVersion',
        'parcel_display_name': 'parcelDisplayName'
    }

    def __init__(self, cluster_name=None, parcel_name=None, parcel_version=None, parcel_display_name=None):
        """
        ApiParcelRef - a model defined in Swagger
        """

        self._cluster_name = None
        self._parcel_name = None
        self._parcel_version = None
        self._parcel_display_name = None

        if cluster_name is not None:
          self.cluster_name = cluster_name
        if parcel_name is not None:
          self.parcel_name = parcel_name
        if parcel_version is not None:
          self.parcel_version = parcel_version
        if parcel_display_name is not None:
          self.parcel_display_name = parcel_display_name

    @property
    def cluster_name(self):
        """
        Gets the cluster_name of this ApiParcelRef.
        The name of the cluster that the parcel is used by.

        :return: The cluster_name of this ApiParcelRef.
        :rtype: str
        """
        return self._cluster_name

    @cluster_name.setter
    def cluster_name(self, cluster_name):
        """
        Sets the cluster_name of this ApiParcelRef.
        The name of the cluster that the parcel is used by.

        :param cluster_name: The cluster_name of this ApiParcelRef.
        :type: str
        """

        self._cluster_name = cluster_name

    @property
    def parcel_name(self):
        """
        Gets the parcel_name of this ApiParcelRef.
        The name of the parcel.

        :return: The parcel_name of this ApiParcelRef.
        :rtype: str
        """
        return self._parcel_name

    @parcel_name.setter
    def parcel_name(self, parcel_name):
        """
        Sets the parcel_name of this ApiParcelRef.
        The name of the parcel.

        :param parcel_name: The parcel_name of this ApiParcelRef.
        :type: str
        """

        self._parcel_name = parcel_name

    @property
    def parcel_version(self):
        """
        Gets the parcel_version of this ApiParcelRef.
        The version of the parcel.

        :return: The parcel_version of this ApiParcelRef.
        :rtype: str
        """
        return self._parcel_version

    @parcel_version.setter
    def parcel_version(self, parcel_version):
        """
        Sets the parcel_version of this ApiParcelRef.
        The version of the parcel.

        :param parcel_version: The parcel_version of this ApiParcelRef.
        :type: str
        """

        self._parcel_version = parcel_version

    @property
    def parcel_display_name(self):
        """
        Gets the parcel_display_name of this ApiParcelRef.
        The display name of the parcel. If set, available since v40.

        :return: The parcel_display_name of this ApiParcelRef.
        :rtype: str
        """
        return self._parcel_display_name

    @parcel_display_name.setter
    def parcel_display_name(self, parcel_display_name):
        """
        Sets the parcel_display_name of this ApiParcelRef.
        The display name of the parcel. If set, available since v40.

        :param parcel_display_name: The parcel_display_name of this ApiParcelRef.
        :type: str
        """

        self._parcel_display_name = parcel_display_name

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiParcelRef):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
