# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v41</h1>       <p>Introduced in Cloudera Manager 7.1.1</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.1.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiHost(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'host_id': 'str',
        'ip_address': 'str',
        'hostname': 'str',
        'rack_id': 'str',
        'last_heartbeat': 'str',
        'role_refs': 'list[ApiRoleRef]',
        'health_summary': 'ApiHealthSummary',
        'health_checks': 'list[ApiHealthCheck]',
        'host_url': 'str',
        'maintenance_mode': 'bool',
        'commission_state': 'ApiCommissionState',
        'maintenance_owners': 'list[ApiEntityType]',
        'config': 'ApiConfigList',
        'num_cores': 'float',
        'num_physical_cores': 'float',
        'total_phys_mem_bytes': 'float',
        'entity_status': 'ApiEntityStatus',
        'cluster_ref': 'ApiClusterRef',
        'distribution': 'ApiOsDistribution',
        'tags': 'list[ApiEntityTag]'
    }

    attribute_map = {
        'host_id': 'hostId',
        'ip_address': 'ipAddress',
        'hostname': 'hostname',
        'rack_id': 'rackId',
        'last_heartbeat': 'lastHeartbeat',
        'role_refs': 'roleRefs',
        'health_summary': 'healthSummary',
        'health_checks': 'healthChecks',
        'host_url': 'hostUrl',
        'maintenance_mode': 'maintenanceMode',
        'commission_state': 'commissionState',
        'maintenance_owners': 'maintenanceOwners',
        'config': 'config',
        'num_cores': 'numCores',
        'num_physical_cores': 'numPhysicalCores',
        'total_phys_mem_bytes': 'totalPhysMemBytes',
        'entity_status': 'entityStatus',
        'cluster_ref': 'clusterRef',
        'distribution': 'distribution',
        'tags': 'tags'
    }

    def __init__(self, host_id=None, ip_address=None, hostname=None, rack_id=None, last_heartbeat=None, role_refs=None, health_summary=None, health_checks=None, host_url=None, maintenance_mode=None, commission_state=None, maintenance_owners=None, config=None, num_cores=None, num_physical_cores=None, total_phys_mem_bytes=None, entity_status=None, cluster_ref=None, distribution=None, tags=None):
        """
        ApiHost - a model defined in Swagger
        """

        self._host_id = None
        self._ip_address = None
        self._hostname = None
        self._rack_id = None
        self._last_heartbeat = None
        self._role_refs = None
        self._health_summary = None
        self._health_checks = None
        self._host_url = None
        self._maintenance_mode = None
        self._commission_state = None
        self._maintenance_owners = None
        self._config = None
        self._num_cores = None
        self._num_physical_cores = None
        self._total_phys_mem_bytes = None
        self._entity_status = None
        self._cluster_ref = None
        self._distribution = None
        self._tags = None

        if host_id is not None:
          self.host_id = host_id
        if ip_address is not None:
          self.ip_address = ip_address
        if hostname is not None:
          self.hostname = hostname
        if rack_id is not None:
          self.rack_id = rack_id
        if last_heartbeat is not None:
          self.last_heartbeat = last_heartbeat
        if role_refs is not None:
          self.role_refs = role_refs
        if health_summary is not None:
          self.health_summary = health_summary
        if health_checks is not None:
          self.health_checks = health_checks
        if host_url is not None:
          self.host_url = host_url
        if maintenance_mode is not None:
          self.maintenance_mode = maintenance_mode
        if commission_state is not None:
          self.commission_state = commission_state
        if maintenance_owners is not None:
          self.maintenance_owners = maintenance_owners
        if config is not None:
          self.config = config
        if num_cores is not None:
          self.num_cores = num_cores
        if num_physical_cores is not None:
          self.num_physical_cores = num_physical_cores
        if total_phys_mem_bytes is not None:
          self.total_phys_mem_bytes = total_phys_mem_bytes
        if entity_status is not None:
          self.entity_status = entity_status
        if cluster_ref is not None:
          self.cluster_ref = cluster_ref
        if distribution is not None:
          self.distribution = distribution
        if tags is not None:
          self.tags = tags

    @property
    def host_id(self):
        """
        Gets the host_id of this ApiHost.
        A unique host identifier. This is not the same as the hostname (FQDN). It is a distinct value that remains the same even if the hostname changes.

        :return: The host_id of this ApiHost.
        :rtype: str
        """
        return self._host_id

    @host_id.setter
    def host_id(self, host_id):
        """
        Sets the host_id of this ApiHost.
        A unique host identifier. This is not the same as the hostname (FQDN). It is a distinct value that remains the same even if the hostname changes.

        :param host_id: The host_id of this ApiHost.
        :type: str
        """

        self._host_id = host_id

    @property
    def ip_address(self):
        """
        Gets the ip_address of this ApiHost.
        The host IP address. This field is not mutable after the initial creation.

        :return: The ip_address of this ApiHost.
        :rtype: str
        """
        return self._ip_address

    @ip_address.setter
    def ip_address(self, ip_address):
        """
        Sets the ip_address of this ApiHost.
        The host IP address. This field is not mutable after the initial creation.

        :param ip_address: The ip_address of this ApiHost.
        :type: str
        """

        self._ip_address = ip_address

    @property
    def hostname(self):
        """
        Gets the hostname of this ApiHost.
        The hostname. This field is not mutable after the initial creation.

        :return: The hostname of this ApiHost.
        :rtype: str
        """
        return self._hostname

    @hostname.setter
    def hostname(self, hostname):
        """
        Sets the hostname of this ApiHost.
        The hostname. This field is not mutable after the initial creation.

        :param hostname: The hostname of this ApiHost.
        :type: str
        """

        self._hostname = hostname

    @property
    def rack_id(self):
        """
        Gets the rack_id of this ApiHost.
        The rack ID for this host.

        :return: The rack_id of this ApiHost.
        :rtype: str
        """
        return self._rack_id

    @rack_id.setter
    def rack_id(self, rack_id):
        """
        Sets the rack_id of this ApiHost.
        The rack ID for this host.

        :param rack_id: The rack_id of this ApiHost.
        :type: str
        """

        self._rack_id = rack_id

    @property
    def last_heartbeat(self):
        """
        Gets the last_heartbeat of this ApiHost.
        Readonly. Requires \"full\" view. When the host agent sent the last heartbeat.

        :return: The last_heartbeat of this ApiHost.
        :rtype: str
        """
        return self._last_heartbeat

    @last_heartbeat.setter
    def last_heartbeat(self, last_heartbeat):
        """
        Sets the last_heartbeat of this ApiHost.
        Readonly. Requires \"full\" view. When the host agent sent the last heartbeat.

        :param last_heartbeat: The last_heartbeat of this ApiHost.
        :type: str
        """

        self._last_heartbeat = last_heartbeat

    @property
    def role_refs(self):
        """
        Gets the role_refs of this ApiHost.
        Readonly. Requires \"full\" view. The list of roles assigned to this host.

        :return: The role_refs of this ApiHost.
        :rtype: list[ApiRoleRef]
        """
        return self._role_refs

    @role_refs.setter
    def role_refs(self, role_refs):
        """
        Sets the role_refs of this ApiHost.
        Readonly. Requires \"full\" view. The list of roles assigned to this host.

        :param role_refs: The role_refs of this ApiHost.
        :type: list[ApiRoleRef]
        """

        self._role_refs = role_refs

    @property
    def health_summary(self):
        """
        Gets the health_summary of this ApiHost.
        Readonly. Requires \"full\" view. The high-level health status of this host.

        :return: The health_summary of this ApiHost.
        :rtype: ApiHealthSummary
        """
        return self._health_summary

    @health_summary.setter
    def health_summary(self, health_summary):
        """
        Sets the health_summary of this ApiHost.
        Readonly. Requires \"full\" view. The high-level health status of this host.

        :param health_summary: The health_summary of this ApiHost.
        :type: ApiHealthSummary
        """

        self._health_summary = health_summary

    @property
    def health_checks(self):
        """
        Gets the health_checks of this ApiHost.
        Readonly. Requires \"full\" view. The list of health checks performed on the host, with their results.

        :return: The health_checks of this ApiHost.
        :rtype: list[ApiHealthCheck]
        """
        return self._health_checks

    @health_checks.setter
    def health_checks(self, health_checks):
        """
        Sets the health_checks of this ApiHost.
        Readonly. Requires \"full\" view. The list of health checks performed on the host, with their results.

        :param health_checks: The health_checks of this ApiHost.
        :type: list[ApiHealthCheck]
        """

        self._health_checks = health_checks

    @property
    def host_url(self):
        """
        Gets the host_url of this ApiHost.
        Readonly. A URL into the Cloudera Manager web UI for this specific host.

        :return: The host_url of this ApiHost.
        :rtype: str
        """
        return self._host_url

    @host_url.setter
    def host_url(self, host_url):
        """
        Sets the host_url of this ApiHost.
        Readonly. A URL into the Cloudera Manager web UI for this specific host.

        :param host_url: The host_url of this ApiHost.
        :type: str
        """

        self._host_url = host_url

    @property
    def maintenance_mode(self):
        """
        Gets the maintenance_mode of this ApiHost.
        Readonly. Whether the host is in maintenance mode. Available since API v2.

        :return: The maintenance_mode of this ApiHost.
        :rtype: bool
        """
        return self._maintenance_mode

    @maintenance_mode.setter
    def maintenance_mode(self, maintenance_mode):
        """
        Sets the maintenance_mode of this ApiHost.
        Readonly. Whether the host is in maintenance mode. Available since API v2.

        :param maintenance_mode: The maintenance_mode of this ApiHost.
        :type: bool
        """

        self._maintenance_mode = maintenance_mode

    @property
    def commission_state(self):
        """
        Gets the commission_state of this ApiHost.
        Readonly. The commission state of this role. Available since API v2.

        :return: The commission_state of this ApiHost.
        :rtype: ApiCommissionState
        """
        return self._commission_state

    @commission_state.setter
    def commission_state(self, commission_state):
        """
        Sets the commission_state of this ApiHost.
        Readonly. The commission state of this role. Available since API v2.

        :param commission_state: The commission_state of this ApiHost.
        :type: ApiCommissionState
        """

        self._commission_state = commission_state

    @property
    def maintenance_owners(self):
        """
        Gets the maintenance_owners of this ApiHost.
        Readonly. The list of objects that trigger this host to be in maintenance mode. Available since API v2.

        :return: The maintenance_owners of this ApiHost.
        :rtype: list[ApiEntityType]
        """
        return self._maintenance_owners

    @maintenance_owners.setter
    def maintenance_owners(self, maintenance_owners):
        """
        Sets the maintenance_owners of this ApiHost.
        Readonly. The list of objects that trigger this host to be in maintenance mode. Available since API v2.

        :param maintenance_owners: The maintenance_owners of this ApiHost.
        :type: list[ApiEntityType]
        """

        self._maintenance_owners = maintenance_owners

    @property
    def config(self):
        """
        Gets the config of this ApiHost.
        

        :return: The config of this ApiHost.
        :rtype: ApiConfigList
        """
        return self._config

    @config.setter
    def config(self, config):
        """
        Sets the config of this ApiHost.
        

        :param config: The config of this ApiHost.
        :type: ApiConfigList
        """

        self._config = config

    @property
    def num_cores(self):
        """
        Gets the num_cores of this ApiHost.
        Readonly. The number of logical CPU cores on this host. Only populated after the host has heartbeated to the server. Available since API v4.

        :return: The num_cores of this ApiHost.
        :rtype: float
        """
        return self._num_cores

    @num_cores.setter
    def num_cores(self, num_cores):
        """
        Sets the num_cores of this ApiHost.
        Readonly. The number of logical CPU cores on this host. Only populated after the host has heartbeated to the server. Available since API v4.

        :param num_cores: The num_cores of this ApiHost.
        :type: float
        """

        self._num_cores = num_cores

    @property
    def num_physical_cores(self):
        """
        Gets the num_physical_cores of this ApiHost.
        Readonly. The number of physical CPU cores on this host. Only populated after the host has heartbeated to the server. Available since API v9.

        :return: The num_physical_cores of this ApiHost.
        :rtype: float
        """
        return self._num_physical_cores

    @num_physical_cores.setter
    def num_physical_cores(self, num_physical_cores):
        """
        Sets the num_physical_cores of this ApiHost.
        Readonly. The number of physical CPU cores on this host. Only populated after the host has heartbeated to the server. Available since API v9.

        :param num_physical_cores: The num_physical_cores of this ApiHost.
        :type: float
        """

        self._num_physical_cores = num_physical_cores

    @property
    def total_phys_mem_bytes(self):
        """
        Gets the total_phys_mem_bytes of this ApiHost.
        Readonly. The amount of physical RAM on this host, in bytes. Only populated after the host has heartbeated to the server. Available since API v4.

        :return: The total_phys_mem_bytes of this ApiHost.
        :rtype: float
        """
        return self._total_phys_mem_bytes

    @total_phys_mem_bytes.setter
    def total_phys_mem_bytes(self, total_phys_mem_bytes):
        """
        Sets the total_phys_mem_bytes of this ApiHost.
        Readonly. The amount of physical RAM on this host, in bytes. Only populated after the host has heartbeated to the server. Available since API v4.

        :param total_phys_mem_bytes: The total_phys_mem_bytes of this ApiHost.
        :type: float
        """

        self._total_phys_mem_bytes = total_phys_mem_bytes

    @property
    def entity_status(self):
        """
        Gets the entity_status of this ApiHost.
        Readonly. The entity status for this host. Available since API v11.

        :return: The entity_status of this ApiHost.
        :rtype: ApiEntityStatus
        """
        return self._entity_status

    @entity_status.setter
    def entity_status(self, entity_status):
        """
        Sets the entity_status of this ApiHost.
        Readonly. The entity status for this host. Available since API v11.

        :param entity_status: The entity_status of this ApiHost.
        :type: ApiEntityStatus
        """

        self._entity_status = entity_status

    @property
    def cluster_ref(self):
        """
        Gets the cluster_ref of this ApiHost.
        Readonly. A reference to the enclosing cluster. This might be null if the host is not yet assigned to a cluster. Available since API v11.

        :return: The cluster_ref of this ApiHost.
        :rtype: ApiClusterRef
        """
        return self._cluster_ref

    @cluster_ref.setter
    def cluster_ref(self, cluster_ref):
        """
        Sets the cluster_ref of this ApiHost.
        Readonly. A reference to the enclosing cluster. This might be null if the host is not yet assigned to a cluster. Available since API v11.

        :param cluster_ref: The cluster_ref of this ApiHost.
        :type: ApiClusterRef
        """

        self._cluster_ref = cluster_ref

    @property
    def distribution(self):
        """
        Gets the distribution of this ApiHost.
        Readonly. OS distribution available on the host. Available since API v40.

        :return: The distribution of this ApiHost.
        :rtype: ApiOsDistribution
        """
        return self._distribution

    @distribution.setter
    def distribution(self, distribution):
        """
        Sets the distribution of this ApiHost.
        Readonly. OS distribution available on the host. Available since API v40.

        :param distribution: The distribution of this ApiHost.
        :type: ApiOsDistribution
        """

        self._distribution = distribution

    @property
    def tags(self):
        """
        Gets the tags of this ApiHost.
        Tags associated with the host. Available since V41.

        :return: The tags of this ApiHost.
        :rtype: list[ApiEntityTag]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """
        Sets the tags of this ApiHost.
        Tags associated with the host. Available since V41.

        :param tags: The tags of this ApiHost.
        :type: list[ApiEntityTag]
        """

        self._tags = tags

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiHost):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
