# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v41</h1>       <p>Introduced in Cloudera Manager 7.1.1</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.1.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiHealthCheck(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'summary': 'ApiHealthSummary',
        'explanation': 'str',
        'suppressed': 'bool'
    }

    attribute_map = {
        'name': 'name',
        'summary': 'summary',
        'explanation': 'explanation',
        'suppressed': 'suppressed'
    }

    def __init__(self, name=None, summary=None, explanation=None, suppressed=None):
        """
        ApiHealthCheck - a model defined in Swagger
        """

        self._name = None
        self._summary = None
        self._explanation = None
        self._suppressed = None

        if name is not None:
          self.name = name
        if summary is not None:
          self.summary = summary
        if explanation is not None:
          self.explanation = explanation
        if suppressed is not None:
          self.suppressed = suppressed

    @property
    def name(self):
        """
        Gets the name of this ApiHealthCheck.
        Unique name of this health check.

        :return: The name of this ApiHealthCheck.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ApiHealthCheck.
        Unique name of this health check.

        :param name: The name of this ApiHealthCheck.
        :type: str
        """

        self._name = name

    @property
    def summary(self):
        """
        Gets the summary of this ApiHealthCheck.
        The summary status of this check.

        :return: The summary of this ApiHealthCheck.
        :rtype: ApiHealthSummary
        """
        return self._summary

    @summary.setter
    def summary(self, summary):
        """
        Sets the summary of this ApiHealthCheck.
        The summary status of this check.

        :param summary: The summary of this ApiHealthCheck.
        :type: ApiHealthSummary
        """

        self._summary = summary

    @property
    def explanation(self):
        """
        Gets the explanation of this ApiHealthCheck.
        The explanation of this health check. Available since v11.

        :return: The explanation of this ApiHealthCheck.
        :rtype: str
        """
        return self._explanation

    @explanation.setter
    def explanation(self, explanation):
        """
        Sets the explanation of this ApiHealthCheck.
        The explanation of this health check. Available since v11.

        :param explanation: The explanation of this ApiHealthCheck.
        :type: str
        """

        self._explanation = explanation

    @property
    def suppressed(self):
        """
        Gets the suppressed of this ApiHealthCheck.
        Whether this health test is suppressed. A suppressed health test is not considered when computing an entity's overall health. Available since v11.

        :return: The suppressed of this ApiHealthCheck.
        :rtype: bool
        """
        return self._suppressed

    @suppressed.setter
    def suppressed(self, suppressed):
        """
        Sets the suppressed of this ApiHealthCheck.
        Whether this health test is suppressed. A suppressed health test is not considered when computing an entity's overall health. Available since v11.

        :param suppressed: The suppressed of this ApiHealthCheck.
        :type: bool
        """

        self._suppressed = suppressed

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiHealthCheck):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
