# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v41</h1>       <p>Introduced in Cloudera Manager 7.1.1</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.1.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiHdfsFailoverArguments(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'nameservice': 'str',
        'zoo_keeper_service': 'ApiServiceRef',
        'active_fc_name': 'str',
        'stand_by_fc_name': 'str'
    }

    attribute_map = {
        'nameservice': 'nameservice',
        'zoo_keeper_service': 'zooKeeperService',
        'active_fc_name': 'activeFCName',
        'stand_by_fc_name': 'standByFCName'
    }

    def __init__(self, nameservice=None, zoo_keeper_service=None, active_fc_name=None, stand_by_fc_name=None):
        """
        ApiHdfsFailoverArguments - a model defined in Swagger
        """

        self._nameservice = None
        self._zoo_keeper_service = None
        self._active_fc_name = None
        self._stand_by_fc_name = None

        if nameservice is not None:
          self.nameservice = nameservice
        if zoo_keeper_service is not None:
          self.zoo_keeper_service = zoo_keeper_service
        if active_fc_name is not None:
          self.active_fc_name = active_fc_name
        if stand_by_fc_name is not None:
          self.stand_by_fc_name = stand_by_fc_name

    @property
    def nameservice(self):
        """
        Gets the nameservice of this ApiHdfsFailoverArguments.
        Nameservice for which to enable automatic failover.

        :return: The nameservice of this ApiHdfsFailoverArguments.
        :rtype: str
        """
        return self._nameservice

    @nameservice.setter
    def nameservice(self, nameservice):
        """
        Sets the nameservice of this ApiHdfsFailoverArguments.
        Nameservice for which to enable automatic failover.

        :param nameservice: The nameservice of this ApiHdfsFailoverArguments.
        :type: str
        """

        self._nameservice = nameservice

    @property
    def zoo_keeper_service(self):
        """
        Gets the zoo_keeper_service of this ApiHdfsFailoverArguments.
        The ZooKeeper service to use.

        :return: The zoo_keeper_service of this ApiHdfsFailoverArguments.
        :rtype: ApiServiceRef
        """
        return self._zoo_keeper_service

    @zoo_keeper_service.setter
    def zoo_keeper_service(self, zoo_keeper_service):
        """
        Sets the zoo_keeper_service of this ApiHdfsFailoverArguments.
        The ZooKeeper service to use.

        :param zoo_keeper_service: The zoo_keeper_service of this ApiHdfsFailoverArguments.
        :type: ApiServiceRef
        """

        self._zoo_keeper_service = zoo_keeper_service

    @property
    def active_fc_name(self):
        """
        Gets the active_fc_name of this ApiHdfsFailoverArguments.
        Name of the failover controller to create for the active NameNode.

        :return: The active_fc_name of this ApiHdfsFailoverArguments.
        :rtype: str
        """
        return self._active_fc_name

    @active_fc_name.setter
    def active_fc_name(self, active_fc_name):
        """
        Sets the active_fc_name of this ApiHdfsFailoverArguments.
        Name of the failover controller to create for the active NameNode.

        :param active_fc_name: The active_fc_name of this ApiHdfsFailoverArguments.
        :type: str
        """

        self._active_fc_name = active_fc_name

    @property
    def stand_by_fc_name(self):
        """
        Gets the stand_by_fc_name of this ApiHdfsFailoverArguments.
        Name of the failover controller to create for the stand-by NameNode.

        :return: The stand_by_fc_name of this ApiHdfsFailoverArguments.
        :rtype: str
        """
        return self._stand_by_fc_name

    @stand_by_fc_name.setter
    def stand_by_fc_name(self, stand_by_fc_name):
        """
        Sets the stand_by_fc_name of this ApiHdfsFailoverArguments.
        Name of the failover controller to create for the stand-by NameNode.

        :param stand_by_fc_name: The stand_by_fc_name of this ApiHdfsFailoverArguments.
        :type: str
        """

        self._stand_by_fc_name = stand_by_fc_name

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiHdfsFailoverArguments):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
