# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v41</h1>       <p>Introduced in Cloudera Manager 7.1.1</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.1.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiControlPlane(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'values_yaml': 'str',
        'namespace': 'str',
        'dns_suffix': 'str',
        'uuid': 'str',
        'docker_registry': 'str',
        'remote_repo_url': 'str',
        'version': 'str'
    }

    attribute_map = {
        'values_yaml': 'valuesYaml',
        'namespace': 'namespace',
        'dns_suffix': 'dnsSuffix',
        'uuid': 'uuid',
        'docker_registry': 'dockerRegistry',
        'remote_repo_url': 'remoteRepoUrl',
        'version': 'version'
    }

    def __init__(self, values_yaml=None, namespace=None, dns_suffix=None, uuid=None, docker_registry=None, remote_repo_url=None, version=None):
        """
        ApiControlPlane - a model defined in Swagger
        """

        self._values_yaml = None
        self._namespace = None
        self._dns_suffix = None
        self._uuid = None
        self._docker_registry = None
        self._remote_repo_url = None
        self._version = None

        if values_yaml is not None:
          self.values_yaml = values_yaml
        if namespace is not None:
          self.namespace = namespace
        if dns_suffix is not None:
          self.dns_suffix = dns_suffix
        if uuid is not None:
          self.uuid = uuid
        if docker_registry is not None:
          self.docker_registry = docker_registry
        if remote_repo_url is not None:
          self.remote_repo_url = remote_repo_url
        if version is not None:
          self.version = version

    @property
    def values_yaml(self):
        """
        Gets the values_yaml of this ApiControlPlane.
        The content of the values.yaml used to configure the control plane

        :return: The values_yaml of this ApiControlPlane.
        :rtype: str
        """
        return self._values_yaml

    @values_yaml.setter
    def values_yaml(self, values_yaml):
        """
        Sets the values_yaml of this ApiControlPlane.
        The content of the values.yaml used to configure the control plane

        :param values_yaml: The values_yaml of this ApiControlPlane.
        :type: str
        """

        self._values_yaml = values_yaml

    @property
    def namespace(self):
        """
        Gets the namespace of this ApiControlPlane.
        The namespace where the control plane is installed. Append the domain to the namespace to get the url of the control plane.

        :return: The namespace of this ApiControlPlane.
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace):
        """
        Sets the namespace of this ApiControlPlane.
        The namespace where the control plane is installed. Append the domain to the namespace to get the url of the control plane.

        :param namespace: The namespace of this ApiControlPlane.
        :type: str
        """

        self._namespace = namespace

    @property
    def dns_suffix(self):
        """
        Gets the dns_suffix of this ApiControlPlane.
        The domain where the control plane is installed. Append the domain to the namespace to get the url of the control plane.

        :return: The dns_suffix of this ApiControlPlane.
        :rtype: str
        """
        return self._dns_suffix

    @dns_suffix.setter
    def dns_suffix(self, dns_suffix):
        """
        Sets the dns_suffix of this ApiControlPlane.
        The domain where the control plane is installed. Append the domain to the namespace to get the url of the control plane.

        :param dns_suffix: The dns_suffix of this ApiControlPlane.
        :type: str
        """

        self._dns_suffix = dns_suffix

    @property
    def uuid(self):
        """
        Gets the uuid of this ApiControlPlane.
        The universally unique ID of this control plane in Cloudera Manager

        :return: The uuid of this ApiControlPlane.
        :rtype: str
        """
        return self._uuid

    @uuid.setter
    def uuid(self, uuid):
        """
        Sets the uuid of this ApiControlPlane.
        The universally unique ID of this control plane in Cloudera Manager

        :param uuid: The uuid of this ApiControlPlane.
        :type: str
        """

        self._uuid = uuid

    @property
    def docker_registry(self):
        """
        Gets the docker_registry of this ApiControlPlane.
        The url of the Docker Registry where images used to deploy the control plane are stored

        :return: The docker_registry of this ApiControlPlane.
        :rtype: str
        """
        return self._docker_registry

    @docker_registry.setter
    def docker_registry(self, docker_registry):
        """
        Sets the docker_registry of this ApiControlPlane.
        The url of the Docker Registry where images used to deploy the control plane are stored

        :param docker_registry: The docker_registry of this ApiControlPlane.
        :type: str
        """

        self._docker_registry = docker_registry

    @property
    def remote_repo_url(self):
        """
        Gets the remote_repo_url of this ApiControlPlane.
        The url of the remote repository where the artifacts used to install the control plane are hosted

        :return: The remote_repo_url of this ApiControlPlane.
        :rtype: str
        """
        return self._remote_repo_url

    @remote_repo_url.setter
    def remote_repo_url(self, remote_repo_url):
        """
        Sets the remote_repo_url of this ApiControlPlane.
        The url of the remote repository where the artifacts used to install the control plane are hosted

        :param remote_repo_url: The remote_repo_url of this ApiControlPlane.
        :type: str
        """

        self._remote_repo_url = remote_repo_url

    @property
    def version(self):
        """
        Gets the version of this ApiControlPlane.
        The CDP version of the control plane

        :return: The version of this ApiControlPlane.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this ApiControlPlane.
        The CDP version of the control plane

        :param version: The version of this ApiControlPlane.
        :type: str
        """

        self._version = version

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiControlPlane):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
