# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v41</h1>       <p>Introduced in Cloudera Manager 7.1.1</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.1.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiClusterTemplateRoleConfigGroup(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'ref_name': 'str',
        'role_type': 'str',
        'base': 'bool',
        'display_name': 'str',
        'configs': 'list[ApiClusterTemplateConfig]'
    }

    attribute_map = {
        'ref_name': 'refName',
        'role_type': 'roleType',
        'base': 'base',
        'display_name': 'displayName',
        'configs': 'configs'
    }

    def __init__(self, ref_name=None, role_type=None, base=None, display_name=None, configs=None):
        """
        ApiClusterTemplateRoleConfigGroup - a model defined in Swagger
        """

        self._ref_name = None
        self._role_type = None
        self._base = None
        self._display_name = None
        self._configs = None

        if ref_name is not None:
          self.ref_name = ref_name
        if role_type is not None:
          self.role_type = role_type
        if base is not None:
          self.base = base
        if display_name is not None:
          self.display_name = display_name
        if configs is not None:
          self.configs = configs

    @property
    def ref_name(self):
        """
        Gets the ref_name of this ApiClusterTemplateRoleConfigGroup.
        The reference name of the role config.

        :return: The ref_name of this ApiClusterTemplateRoleConfigGroup.
        :rtype: str
        """
        return self._ref_name

    @ref_name.setter
    def ref_name(self, ref_name):
        """
        Sets the ref_name of this ApiClusterTemplateRoleConfigGroup.
        The reference name of the role config.

        :param ref_name: The ref_name of this ApiClusterTemplateRoleConfigGroup.
        :type: str
        """

        self._ref_name = ref_name

    @property
    def role_type(self):
        """
        Gets the role_type of this ApiClusterTemplateRoleConfigGroup.
        Role type

        :return: The role_type of this ApiClusterTemplateRoleConfigGroup.
        :rtype: str
        """
        return self._role_type

    @role_type.setter
    def role_type(self, role_type):
        """
        Sets the role_type of this ApiClusterTemplateRoleConfigGroup.
        Role type

        :param role_type: The role_type of this ApiClusterTemplateRoleConfigGroup.
        :type: str
        """

        self._role_type = role_type

    @property
    def base(self):
        """
        Gets the base of this ApiClusterTemplateRoleConfigGroup.
        If true then it is the base config group for that role. There can only be one base role config group for a given role type.

        :return: The base of this ApiClusterTemplateRoleConfigGroup.
        :rtype: bool
        """
        return self._base

    @base.setter
    def base(self, base):
        """
        Sets the base of this ApiClusterTemplateRoleConfigGroup.
        If true then it is the base config group for that role. There can only be one base role config group for a given role type.

        :param base: The base of this ApiClusterTemplateRoleConfigGroup.
        :type: bool
        """

        self._base = base

    @property
    def display_name(self):
        """
        Gets the display_name of this ApiClusterTemplateRoleConfigGroup.
        Role config group display name

        :return: The display_name of this ApiClusterTemplateRoleConfigGroup.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this ApiClusterTemplateRoleConfigGroup.
        Role config group display name

        :param display_name: The display_name of this ApiClusterTemplateRoleConfigGroup.
        :type: str
        """

        self._display_name = display_name

    @property
    def configs(self):
        """
        Gets the configs of this ApiClusterTemplateRoleConfigGroup.
        List of configurations

        :return: The configs of this ApiClusterTemplateRoleConfigGroup.
        :rtype: list[ApiClusterTemplateConfig]
        """
        return self._configs

    @configs.setter
    def configs(self, configs):
        """
        Sets the configs of this ApiClusterTemplateRoleConfigGroup.
        List of configurations

        :param configs: The configs of this ApiClusterTemplateRoleConfigGroup.
        :type: list[ApiClusterTemplateConfig]
        """

        self._configs = configs

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiClusterTemplateRoleConfigGroup):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
