# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v41</h1>       <p>Introduced in Cloudera Manager 7.1.1</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.1.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiClusterTemplate(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'cdh_version': 'str',
        'products': 'list[ApiProductVersion]',
        'services': 'list[ApiClusterTemplateService]',
        'host_templates': 'list[ApiClusterTemplateHostTemplate]',
        'display_name': 'str',
        'cm_version': 'str',
        'instantiator': 'ApiClusterTemplateInstantiator',
        'repositories': 'list[str]',
        'cluster_spec': 'ApiClusterTemplateClusterSpec',
        'tags': 'list[ApiEntityTag]'
    }

    attribute_map = {
        'cdh_version': 'cdhVersion',
        'products': 'products',
        'services': 'services',
        'host_templates': 'hostTemplates',
        'display_name': 'displayName',
        'cm_version': 'cmVersion',
        'instantiator': 'instantiator',
        'repositories': 'repositories',
        'cluster_spec': 'clusterSpec',
        'tags': 'tags'
    }

    def __init__(self, cdh_version=None, products=None, services=None, host_templates=None, display_name=None, cm_version=None, instantiator=None, repositories=None, cluster_spec=None, tags=None):
        """
        ApiClusterTemplate - a model defined in Swagger
        """

        self._cdh_version = None
        self._products = None
        self._services = None
        self._host_templates = None
        self._display_name = None
        self._cm_version = None
        self._instantiator = None
        self._repositories = None
        self._cluster_spec = None
        self._tags = None

        if cdh_version is not None:
          self.cdh_version = cdh_version
        if products is not None:
          self.products = products
        if services is not None:
          self.services = services
        if host_templates is not None:
          self.host_templates = host_templates
        if display_name is not None:
          self.display_name = display_name
        if cm_version is not None:
          self.cm_version = cm_version
        if instantiator is not None:
          self.instantiator = instantiator
        if repositories is not None:
          self.repositories = repositories
        if cluster_spec is not None:
          self.cluster_spec = cluster_spec
        if tags is not None:
          self.tags = tags

    @property
    def cdh_version(self):
        """
        Gets the cdh_version of this ApiClusterTemplate.
        CDH version

        :return: The cdh_version of this ApiClusterTemplate.
        :rtype: str
        """
        return self._cdh_version

    @cdh_version.setter
    def cdh_version(self, cdh_version):
        """
        Sets the cdh_version of this ApiClusterTemplate.
        CDH version

        :param cdh_version: The cdh_version of this ApiClusterTemplate.
        :type: str
        """

        self._cdh_version = cdh_version

    @property
    def products(self):
        """
        Gets the products of this ApiClusterTemplate.
        All the parcels that needs to be deployed and activated

        :return: The products of this ApiClusterTemplate.
        :rtype: list[ApiProductVersion]
        """
        return self._products

    @products.setter
    def products(self, products):
        """
        Sets the products of this ApiClusterTemplate.
        All the parcels that needs to be deployed and activated

        :param products: The products of this ApiClusterTemplate.
        :type: list[ApiProductVersion]
        """

        self._products = products

    @property
    def services(self):
        """
        Gets the services of this ApiClusterTemplate.
        All the services that needs to be deployed

        :return: The services of this ApiClusterTemplate.
        :rtype: list[ApiClusterTemplateService]
        """
        return self._services

    @services.setter
    def services(self, services):
        """
        Sets the services of this ApiClusterTemplate.
        All the services that needs to be deployed

        :param services: The services of this ApiClusterTemplate.
        :type: list[ApiClusterTemplateService]
        """

        self._services = services

    @property
    def host_templates(self):
        """
        Gets the host_templates of this ApiClusterTemplate.
        All host templates

        :return: The host_templates of this ApiClusterTemplate.
        :rtype: list[ApiClusterTemplateHostTemplate]
        """
        return self._host_templates

    @host_templates.setter
    def host_templates(self, host_templates):
        """
        Sets the host_templates of this ApiClusterTemplate.
        All host templates

        :param host_templates: The host_templates of this ApiClusterTemplate.
        :type: list[ApiClusterTemplateHostTemplate]
        """

        self._host_templates = host_templates

    @property
    def display_name(self):
        """
        Gets the display_name of this ApiClusterTemplate.
        Cluster display name

        :return: The display_name of this ApiClusterTemplate.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this ApiClusterTemplate.
        Cluster display name

        :param display_name: The display_name of this ApiClusterTemplate.
        :type: str
        """

        self._display_name = display_name

    @property
    def cm_version(self):
        """
        Gets the cm_version of this ApiClusterTemplate.
        CM version for which the template

        :return: The cm_version of this ApiClusterTemplate.
        :rtype: str
        """
        return self._cm_version

    @cm_version.setter
    def cm_version(self, cm_version):
        """
        Sets the cm_version of this ApiClusterTemplate.
        CM version for which the template

        :param cm_version: The cm_version of this ApiClusterTemplate.
        :type: str
        """

        self._cm_version = cm_version

    @property
    def instantiator(self):
        """
        Gets the instantiator of this ApiClusterTemplate.
        A constructor listing all the variables and references that needs to be resolved for this template

        :return: The instantiator of this ApiClusterTemplate.
        :rtype: ApiClusterTemplateInstantiator
        """
        return self._instantiator

    @instantiator.setter
    def instantiator(self, instantiator):
        """
        Sets the instantiator of this ApiClusterTemplate.
        A constructor listing all the variables and references that needs to be resolved for this template

        :param instantiator: The instantiator of this ApiClusterTemplate.
        :type: ApiClusterTemplateInstantiator
        """

        self._instantiator = instantiator

    @property
    def repositories(self):
        """
        Gets the repositories of this ApiClusterTemplate.
        List of all repositories registered with CM

        :return: The repositories of this ApiClusterTemplate.
        :rtype: list[str]
        """
        return self._repositories

    @repositories.setter
    def repositories(self, repositories):
        """
        Sets the repositories of this ApiClusterTemplate.
        List of all repositories registered with CM

        :param repositories: The repositories of this ApiClusterTemplate.
        :type: list[str]
        """

        self._repositories = repositories

    @property
    def cluster_spec(self):
        """
        Gets the cluster_spec of this ApiClusterTemplate.
        Cluster specification.

        :return: The cluster_spec of this ApiClusterTemplate.
        :rtype: ApiClusterTemplateClusterSpec
        """
        return self._cluster_spec

    @cluster_spec.setter
    def cluster_spec(self, cluster_spec):
        """
        Sets the cluster_spec of this ApiClusterTemplate.
        Cluster specification.

        :param cluster_spec: The cluster_spec of this ApiClusterTemplate.
        :type: ApiClusterTemplateClusterSpec
        """

        self._cluster_spec = cluster_spec

    @property
    def tags(self):
        """
        Gets the tags of this ApiClusterTemplate.
        Tags associated with the cluster

        :return: The tags of this ApiClusterTemplate.
        :rtype: list[ApiEntityTag]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """
        Sets the tags of this ApiClusterTemplate.
        Tags associated with the cluster

        :param tags: The tags of this ApiClusterTemplate.
        :type: list[ApiEntityTag]
        """

        self._tags = tags

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiClusterTemplate):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
