# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v41</h1>       <p>Introduced in Cloudera Manager 7.1.1</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.1.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiAudit(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'timestamp': 'str',
        'service': 'str',
        'username': 'str',
        'impersonator': 'str',
        'ip_address': 'str',
        'command': 'str',
        'resource': 'str',
        'operation_text': 'str',
        'allowed': 'bool'
    }

    attribute_map = {
        'timestamp': 'timestamp',
        'service': 'service',
        'username': 'username',
        'impersonator': 'impersonator',
        'ip_address': 'ipAddress',
        'command': 'command',
        'resource': 'resource',
        'operation_text': 'operationText',
        'allowed': 'allowed'
    }

    def __init__(self, timestamp=None, service=None, username=None, impersonator=None, ip_address=None, command=None, resource=None, operation_text=None, allowed=None):
        """
        ApiAudit - a model defined in Swagger
        """

        self._timestamp = None
        self._service = None
        self._username = None
        self._impersonator = None
        self._ip_address = None
        self._command = None
        self._resource = None
        self._operation_text = None
        self._allowed = None

        if timestamp is not None:
          self.timestamp = timestamp
        if service is not None:
          self.service = service
        if username is not None:
          self.username = username
        if impersonator is not None:
          self.impersonator = impersonator
        if ip_address is not None:
          self.ip_address = ip_address
        if command is not None:
          self.command = command
        if resource is not None:
          self.resource = resource
        if operation_text is not None:
          self.operation_text = operation_text
        if allowed is not None:
          self.allowed = allowed

    @property
    def timestamp(self):
        """
        Gets the timestamp of this ApiAudit.
        When the audit event was captured.

        :return: The timestamp of this ApiAudit.
        :rtype: str
        """
        return self._timestamp

    @timestamp.setter
    def timestamp(self, timestamp):
        """
        Sets the timestamp of this ApiAudit.
        When the audit event was captured.

        :param timestamp: The timestamp of this ApiAudit.
        :type: str
        """

        self._timestamp = timestamp

    @property
    def service(self):
        """
        Gets the service of this ApiAudit.
        Service name associated with this audit.

        :return: The service of this ApiAudit.
        :rtype: str
        """
        return self._service

    @service.setter
    def service(self, service):
        """
        Sets the service of this ApiAudit.
        Service name associated with this audit.

        :param service: The service of this ApiAudit.
        :type: str
        """

        self._service = service

    @property
    def username(self):
        """
        Gets the username of this ApiAudit.
        The user who performed this operation.

        :return: The username of this ApiAudit.
        :rtype: str
        """
        return self._username

    @username.setter
    def username(self, username):
        """
        Sets the username of this ApiAudit.
        The user who performed this operation.

        :param username: The username of this ApiAudit.
        :type: str
        """

        self._username = username

    @property
    def impersonator(self):
        """
        Gets the impersonator of this ApiAudit.
        The impersonating user (or the proxy user) who submitted this operation. This is usually applicable when using services like Oozie or Hue, who can be configured to impersonate other users and submit jobs.

        :return: The impersonator of this ApiAudit.
        :rtype: str
        """
        return self._impersonator

    @impersonator.setter
    def impersonator(self, impersonator):
        """
        Sets the impersonator of this ApiAudit.
        The impersonating user (or the proxy user) who submitted this operation. This is usually applicable when using services like Oozie or Hue, who can be configured to impersonate other users and submit jobs.

        :param impersonator: The impersonator of this ApiAudit.
        :type: str
        """

        self._impersonator = impersonator

    @property
    def ip_address(self):
        """
        Gets the ip_address of this ApiAudit.
        The IP address that the client connected from.

        :return: The ip_address of this ApiAudit.
        :rtype: str
        """
        return self._ip_address

    @ip_address.setter
    def ip_address(self, ip_address):
        """
        Sets the ip_address of this ApiAudit.
        The IP address that the client connected from.

        :param ip_address: The ip_address of this ApiAudit.
        :type: str
        """

        self._ip_address = ip_address

    @property
    def command(self):
        """
        Gets the command of this ApiAudit.
        The command/operation that was requested.

        :return: The command of this ApiAudit.
        :rtype: str
        """
        return self._command

    @command.setter
    def command(self, command):
        """
        Sets the command of this ApiAudit.
        The command/operation that was requested.

        :param command: The command of this ApiAudit.
        :type: str
        """

        self._command = command

    @property
    def resource(self):
        """
        Gets the resource of this ApiAudit.
        The resource that the operation was performed on.

        :return: The resource of this ApiAudit.
        :rtype: str
        """
        return self._resource

    @resource.setter
    def resource(self, resource):
        """
        Sets the resource of this ApiAudit.
        The resource that the operation was performed on.

        :param resource: The resource of this ApiAudit.
        :type: str
        """

        self._resource = resource

    @property
    def operation_text(self):
        """
        Gets the operation_text of this ApiAudit.
        The full text of the requested operation. E.g. the full Hive query. <p> Available since API v5.

        :return: The operation_text of this ApiAudit.
        :rtype: str
        """
        return self._operation_text

    @operation_text.setter
    def operation_text(self, operation_text):
        """
        Sets the operation_text of this ApiAudit.
        The full text of the requested operation. E.g. the full Hive query. <p> Available since API v5.

        :param operation_text: The operation_text of this ApiAudit.
        :type: str
        """

        self._operation_text = operation_text

    @property
    def allowed(self):
        """
        Gets the allowed of this ApiAudit.
        Whether the operation was allowed or denied by the authorization system.

        :return: The allowed of this ApiAudit.
        :rtype: bool
        """
        return self._allowed

    @allowed.setter
    def allowed(self, allowed):
        """
        Sets the allowed of this ApiAudit.
        Whether the operation was allowed or denied by the authorization system.

        :param allowed: The allowed of this ApiAudit.
        :type: bool
        """

        self._allowed = allowed

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiAudit):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
