# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v41</h1>       <p>Introduced in Cloudera Manager 7.1.1</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.1.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiAddCustomCertsArguments(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'location': 'str',
        'interpret_as_filenames': 'bool',
        'host_certs': 'list[ApiHostCertInfo]'
    }

    attribute_map = {
        'location': 'location',
        'interpret_as_filenames': 'interpretAsFilenames',
        'host_certs': 'hostCerts'
    }

    def __init__(self, location=None, interpret_as_filenames=None, host_certs=None):
        """
        ApiAddCustomCertsArguments - a model defined in Swagger
        """

        self._location = None
        self._interpret_as_filenames = None
        self._host_certs = None

        if location is not None:
          self.location = location
        if interpret_as_filenames is not None:
          self.interpret_as_filenames = interpret_as_filenames
        if host_certs is not None:
          self.host_certs = host_certs

    @property
    def location(self):
        """
        Gets the location of this ApiAddCustomCertsArguments.
        The location on disk to store the CMCA directory. If there is already a CMCA created there, it will be backed up, and a new one will be created in its place.

        :return: The location of this ApiAddCustomCertsArguments.
        :rtype: str
        """
        return self._location

    @location.setter
    def location(self, location):
        """
        Sets the location of this ApiAddCustomCertsArguments.
        The location on disk to store the CMCA directory. If there is already a CMCA created there, it will be backed up, and a new one will be created in its place.

        :param location: The location of this ApiAddCustomCertsArguments.
        :type: str
        """

        self._location = location

    @property
    def interpret_as_filenames(self):
        """
        Gets the interpret_as_filenames of this ApiAddCustomCertsArguments.
        Whether the following arguments are interpreted as filenames local to the Cloudera Manager host (true, default) or as the actual data for that argument: * hostCerts.hostCert * hostCerts.hostKey  If HTTPS has not been enabled on the Cloudera Manager Admin Console and API, we *strongly* recommend that you pass the arguments as filenames local to the Cloudera Manager host (i.e. set to true) to avoid leaking sensitive information over the wire in plaintext.

        :return: The interpret_as_filenames of this ApiAddCustomCertsArguments.
        :rtype: bool
        """
        return self._interpret_as_filenames

    @interpret_as_filenames.setter
    def interpret_as_filenames(self, interpret_as_filenames):
        """
        Sets the interpret_as_filenames of this ApiAddCustomCertsArguments.
        Whether the following arguments are interpreted as filenames local to the Cloudera Manager host (true, default) or as the actual data for that argument: * hostCerts.hostCert * hostCerts.hostKey  If HTTPS has not been enabled on the Cloudera Manager Admin Console and API, we *strongly* recommend that you pass the arguments as filenames local to the Cloudera Manager host (i.e. set to true) to avoid leaking sensitive information over the wire in plaintext.

        :param interpret_as_filenames: The interpret_as_filenames of this ApiAddCustomCertsArguments.
        :type: bool
        """

        self._interpret_as_filenames = interpret_as_filenames

    @property
    def host_certs(self):
        """
        Gets the host_certs of this ApiAddCustomCertsArguments.
        A list of HostCertInfo objects, which associate a hostname with the corresponding certificate and private key. Only used if customCA == true.

        :return: The host_certs of this ApiAddCustomCertsArguments.
        :rtype: list[ApiHostCertInfo]
        """
        return self._host_certs

    @host_certs.setter
    def host_certs(self, host_certs):
        """
        Sets the host_certs of this ApiAddCustomCertsArguments.
        A list of HostCertInfo objects, which associate a hostname with the corresponding certificate and private key. Only used if customCA == true.

        :param host_certs: The host_certs of this ApiAddCustomCertsArguments.
        :type: list[ApiHostCertInfo]
        """

        self._host_certs = host_certs

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiAddCustomCertsArguments):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
