# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v41</h1>       <p>Introduced in Cloudera Manager 7.1.1</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.1.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class ToolsResourceApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def echo(self, **kwargs):
        """
        Echoes the provided message back to the caller.
        Echoes the provided message back to the caller.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.echo(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str message: The message to echo back
        :return: ApiEcho
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.echo_with_http_info(**kwargs)
        else:
            (data) = self.echo_with_http_info(**kwargs)
            return data

    def echo_with_http_info(self, **kwargs):
        """
        Echoes the provided message back to the caller.
        Echoes the provided message back to the caller.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.echo_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str message: The message to echo back
        :return: ApiEcho
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['message']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method echo" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'message' in params:
            query_params.append(('message', params['message']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/tools/echo', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiEcho',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def echo_error(self, **kwargs):
        """
        Throws an error containing the given input message.
        Throws an error containing the given input message. This is what an error response looks like.  <pre>    {      \"message\": \"An error message\",      \"causes\": [ \"A list of causes\", \"Potentially null\" ]    }  </pre>  <p>The <em>message</em> field contains a description of the error. The <em>causes</em> field, if not null, contains a list of causes for the error. </p>  <p>Note that this <strong>never</strong> returns an echoMessage. Instead, the result (and all error results) has the above structure. </p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.echo_error(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str message: The error message to echo
        :return: ApiEcho
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.echo_error_with_http_info(**kwargs)
        else:
            (data) = self.echo_error_with_http_info(**kwargs)
            return data

    def echo_error_with_http_info(self, **kwargs):
        """
        Throws an error containing the given input message.
        Throws an error containing the given input message. This is what an error response looks like.  <pre>    {      \"message\": \"An error message\",      \"causes\": [ \"A list of causes\", \"Potentially null\" ]    }  </pre>  <p>The <em>message</em> field contains a description of the error. The <em>causes</em> field, if not null, contains a list of causes for the error. </p>  <p>Note that this <strong>never</strong> returns an echoMessage. Instead, the result (and all error results) has the above structure. </p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.echo_error_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str message: The error message to echo
        :return: ApiEcho
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['message']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method echo_error" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'message' in params:
            query_params.append(('message', params['message']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/tools/echoError', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiEcho',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
