# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v41</h1>       <p>Introduced in Cloudera Manager 7.1.1</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.1.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class RolesResourceApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def add_tags(self, cluster_name, role_name, service_name, **kwargs):
        """
        Attach tags to the role.
        Attach tags to the role. Tag names beginning with the prefix _cldr_ (case insensitive) are reserved for internal use by Cloudera.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_tags(cluster_name, role_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str role_name: Name of the role (required)
        :param str service_name:  (required)
        :param list[ApiEntityTag] body: List of tags to add to the role
        :return: list[ApiEntityTag]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.add_tags_with_http_info(cluster_name, role_name, service_name, **kwargs)
        else:
            (data) = self.add_tags_with_http_info(cluster_name, role_name, service_name, **kwargs)
            return data

    def add_tags_with_http_info(self, cluster_name, role_name, service_name, **kwargs):
        """
        Attach tags to the role.
        Attach tags to the role. Tag names beginning with the prefix _cldr_ (case insensitive) are reserved for internal use by Cloudera.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_tags_with_http_info(cluster_name, role_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str role_name: Name of the role (required)
        :param str service_name:  (required)
        :param list[ApiEntityTag] body: List of tags to add to the role
        :return: list[ApiEntityTag]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'role_name', 'service_name', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_tags" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `add_tags`")
        # verify the required parameter 'role_name' is set
        if ('role_name' not in params) or (params['role_name'] is None):
            raise ValueError("Missing the required parameter `role_name` when calling `add_tags`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `add_tags`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'role_name' in params:
            path_params['roleName'] = params['role_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/roles/{roleName}/tags', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[ApiEntityTag]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def bulk_delete_roles(self, cluster_name, service_name, **kwargs):
        """
        Bulk delete roles in a particular service by name.
        Bulk delete roles in a particular service by name. Fails if any role cannot be found.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.bulk_delete_roles(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name:  (required)
        :param ApiRoleNameList body: list of role names to be deleted
        :return: ApiRoleList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.bulk_delete_roles_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.bulk_delete_roles_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def bulk_delete_roles_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Bulk delete roles in a particular service by name.
        Bulk delete roles in a particular service by name. Fails if any role cannot be found.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.bulk_delete_roles_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name:  (required)
        :param ApiRoleNameList body: list of role names to be deleted
        :return: ApiRoleList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method bulk_delete_roles" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `bulk_delete_roles`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `bulk_delete_roles`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/roles/bulkDelete', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiRoleList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_roles(self, cluster_name, service_name, **kwargs):
        """
        Create new roles in a given service.
        Create new roles in a given service.  <table> <thead> <tr> <th>Service Type</th> <th>Available Role Types</th> </tr> </thead> <tbody> <tr> <td>HDFS (CDH3)</td> <td>NAMENODE, DATANODE, SECONDARYNAMENODE, BALANCER, GATEWAY</td> </tr> <tr> <td>HDFS (CDH4)</td> <td>NAMENODE, DATANODE, SECONDARYNAMENODE, BALANCER, HTTPFS, FAILOVERCONTROLLER, GATEWAY, JOURNALNODE</td> </tr> <tr> <td>HDFS (CDH5)</td> <td>NAMENODE, DATANODE, SECONDARYNAMENODE, BALANCER, HTTPFS, FAILOVERCONTROLLER, GATEWAY, JOURNALNODE, NFSGATEWAY</td> </tr> <td>MAPREDUCE</td> <td>JOBTRACKER, TASKTRACKER, GATEWAY, FAILOVERCONTROLLER,</td> </tr> <td>HBASE</td> <td>MASTER, REGIONSERVER, GATEWAY, HBASETHRIFTSERVER, HBASERESTSERVER</td> </tr> <tr> <td>YARN</td> <td>RESOURCEMANAGER, NODEMANAGER, JOBHISTORY, GATEWAY</td> </tr> <tr> <td>OOZIE</td> <td>OOZIE_SERVER</td> </tr> <tr> <td>ZOOKEEPER</td> <td>SERVER</td> </tr> <tr> <td>HUE (CDH3)</td> <td>HUE_SERVER, BEESWAX_SERVER, KT_RENEWER, JOBSUBD</td> </tr> <tr> <td>HUE (CDH4)</td> <td>HUE_SERVER, BEESWAX_SERVER, KT_RENEWER</td> </tr> <tr> <td>HUE (CDH5)</td> <td>HUE_SERVER, KT_RENEWER</td> </tr> <tr> <td>HUE (CDH5 5.5+)</td> <td>HUE_SERVER, KT_RENEWER, HUE_LOAD_BALANCER</td> </tr> <tr> <td>FLUME</td> <td>AGENT</td> </tr> <tr> <td>IMPALA (CDH4)</td> <td>IMPALAD, STATESTORE, CATALOGSERVER</td> </tr> <tr> <td>IMPALA (CDH5)</td> <td>IMPALAD, STATESTORE, CATALOGSERVER</td> </tr> <tr> <td>HIVE</td> <td>HIVESERVER2, HIVEMETASTORE, WEBHCAT, GATEWAY</td> </tr> <tr> <td>SOLR</td> <td>SOLR_SERVER, GATEWAY</td> </tr> <tr> <td>SQOOP</td> <td>SQOOP_SERVER</td> </tr> <tr> <td>SQOOP_CLIENT</td> <td>GATEWAY</td> </tr> <tr> <td>SENTRY</td> <td>SENTRY_SERVER</td> </tr> <tr> <td>ACCUMULO16</td> <td>GARBAGE_COLLECTOR, GATEWAY, ACCUMULO16_MASTER, MONITOR, ACCUMULO16_TSERVER, TRACER</td> </tr> <tr> <td>KMS</td> <td>KMS</td> </tr> <tr> <td>KS_INDEXER</td> <td>HBASE_INDEXER</td> </tr> <tr> <td>SPARK_ON_YARN</td> <td>GATEWAY, SPARK_YARN_HISTORY_SERVER</td> </tr> </tbody>  </table>  When specifying roles to be created, the names provided for each role must not conflict with the names that CM auto-generates for roles. Specifically, names of the form \"<service name>-<role type>-<arbitrary value>\" cannot be used unless the <arbitrary value> is the same one CM would use. If CM detects such a conflict, the error message will indicate what <arbitrary value> is safe to use. Alternately, a differently formatted name should be used.  Since API v6: The role name can be left blank to allow CM to generate the name.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_roles(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name:  (required)
        :param ApiRoleList body: Roles to create.
        :return: ApiRoleList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_roles_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.create_roles_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def create_roles_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Create new roles in a given service.
        Create new roles in a given service.  <table> <thead> <tr> <th>Service Type</th> <th>Available Role Types</th> </tr> </thead> <tbody> <tr> <td>HDFS (CDH3)</td> <td>NAMENODE, DATANODE, SECONDARYNAMENODE, BALANCER, GATEWAY</td> </tr> <tr> <td>HDFS (CDH4)</td> <td>NAMENODE, DATANODE, SECONDARYNAMENODE, BALANCER, HTTPFS, FAILOVERCONTROLLER, GATEWAY, JOURNALNODE</td> </tr> <tr> <td>HDFS (CDH5)</td> <td>NAMENODE, DATANODE, SECONDARYNAMENODE, BALANCER, HTTPFS, FAILOVERCONTROLLER, GATEWAY, JOURNALNODE, NFSGATEWAY</td> </tr> <td>MAPREDUCE</td> <td>JOBTRACKER, TASKTRACKER, GATEWAY, FAILOVERCONTROLLER,</td> </tr> <td>HBASE</td> <td>MASTER, REGIONSERVER, GATEWAY, HBASETHRIFTSERVER, HBASERESTSERVER</td> </tr> <tr> <td>YARN</td> <td>RESOURCEMANAGER, NODEMANAGER, JOBHISTORY, GATEWAY</td> </tr> <tr> <td>OOZIE</td> <td>OOZIE_SERVER</td> </tr> <tr> <td>ZOOKEEPER</td> <td>SERVER</td> </tr> <tr> <td>HUE (CDH3)</td> <td>HUE_SERVER, BEESWAX_SERVER, KT_RENEWER, JOBSUBD</td> </tr> <tr> <td>HUE (CDH4)</td> <td>HUE_SERVER, BEESWAX_SERVER, KT_RENEWER</td> </tr> <tr> <td>HUE (CDH5)</td> <td>HUE_SERVER, KT_RENEWER</td> </tr> <tr> <td>HUE (CDH5 5.5+)</td> <td>HUE_SERVER, KT_RENEWER, HUE_LOAD_BALANCER</td> </tr> <tr> <td>FLUME</td> <td>AGENT</td> </tr> <tr> <td>IMPALA (CDH4)</td> <td>IMPALAD, STATESTORE, CATALOGSERVER</td> </tr> <tr> <td>IMPALA (CDH5)</td> <td>IMPALAD, STATESTORE, CATALOGSERVER</td> </tr> <tr> <td>HIVE</td> <td>HIVESERVER2, HIVEMETASTORE, WEBHCAT, GATEWAY</td> </tr> <tr> <td>SOLR</td> <td>SOLR_SERVER, GATEWAY</td> </tr> <tr> <td>SQOOP</td> <td>SQOOP_SERVER</td> </tr> <tr> <td>SQOOP_CLIENT</td> <td>GATEWAY</td> </tr> <tr> <td>SENTRY</td> <td>SENTRY_SERVER</td> </tr> <tr> <td>ACCUMULO16</td> <td>GARBAGE_COLLECTOR, GATEWAY, ACCUMULO16_MASTER, MONITOR, ACCUMULO16_TSERVER, TRACER</td> </tr> <tr> <td>KMS</td> <td>KMS</td> </tr> <tr> <td>KS_INDEXER</td> <td>HBASE_INDEXER</td> </tr> <tr> <td>SPARK_ON_YARN</td> <td>GATEWAY, SPARK_YARN_HISTORY_SERVER</td> </tr> </tbody>  </table>  When specifying roles to be created, the names provided for each role must not conflict with the names that CM auto-generates for roles. Specifically, names of the form \"<service name>-<role type>-<arbitrary value>\" cannot be used unless the <arbitrary value> is the same one CM would use. If CM detects such a conflict, the error message will indicate what <arbitrary value> is safe to use. Alternately, a differently formatted name should be used.  Since API v6: The role name can be left blank to allow CM to generate the name.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_roles_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name:  (required)
        :param ApiRoleList body: Roles to create.
        :return: ApiRoleList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_roles" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `create_roles`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `create_roles`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/roles', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiRoleList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_role(self, cluster_name, role_name, service_name, **kwargs):
        """
        Deletes a role from a given service.
        Deletes a role from a given service.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_role(cluster_name, role_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str role_name: The role name. (required)
        :param str service_name:  (required)
        :return: ApiRole
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_role_with_http_info(cluster_name, role_name, service_name, **kwargs)
        else:
            (data) = self.delete_role_with_http_info(cluster_name, role_name, service_name, **kwargs)
            return data

    def delete_role_with_http_info(self, cluster_name, role_name, service_name, **kwargs):
        """
        Deletes a role from a given service.
        Deletes a role from a given service.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_role_with_http_info(cluster_name, role_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str role_name: The role name. (required)
        :param str service_name:  (required)
        :return: ApiRole
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'role_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_role" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `delete_role`")
        # verify the required parameter 'role_name' is set
        if ('role_name' not in params) or (params['role_name'] is None):
            raise ValueError("Missing the required parameter `role_name` when calling `delete_role`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `delete_role`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'role_name' in params:
            path_params['roleName'] = params['role_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/roles/{roleName}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiRole',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_tags(self, cluster_name, role_name, service_name, **kwargs):
        """
        Remove the tags associated with the role.
        Remove the tags associated with the role. Tag names beginning with the prefix _cldr_ (case insensitive) are reserved for internal use by Cloudera.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_tags(cluster_name, role_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str role_name: Name of the role to remove tags from (required)
        :param str service_name:  (required)
        :param list[ApiEntityTag] body: A list of tags to remove from the role
        :return: list[ApiEntityTag]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_tags_with_http_info(cluster_name, role_name, service_name, **kwargs)
        else:
            (data) = self.delete_tags_with_http_info(cluster_name, role_name, service_name, **kwargs)
            return data

    def delete_tags_with_http_info(self, cluster_name, role_name, service_name, **kwargs):
        """
        Remove the tags associated with the role.
        Remove the tags associated with the role. Tag names beginning with the prefix _cldr_ (case insensitive) are reserved for internal use by Cloudera.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_tags_with_http_info(cluster_name, role_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str role_name: Name of the role to remove tags from (required)
        :param str service_name:  (required)
        :param list[ApiEntityTag] body: A list of tags to remove from the role
        :return: list[ApiEntityTag]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'role_name', 'service_name', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_tags" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `delete_tags`")
        # verify the required parameter 'role_name' is set
        if ('role_name' not in params) or (params['role_name'] is None):
            raise ValueError("Missing the required parameter `role_name` when calling `delete_tags`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `delete_tags`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'role_name' in params:
            path_params['roleName'] = params['role_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/roles/{roleName}/tags', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[ApiEntityTag]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def enter_maintenance_mode(self, cluster_name, role_name, service_name, **kwargs):
        """
        Put the role into maintenance mode.
        Put the role into maintenance mode. This is a synchronous command. The result is known immediately upon return.  <p> Available since API v2. </p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.enter_maintenance_mode(cluster_name, role_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str role_name: The role name. (required)
        :param str service_name:  (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.enter_maintenance_mode_with_http_info(cluster_name, role_name, service_name, **kwargs)
        else:
            (data) = self.enter_maintenance_mode_with_http_info(cluster_name, role_name, service_name, **kwargs)
            return data

    def enter_maintenance_mode_with_http_info(self, cluster_name, role_name, service_name, **kwargs):
        """
        Put the role into maintenance mode.
        Put the role into maintenance mode. This is a synchronous command. The result is known immediately upon return.  <p> Available since API v2. </p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.enter_maintenance_mode_with_http_info(cluster_name, role_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str role_name: The role name. (required)
        :param str service_name:  (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'role_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method enter_maintenance_mode" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `enter_maintenance_mode`")
        # verify the required parameter 'role_name' is set
        if ('role_name' not in params) or (params['role_name'] is None):
            raise ValueError("Missing the required parameter `role_name` when calling `enter_maintenance_mode`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `enter_maintenance_mode`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'role_name' in params:
            path_params['roleName'] = params['role_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/roles/{roleName}/commands/enterMaintenanceMode', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def exit_maintenance_mode(self, cluster_name, role_name, service_name, **kwargs):
        """
        Take the role out of maintenance mode.
        Take the role out of maintenance mode. This is a synchronous command. The result is known immediately upon return.  <p> Available since API v2. </p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.exit_maintenance_mode(cluster_name, role_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str role_name: The role name. (required)
        :param str service_name:  (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.exit_maintenance_mode_with_http_info(cluster_name, role_name, service_name, **kwargs)
        else:
            (data) = self.exit_maintenance_mode_with_http_info(cluster_name, role_name, service_name, **kwargs)
            return data

    def exit_maintenance_mode_with_http_info(self, cluster_name, role_name, service_name, **kwargs):
        """
        Take the role out of maintenance mode.
        Take the role out of maintenance mode. This is a synchronous command. The result is known immediately upon return.  <p> Available since API v2. </p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.exit_maintenance_mode_with_http_info(cluster_name, role_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str role_name: The role name. (required)
        :param str service_name:  (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'role_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method exit_maintenance_mode" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `exit_maintenance_mode`")
        # verify the required parameter 'role_name' is set
        if ('role_name' not in params) or (params['role_name'] is None):
            raise ValueError("Missing the required parameter `role_name` when calling `exit_maintenance_mode`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `exit_maintenance_mode`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'role_name' in params:
            path_params['roleName'] = params['role_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/roles/{roleName}/commands/exitMaintenanceMode', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_full_log(self, cluster_name, role_name, service_name, **kwargs):
        """
        Retrieves the log file for the role's main process.
        Retrieves the log file for the role's main process. <p> If the role is not started, this will be the log file associated with the last time the role was run. <p> Log files are returned as plain text (type \"text/plain\").
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_full_log(cluster_name, role_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str role_name: The role to fetch logs from. (required)
        :param str service_name:  (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_full_log_with_http_info(cluster_name, role_name, service_name, **kwargs)
        else:
            (data) = self.get_full_log_with_http_info(cluster_name, role_name, service_name, **kwargs)
            return data

    def get_full_log_with_http_info(self, cluster_name, role_name, service_name, **kwargs):
        """
        Retrieves the log file for the role's main process.
        Retrieves the log file for the role's main process. <p> If the role is not started, this will be the log file associated with the last time the role was run. <p> Log files are returned as plain text (type \"text/plain\").
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_full_log_with_http_info(cluster_name, role_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str role_name: The role to fetch logs from. (required)
        :param str service_name:  (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'role_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_full_log" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `get_full_log`")
        # verify the required parameter 'role_name' is set
        if ('role_name' not in params) or (params['role_name'] is None):
            raise ValueError("Missing the required parameter `role_name` when calling `get_full_log`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `get_full_log`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'role_name' in params:
            path_params['roleName'] = params['role_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/plain'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/roles/{roleName}/logs/full', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='str',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_metrics(self, cluster_name, role_name, service_name, **kwargs):
        """
        Fetch metric readings for a particular role.
        Fetch metric readings for a particular role. <p> By default, this call will look up all metrics available for the role. If only specific metrics are desired, use the <i>metrics</i> parameter. <p> By default, the returned results correspond to a 5 minute window based on the provided end time (which defaults to the current server time). The <i>from</i> and <i>to</i> parameters can be used to control the window being queried. A maximum window of 3 hours is enforced. <p> When requesting a \"full\" view, aside from the extended properties of the returned metric data, the collection will also contain information about all metrics available for the role, even if no readings are available in the requested window.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_metrics(cluster_name, role_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str role_name: The name of the role. (required)
        :param str service_name:  (required)
        :param str _from: Start of the period to query.
        :param list[str] metrics: Filter for which metrics to query.
        :param str to: End of the period to query.
        :param str view: The view of the data to materialize, either \"summary\" or \"full\".
        :return: ApiMetricList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_metrics_with_http_info(cluster_name, role_name, service_name, **kwargs)
        else:
            (data) = self.get_metrics_with_http_info(cluster_name, role_name, service_name, **kwargs)
            return data

    def get_metrics_with_http_info(self, cluster_name, role_name, service_name, **kwargs):
        """
        Fetch metric readings for a particular role.
        Fetch metric readings for a particular role. <p> By default, this call will look up all metrics available for the role. If only specific metrics are desired, use the <i>metrics</i> parameter. <p> By default, the returned results correspond to a 5 minute window based on the provided end time (which defaults to the current server time). The <i>from</i> and <i>to</i> parameters can be used to control the window being queried. A maximum window of 3 hours is enforced. <p> When requesting a \"full\" view, aside from the extended properties of the returned metric data, the collection will also contain information about all metrics available for the role, even if no readings are available in the requested window.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_metrics_with_http_info(cluster_name, role_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str role_name: The name of the role. (required)
        :param str service_name:  (required)
        :param str _from: Start of the period to query.
        :param list[str] metrics: Filter for which metrics to query.
        :param str to: End of the period to query.
        :param str view: The view of the data to materialize, either \"summary\" or \"full\".
        :return: ApiMetricList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'role_name', 'service_name', '_from', 'metrics', 'to', 'view']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_metrics" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `get_metrics`")
        # verify the required parameter 'role_name' is set
        if ('role_name' not in params) or (params['role_name'] is None):
            raise ValueError("Missing the required parameter `role_name` when calling `get_metrics`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `get_metrics`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'role_name' in params:
            path_params['roleName'] = params['role_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []
        if '_from' in params:
            query_params.append(('from', params['_from']))
        if 'metrics' in params:
            query_params.append(('metrics', params['metrics']))
            collection_formats['metrics'] = 'multi'
        if 'to' in params:
            query_params.append(('to', params['to']))
        if 'view' in params:
            query_params.append(('view', params['view']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/roles/{roleName}/metrics', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiMetricList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_stacks_log(self, cluster_name, role_name, service_name, **kwargs):
        """
        Retrieves the stacks log file, if any, for the role's main process.
        Retrieves the stacks log file, if any, for the role's main process. Note that not all roles support periodic stacks collection.  The log files are returned as plain text (type \"text/plain\").
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_stacks_log(cluster_name, role_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str role_name: The role to fetch stacks logs from. (required)
        :param str service_name:  (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_stacks_log_with_http_info(cluster_name, role_name, service_name, **kwargs)
        else:
            (data) = self.get_stacks_log_with_http_info(cluster_name, role_name, service_name, **kwargs)
            return data

    def get_stacks_log_with_http_info(self, cluster_name, role_name, service_name, **kwargs):
        """
        Retrieves the stacks log file, if any, for the role's main process.
        Retrieves the stacks log file, if any, for the role's main process. Note that not all roles support periodic stacks collection.  The log files are returned as plain text (type \"text/plain\").
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_stacks_log_with_http_info(cluster_name, role_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str role_name: The role to fetch stacks logs from. (required)
        :param str service_name:  (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'role_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_stacks_log" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `get_stacks_log`")
        # verify the required parameter 'role_name' is set
        if ('role_name' not in params) or (params['role_name'] is None):
            raise ValueError("Missing the required parameter `role_name` when calling `get_stacks_log`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `get_stacks_log`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'role_name' in params:
            path_params['roleName'] = params['role_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/plain'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/roles/{roleName}/logs/stacks', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='str',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_stacks_logs_bundle(self, cluster_name, role_name, service_name, **kwargs):
        """
        Download a zip-compressed archive of role stacks logs.
        Download a zip-compressed archive of role stacks logs. Note that not all roles support periodic stacks collection.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_stacks_logs_bundle(cluster_name, role_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str role_name: The role to fetch the stacks logs bundle from. (required)
        :param str service_name:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_stacks_logs_bundle_with_http_info(cluster_name, role_name, service_name, **kwargs)
        else:
            (data) = self.get_stacks_logs_bundle_with_http_info(cluster_name, role_name, service_name, **kwargs)
            return data

    def get_stacks_logs_bundle_with_http_info(self, cluster_name, role_name, service_name, **kwargs):
        """
        Download a zip-compressed archive of role stacks logs.
        Download a zip-compressed archive of role stacks logs. Note that not all roles support periodic stacks collection.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_stacks_logs_bundle_with_http_info(cluster_name, role_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str role_name: The role to fetch the stacks logs bundle from. (required)
        :param str service_name:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'role_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_stacks_logs_bundle" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `get_stacks_logs_bundle`")
        # verify the required parameter 'role_name' is set
        if ('role_name' not in params) or (params['role_name'] is None):
            raise ValueError("Missing the required parameter `role_name` when calling `get_stacks_logs_bundle`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `get_stacks_logs_bundle`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'role_name' in params:
            path_params['roleName'] = params['role_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/octet-stream'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/roles/{roleName}/logs/stacksBundle', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_standard_error(self, cluster_name, role_name, service_name, **kwargs):
        """
        Retrieves the role's standard error output.
        Retrieves the role's standard error output. <p> If the role is not started, this will be the output associated with the last time the role was run. <p> Log files are returned as plain text (type \"text/plain\").
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_standard_error(cluster_name, role_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str role_name: The role to fetch stderr from. (required)
        :param str service_name:  (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_standard_error_with_http_info(cluster_name, role_name, service_name, **kwargs)
        else:
            (data) = self.get_standard_error_with_http_info(cluster_name, role_name, service_name, **kwargs)
            return data

    def get_standard_error_with_http_info(self, cluster_name, role_name, service_name, **kwargs):
        """
        Retrieves the role's standard error output.
        Retrieves the role's standard error output. <p> If the role is not started, this will be the output associated with the last time the role was run. <p> Log files are returned as plain text (type \"text/plain\").
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_standard_error_with_http_info(cluster_name, role_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str role_name: The role to fetch stderr from. (required)
        :param str service_name:  (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'role_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_standard_error" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `get_standard_error`")
        # verify the required parameter 'role_name' is set
        if ('role_name' not in params) or (params['role_name'] is None):
            raise ValueError("Missing the required parameter `role_name` when calling `get_standard_error`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `get_standard_error`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'role_name' in params:
            path_params['roleName'] = params['role_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/plain'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/roles/{roleName}/logs/stderr', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='str',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_standard_output(self, cluster_name, role_name, service_name, **kwargs):
        """
        Retrieves the role's standard output.
        Retrieves the role's standard output. <p> If the role is not started, this will be the output associated with the last time the role was run. <p> Log files are returned as plain text (type \"text/plain\").
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_standard_output(cluster_name, role_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str role_name: The role to fetch stdout from. (required)
        :param str service_name:  (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_standard_output_with_http_info(cluster_name, role_name, service_name, **kwargs)
        else:
            (data) = self.get_standard_output_with_http_info(cluster_name, role_name, service_name, **kwargs)
            return data

    def get_standard_output_with_http_info(self, cluster_name, role_name, service_name, **kwargs):
        """
        Retrieves the role's standard output.
        Retrieves the role's standard output. <p> If the role is not started, this will be the output associated with the last time the role was run. <p> Log files are returned as plain text (type \"text/plain\").
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_standard_output_with_http_info(cluster_name, role_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str role_name: The role to fetch stdout from. (required)
        :param str service_name:  (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'role_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_standard_output" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `get_standard_output`")
        # verify the required parameter 'role_name' is set
        if ('role_name' not in params) or (params['role_name'] is None):
            raise ValueError("Missing the required parameter `role_name` when calling `get_standard_output`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `get_standard_output`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'role_name' in params:
            path_params['roleName'] = params['role_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/plain'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/roles/{roleName}/logs/stdout', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='str',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def impala_diagnostics(self, cluster_name, role_name, service_name, **kwargs):
        """
        Collects diagnostics data for an Impala role.
        Collects diagnostics data for an Impala role.  <p> Available since API v31. </p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.impala_diagnostics(cluster_name, role_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str role_name: The role name. (required)
        :param str service_name:  (required)
        :param ApiImpalaRoleDiagnosticsArgs body: 
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.impala_diagnostics_with_http_info(cluster_name, role_name, service_name, **kwargs)
        else:
            (data) = self.impala_diagnostics_with_http_info(cluster_name, role_name, service_name, **kwargs)
            return data

    def impala_diagnostics_with_http_info(self, cluster_name, role_name, service_name, **kwargs):
        """
        Collects diagnostics data for an Impala role.
        Collects diagnostics data for an Impala role.  <p> Available since API v31. </p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.impala_diagnostics_with_http_info(cluster_name, role_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str role_name: The role name. (required)
        :param str service_name:  (required)
        :param ApiImpalaRoleDiagnosticsArgs body: 
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'role_name', 'service_name', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method impala_diagnostics" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `impala_diagnostics`")
        # verify the required parameter 'role_name' is set
        if ('role_name' not in params) or (params['role_name'] is None):
            raise ValueError("Missing the required parameter `role_name` when calling `impala_diagnostics`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `impala_diagnostics`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'role_name' in params:
            path_params['roleName'] = params['role_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/roles/{roleName}/commands/impalaDiagnostics', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_active_commands(self, cluster_name, role_name, service_name, **kwargs):
        """
        List active role commands.
        List active role commands.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_active_commands(cluster_name, role_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str role_name: The role to start. (required)
        :param str service_name:  (required)
        :param str view: The view of the data to materialize, either \"summary\" or \"full\".
        :return: ApiCommandList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_active_commands_with_http_info(cluster_name, role_name, service_name, **kwargs)
        else:
            (data) = self.list_active_commands_with_http_info(cluster_name, role_name, service_name, **kwargs)
            return data

    def list_active_commands_with_http_info(self, cluster_name, role_name, service_name, **kwargs):
        """
        List active role commands.
        List active role commands.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_active_commands_with_http_info(cluster_name, role_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str role_name: The role to start. (required)
        :param str service_name:  (required)
        :param str view: The view of the data to materialize, either \"summary\" or \"full\".
        :return: ApiCommandList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'role_name', 'service_name', 'view']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_active_commands" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `list_active_commands`")
        # verify the required parameter 'role_name' is set
        if ('role_name' not in params) or (params['role_name'] is None):
            raise ValueError("Missing the required parameter `role_name` when calling `list_active_commands`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `list_active_commands`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'role_name' in params:
            path_params['roleName'] = params['role_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []
        if 'view' in params:
            query_params.append(('view', params['view']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/roles/{roleName}/commands', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommandList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_commands(self, cluster_name, role_name, service_name, **kwargs):
        """
        Lists all the commands that can be executed by name on the provided role.
        Lists all the commands that can be executed by name on the provided role.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_commands(cluster_name, role_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str role_name: the role name. (required)
        :param str service_name:  (required)
        :return: ApiCommandMetadataList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_commands_with_http_info(cluster_name, role_name, service_name, **kwargs)
        else:
            (data) = self.list_commands_with_http_info(cluster_name, role_name, service_name, **kwargs)
            return data

    def list_commands_with_http_info(self, cluster_name, role_name, service_name, **kwargs):
        """
        Lists all the commands that can be executed by name on the provided role.
        Lists all the commands that can be executed by name on the provided role.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_commands_with_http_info(cluster_name, role_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str role_name: the role name. (required)
        :param str service_name:  (required)
        :return: ApiCommandMetadataList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'role_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_commands" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `list_commands`")
        # verify the required parameter 'role_name' is set
        if ('role_name' not in params) or (params['role_name'] is None):
            raise ValueError("Missing the required parameter `role_name` when calling `list_commands`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `list_commands`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'role_name' in params:
            path_params['roleName'] = params['role_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/roles/{roleName}/commandsByName', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommandMetadataList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def read_role(self, cluster_name, role_name, service_name, **kwargs):
        """
        Retrieves detailed information about a role.
        Retrieves detailed information about a role.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_role(cluster_name, role_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str role_name: The role name. (required)
        :param str service_name:  (required)
        :param str view: The view to materialize. Defaults to 'full'.
        :return: ApiRole
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.read_role_with_http_info(cluster_name, role_name, service_name, **kwargs)
        else:
            (data) = self.read_role_with_http_info(cluster_name, role_name, service_name, **kwargs)
            return data

    def read_role_with_http_info(self, cluster_name, role_name, service_name, **kwargs):
        """
        Retrieves detailed information about a role.
        Retrieves detailed information about a role.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_role_with_http_info(cluster_name, role_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str role_name: The role name. (required)
        :param str service_name:  (required)
        :param str view: The view to materialize. Defaults to 'full'.
        :return: ApiRole
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'role_name', 'service_name', 'view']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_role" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `read_role`")
        # verify the required parameter 'role_name' is set
        if ('role_name' not in params) or (params['role_name'] is None):
            raise ValueError("Missing the required parameter `role_name` when calling `read_role`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `read_role`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'role_name' in params:
            path_params['roleName'] = params['role_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []
        if 'view' in params:
            query_params.append(('view', params['view']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/roles/{roleName}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiRole',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def read_role_config(self, cluster_name, role_name, service_name, **kwargs):
        """
        Retrieves the configuration of a specific role.
        Retrieves the configuration of a specific role. Note that the \"full\" view performs validation on the configuration, which could take a few seconds on a large cluster (around 500 nodes or more).
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_role_config(cluster_name, role_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str role_name: The role to look up. (required)
        :param str service_name:  (required)
        :param str view: The view of the data to materialize, either \"summary\" or \"full\".
        :return: ApiConfigList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.read_role_config_with_http_info(cluster_name, role_name, service_name, **kwargs)
        else:
            (data) = self.read_role_config_with_http_info(cluster_name, role_name, service_name, **kwargs)
            return data

    def read_role_config_with_http_info(self, cluster_name, role_name, service_name, **kwargs):
        """
        Retrieves the configuration of a specific role.
        Retrieves the configuration of a specific role. Note that the \"full\" view performs validation on the configuration, which could take a few seconds on a large cluster (around 500 nodes or more).
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_role_config_with_http_info(cluster_name, role_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str role_name: The role to look up. (required)
        :param str service_name:  (required)
        :param str view: The view of the data to materialize, either \"summary\" or \"full\".
        :return: ApiConfigList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'role_name', 'service_name', 'view']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_role_config" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `read_role_config`")
        # verify the required parameter 'role_name' is set
        if ('role_name' not in params) or (params['role_name'] is None):
            raise ValueError("Missing the required parameter `role_name` when calling `read_role_config`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `read_role_config`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'role_name' in params:
            path_params['roleName'] = params['role_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []
        if 'view' in params:
            query_params.append(('view', params['view']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/roles/{roleName}/config', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiConfigList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def read_roles(self, cluster_name, service_name, **kwargs):
        """
        Lists all roles of a given service.
        Lists all roles of a given service.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_roles(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name:  (required)
        :param str filter: Optional query to filter the roles by. <p> The query specifies the intersection of a list of constraints, joined together with semicolons (without spaces). For example: hostname==host1.abc.com;type==DATANODE </p>  Currently supports filtering by: <ul> <li>hostname: The hostname of the host the role is running on.</li> <li>hostId: The unique identifier of the host the role is running on.</li> <li>type: The role's type.</li> </ul>
        :param str view: DataView for getting roles. Defaults to 'summary'.
        :return: ApiRoleList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.read_roles_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.read_roles_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def read_roles_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Lists all roles of a given service.
        Lists all roles of a given service.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_roles_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name:  (required)
        :param str filter: Optional query to filter the roles by. <p> The query specifies the intersection of a list of constraints, joined together with semicolons (without spaces). For example: hostname==host1.abc.com;type==DATANODE </p>  Currently supports filtering by: <ul> <li>hostname: The hostname of the host the role is running on.</li> <li>hostId: The unique identifier of the host the role is running on.</li> <li>type: The role's type.</li> </ul>
        :param str view: DataView for getting roles. Defaults to 'summary'.
        :return: ApiRoleList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name', 'filter', 'view']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_roles" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `read_roles`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `read_roles`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []
        if 'filter' in params:
            query_params.append(('filter', params['filter']))
        if 'view' in params:
            query_params.append(('view', params['view']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/roles', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiRoleList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def read_tags(self, cluster_name, role_name, service_name, **kwargs):
        """
        Returns the tags associated with this role.
        Returns the tags associated with this role. Tag names beginning with the prefix _cldr_ (case insensitive) are reserved for internal use by Cloudera.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_tags(cluster_name, role_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str role_name: The name of the role (required)
        :param str service_name:  (required)
        :param int limit: Number of tags
        :param int offset: Index of the first tag to retrieve
        :return: list[ApiEntityTag]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.read_tags_with_http_info(cluster_name, role_name, service_name, **kwargs)
        else:
            (data) = self.read_tags_with_http_info(cluster_name, role_name, service_name, **kwargs)
            return data

    def read_tags_with_http_info(self, cluster_name, role_name, service_name, **kwargs):
        """
        Returns the tags associated with this role.
        Returns the tags associated with this role. Tag names beginning with the prefix _cldr_ (case insensitive) are reserved for internal use by Cloudera.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_tags_with_http_info(cluster_name, role_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str role_name: The name of the role (required)
        :param str service_name:  (required)
        :param int limit: Number of tags
        :param int offset: Index of the first tag to retrieve
        :return: list[ApiEntityTag]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'role_name', 'service_name', 'limit', 'offset']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_tags" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `read_tags`")
        # verify the required parameter 'role_name' is set
        if ('role_name' not in params) or (params['role_name'] is None):
            raise ValueError("Missing the required parameter `role_name` when calling `read_tags`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `read_tags`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'role_name' in params:
            path_params['roleName'] = params['role_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))
        if 'offset' in params:
            query_params.append(('offset', params['offset']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/roles/{roleName}/tags', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[ApiEntityTag]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_role_config(self, cluster_name, role_name, service_name, **kwargs):
        """
        Updates the role configuration with the given values.
        Updates the role configuration with the given values. <p> If a value is set in the given configuration, it will be added to the role's configuration, replacing any existing entries. If a value is unset (its value is null), the existing configuration for the attribute will be erased, if any. <p> Attributes that are not listed in the input will maintain their current values in the configuration.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_role_config(cluster_name, role_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str role_name: The role to modify. (required)
        :param str service_name:  (required)
        :param str message: Optional message describing the changes.
        :param ApiConfigList body: Configuration changes.
        :return: ApiConfigList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_role_config_with_http_info(cluster_name, role_name, service_name, **kwargs)
        else:
            (data) = self.update_role_config_with_http_info(cluster_name, role_name, service_name, **kwargs)
            return data

    def update_role_config_with_http_info(self, cluster_name, role_name, service_name, **kwargs):
        """
        Updates the role configuration with the given values.
        Updates the role configuration with the given values. <p> If a value is set in the given configuration, it will be added to the role's configuration, replacing any existing entries. If a value is unset (its value is null), the existing configuration for the attribute will be erased, if any. <p> Attributes that are not listed in the input will maintain their current values in the configuration.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_role_config_with_http_info(cluster_name, role_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str role_name: The role to modify. (required)
        :param str service_name:  (required)
        :param str message: Optional message describing the changes.
        :param ApiConfigList body: Configuration changes.
        :return: ApiConfigList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'role_name', 'service_name', 'message', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_role_config" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `update_role_config`")
        # verify the required parameter 'role_name' is set
        if ('role_name' not in params) or (params['role_name'] is None):
            raise ValueError("Missing the required parameter `role_name` when calling `update_role_config`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `update_role_config`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'role_name' in params:
            path_params['roleName'] = params['role_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []
        if 'message' in params:
            query_params.append(('message', params['message']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/roles/{roleName}/config', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiConfigList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
