# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v41</h1>       <p>Introduced in Cloudera Manager 7.1.1</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.1.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class DataContextsResourceApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def create_data_context(self, **kwargs):
        """
        Create a datacontext.
        Create a datacontext. Following are are required fields of ApiDataContext ApiDataContext#setName(String) <br> ApiDataContext#setDisplayName(String) <br> ApiDataContext#setServices(java.util.List) <br>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_data_context(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ApiDataContext body: DataContext to be created.
        :return: ApiDataContext
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_data_context_with_http_info(**kwargs)
        else:
            (data) = self.create_data_context_with_http_info(**kwargs)
            return data

    def create_data_context_with_http_info(self, **kwargs):
        """
        Create a datacontext.
        Create a datacontext. Following are are required fields of ApiDataContext ApiDataContext#setName(String) <br> ApiDataContext#setDisplayName(String) <br> ApiDataContext#setServices(java.util.List) <br>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_data_context_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ApiDataContext body: DataContext to be created.
        :return: ApiDataContext
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_data_context" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/dataContexts', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiDataContext',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_data_context(self, data_context_name, **kwargs):
        """
        Delete a datacontext.
        Delete a datacontext.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_data_context(data_context_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str data_context_name: Name of the datacontext. (required)
        :return: ApiDataContext
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_data_context_with_http_info(data_context_name, **kwargs)
        else:
            (data) = self.delete_data_context_with_http_info(data_context_name, **kwargs)
            return data

    def delete_data_context_with_http_info(self, data_context_name, **kwargs):
        """
        Delete a datacontext.
        Delete a datacontext.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_data_context_with_http_info(data_context_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str data_context_name: Name of the datacontext. (required)
        :return: ApiDataContext
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['data_context_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_data_context" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'data_context_name' is set
        if ('data_context_name' not in params) or (params['data_context_name'] is None):
            raise ValueError("Missing the required parameter `data_context_name` when calling `delete_data_context`")


        collection_formats = {}

        path_params = {}
        if 'data_context_name' in params:
            path_params['dataContextName'] = params['data_context_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/dataContexts/{dataContextName}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiDataContext',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def read_data_context(self, data_context_name, **kwargs):
        """
        Reads information about a datacontext.
        Reads information about a datacontext.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_data_context(data_context_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str data_context_name: Name of the datacontext. (required)
        :return: ApiDataContext
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.read_data_context_with_http_info(data_context_name, **kwargs)
        else:
            (data) = self.read_data_context_with_http_info(data_context_name, **kwargs)
            return data

    def read_data_context_with_http_info(self, data_context_name, **kwargs):
        """
        Reads information about a datacontext.
        Reads information about a datacontext.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_data_context_with_http_info(data_context_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str data_context_name: Name of the datacontext. (required)
        :return: ApiDataContext
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['data_context_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_data_context" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'data_context_name' is set
        if ('data_context_name' not in params) or (params['data_context_name'] is None):
            raise ValueError("Missing the required parameter `data_context_name` when calling `read_data_context`")


        collection_formats = {}

        path_params = {}
        if 'data_context_name' in params:
            path_params['dataContextName'] = params['data_context_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/dataContexts/{dataContextName}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiDataContext',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def read_data_contexts(self, **kwargs):
        """
        Get all the datacontexts.
        Get all the datacontexts.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_data_contexts(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: ApiDataContextList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.read_data_contexts_with_http_info(**kwargs)
        else:
            (data) = self.read_data_contexts_with_http_info(**kwargs)
            return data

    def read_data_contexts_with_http_info(self, **kwargs):
        """
        Get all the datacontexts.
        Get all the datacontexts.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_data_contexts_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: ApiDataContextList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_data_contexts" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/dataContexts', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiDataContextList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
