# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v41</h1>       <p>Introduced in Cloudera Manager 7.1.1</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.1.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class AuthServiceRoleConfigGroupsResourceApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def read_config(self, role_config_group_name, **kwargs):
        """
        Returns the current revision of the config for the specified role config group in the Authentication Service.
        Returns the current revision of the config for the specified role config group in the Authentication Service.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_config(role_config_group_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str role_config_group_name: The name of the role config group. (required)
        :param str view: The view of the data to materialize, either \"summary\" or \"full\".
        :return: ApiConfigList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.read_config_with_http_info(role_config_group_name, **kwargs)
        else:
            (data) = self.read_config_with_http_info(role_config_group_name, **kwargs)
            return data

    def read_config_with_http_info(self, role_config_group_name, **kwargs):
        """
        Returns the current revision of the config for the specified role config group in the Authentication Service.
        Returns the current revision of the config for the specified role config group in the Authentication Service.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_config_with_http_info(role_config_group_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str role_config_group_name: The name of the role config group. (required)
        :param str view: The view of the data to materialize, either \"summary\" or \"full\".
        :return: ApiConfigList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['role_config_group_name', 'view']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_config" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'role_config_group_name' is set
        if ('role_config_group_name' not in params) or (params['role_config_group_name'] is None):
            raise ValueError("Missing the required parameter `role_config_group_name` when calling `read_config`")


        collection_formats = {}

        path_params = {}
        if 'role_config_group_name' in params:
            path_params['roleConfigGroupName'] = params['role_config_group_name']

        query_params = []
        if 'view' in params:
            query_params.append(('view', params['view']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/authService/roleConfigGroups/{roleConfigGroupName}/config', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiConfigList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def read_role_config_group(self, role_config_group_name, **kwargs):
        """
        Returns the information for a given role config group in the Authentication Service.
        Returns the information for a given role config group in the Authentication Service.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_role_config_group(role_config_group_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str role_config_group_name: The name of the requested group. (required)
        :return: ApiRoleConfigGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.read_role_config_group_with_http_info(role_config_group_name, **kwargs)
        else:
            (data) = self.read_role_config_group_with_http_info(role_config_group_name, **kwargs)
            return data

    def read_role_config_group_with_http_info(self, role_config_group_name, **kwargs):
        """
        Returns the information for a given role config group in the Authentication Service.
        Returns the information for a given role config group in the Authentication Service.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_role_config_group_with_http_info(role_config_group_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str role_config_group_name: The name of the requested group. (required)
        :return: ApiRoleConfigGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['role_config_group_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_role_config_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'role_config_group_name' is set
        if ('role_config_group_name' not in params) or (params['role_config_group_name'] is None):
            raise ValueError("Missing the required parameter `role_config_group_name` when calling `read_role_config_group`")


        collection_formats = {}

        path_params = {}
        if 'role_config_group_name' in params:
            path_params['roleConfigGroupName'] = params['role_config_group_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/authService/roleConfigGroups/{roleConfigGroupName}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiRoleConfigGroup',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def read_role_config_groups(self, **kwargs):
        """
        Returns the information for all role config groups in the Authentication Service.
        Returns the information for all role config groups in the Authentication Service.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_role_config_groups(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: ApiRoleConfigGroupList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.read_role_config_groups_with_http_info(**kwargs)
        else:
            (data) = self.read_role_config_groups_with_http_info(**kwargs)
            return data

    def read_role_config_groups_with_http_info(self, **kwargs):
        """
        Returns the information for all role config groups in the Authentication Service.
        Returns the information for all role config groups in the Authentication Service.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_role_config_groups_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: ApiRoleConfigGroupList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_role_config_groups" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/authService/roleConfigGroups', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiRoleConfigGroupList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def read_roles(self, role_config_group_name, **kwargs):
        """
        Returns all roles in the given role config group in the Authentication Service.
        Returns all roles in the given role config group in the Authentication Service.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_roles(role_config_group_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str role_config_group_name: The name of the role config group. (required)
        :return: ApiRoleList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.read_roles_with_http_info(role_config_group_name, **kwargs)
        else:
            (data) = self.read_roles_with_http_info(role_config_group_name, **kwargs)
            return data

    def read_roles_with_http_info(self, role_config_group_name, **kwargs):
        """
        Returns all roles in the given role config group in the Authentication Service.
        Returns all roles in the given role config group in the Authentication Service.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_roles_with_http_info(role_config_group_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str role_config_group_name: The name of the role config group. (required)
        :return: ApiRoleList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['role_config_group_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_roles" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'role_config_group_name' is set
        if ('role_config_group_name' not in params) or (params['role_config_group_name'] is None):
            raise ValueError("Missing the required parameter `role_config_group_name` when calling `read_roles`")


        collection_formats = {}

        path_params = {}
        if 'role_config_group_name' in params:
            path_params['roleConfigGroupName'] = params['role_config_group_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/authService/roleConfigGroups/{roleConfigGroupName}/roles', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiRoleList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_config(self, role_config_group_name, **kwargs):
        """
        Updates the config for the given role config group in the Authentication Service.
        Updates the config for the given role config group in the Authentication Service.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_config(role_config_group_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str role_config_group_name: The name of the role config group. (required)
        :param str message: Optional message describing the changes.
        :param ApiConfigList body: The new config information for the group.
        :return: ApiConfigList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_config_with_http_info(role_config_group_name, **kwargs)
        else:
            (data) = self.update_config_with_http_info(role_config_group_name, **kwargs)
            return data

    def update_config_with_http_info(self, role_config_group_name, **kwargs):
        """
        Updates the config for the given role config group in the Authentication Service.
        Updates the config for the given role config group in the Authentication Service.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_config_with_http_info(role_config_group_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str role_config_group_name: The name of the role config group. (required)
        :param str message: Optional message describing the changes.
        :param ApiConfigList body: The new config information for the group.
        :return: ApiConfigList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['role_config_group_name', 'message', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_config" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'role_config_group_name' is set
        if ('role_config_group_name' not in params) or (params['role_config_group_name'] is None):
            raise ValueError("Missing the required parameter `role_config_group_name` when calling `update_config`")


        collection_formats = {}

        path_params = {}
        if 'role_config_group_name' in params:
            path_params['roleConfigGroupName'] = params['role_config_group_name']

        query_params = []
        if 'message' in params:
            query_params.append(('message', params['message']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/authService/roleConfigGroups/{roleConfigGroupName}/config', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiConfigList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_role_config_group(self, role_config_group_name, **kwargs):
        """
        Updates an existing role config group in the Authentication Service.
        Updates an existing role config group in the Authentication Service.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_role_config_group(role_config_group_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str role_config_group_name: The name of the group to update. (required)
        :param str message: The optional message describing the changes.
        :param ApiRoleConfigGroup body: The updated role config group.
        :return: ApiRoleConfigGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_role_config_group_with_http_info(role_config_group_name, **kwargs)
        else:
            (data) = self.update_role_config_group_with_http_info(role_config_group_name, **kwargs)
            return data

    def update_role_config_group_with_http_info(self, role_config_group_name, **kwargs):
        """
        Updates an existing role config group in the Authentication Service.
        Updates an existing role config group in the Authentication Service.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_role_config_group_with_http_info(role_config_group_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str role_config_group_name: The name of the group to update. (required)
        :param str message: The optional message describing the changes.
        :param ApiRoleConfigGroup body: The updated role config group.
        :return: ApiRoleConfigGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['role_config_group_name', 'message', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_role_config_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'role_config_group_name' is set
        if ('role_config_group_name' not in params) or (params['role_config_group_name'] is None):
            raise ValueError("Missing the required parameter `role_config_group_name` when calling `update_role_config_group`")


        collection_formats = {}

        path_params = {}
        if 'role_config_group_name' in params:
            path_params['roleConfigGroupName'] = params['role_config_group_name']

        query_params = []
        if 'message' in params:
            query_params.append(('message', params['message']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/authService/roleConfigGroups/{roleConfigGroupName}', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiRoleConfigGroup',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
