"""
`build_log_parser_test`
=======================================================================
Unit tests for parsing of build logs generated by compilers
* Author(s): Jimmy Gomez
"""
import os

from embedops_cli.eotools.log_parser.iar import SIZE_PATTERN as IAR_SIZE_PATTERN
from embedops_cli.eotools.log_parser.gnu_size_berkeley import (
    SIZE_PATTERN as GCC_SIZE_PATTERN,
)
from embedops_cli.eotools.parse import parse_storage_sizes


def test_parsing_of_iar_build_log():
    """Test parsing of build log generated by IAR"""
    parsing_regex = IAR_SIZE_PATTERN
    file_dir = os.path.dirname(os.path.realpath(__file__))
    input_filename = file_dir + "/iar_example_build.log"
    storage_sizes = parse_storage_sizes(input_filename, parsing_regex)
    assert storage_sizes["dimensions"]["build_target"] == "componentA.out"
    assert storage_sizes["flash_code_size"] == 7636
    assert storage_sizes["flash_data_size"] == 136
    assert storage_sizes["ram_size"] == 1036


def test_parsing_of_gcc_build_log():
    """Test parsing of build log generated by GCC"""
    parsing_regex = GCC_SIZE_PATTERN
    file_dir = os.path.dirname(os.path.realpath(__file__))
    input_filename = file_dir + "/gcc_example_build.log"
    storage_sizes = parse_storage_sizes(input_filename, parsing_regex)
    assert storage_sizes["flash_code_size"] == 36080
    assert storage_sizes["flash_data_size"] == 664
    assert storage_sizes["ram_size"] == 50960
    assert storage_sizes["dimensions"]["build_target"] == "application.elf"
