# Generated by Django 4.1.5 on 2023-01-20 18:40

from uuid import uuid4
from django.db import migrations, models


def generate_uuids(apps, schema_editor):
    """Force uuid generation for old scrobbles"""
    Scrobble = apps.get_model('scrobbles', 'Scrobble')
    for scrobble in Scrobble.objects.all():
        if not scrobble.uuid:
            scrobble.uuid = uuid4()
            scrobble.save(update_fields=['uuid'])


def reverse_generate_uuids(apps, schema_editor):
    pass


class Migration(migrations.Migration):

    dependencies = [
        ('scrobbles', '0008_scrobble_sport_event'),
    ]

    operations = [
        migrations.AddField(
            model_name='scrobble',
            name='uuid',
            field=models.UUIDField(blank=True, editable=False, null=True),
        ),
        migrations.RunPython(
            code=generate_uuids, reverse_code=reverse_generate_uuids
        ),
    ]
