/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.utils;

import ai.h2o.mojos.runtime.MojoPipeline;
import ai.h2o.mojos.runtime.api.MojoColumnMeta;
import ai.h2o.mojos.runtime.frame.MojoFrame;
import ai.h2o.mojos.runtime.frame.MojoFrameBuilder;
import ai.h2o.mojos.runtime.frame.MojoRowBuilder;
import ai.h2o.mojos.runtime.utils.BatchedCsvMojoProcessor;
import ai.h2o.mojos.runtime.utils.Consts;
import com.opencsv.CSVReader;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.NoSuchElementException;

public class BatchedCsvReader
implements Iterable<MojoFrame>,
Iterator<MojoFrame> {
    private static final boolean STRIP_CR_FROM_LAST_COLUMN = Consts.getSysProp("parser.csv.stripCrFromLastColumn", true);
    private final Iterator<String[]> csvReaderIter;
    private final int batchSize;
    private final MojoPipeline model;
    private final int[] csvColPointers;
    private final int labelCount;
    private long totalDataRows = 0L;
    private boolean hasNext = true;

    public BatchedCsvReader(MojoPipeline model, CSVReader csvReader, int batchSize) {
        Object object;
        int n2;
        this.csvReaderIter = csvReader.iterator();
        this.batchSize = batchSize;
        this.model = model;
        String[] stringArray = this.csvReaderIter.next();
        LinkedHashMap<String, Integer> linkedHashMap = new LinkedHashMap<String, Integer>();
        Object object2 = stringArray;
        int n3 = stringArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            object = object2[n2];
            linkedHashMap.put(((String)object).trim(), linkedHashMap.size());
        }
        object2 = model.getInputMeta().getColumns();
        n3 = object2.size();
        this.csvColPointers = new int[n3];
        n2 = 0;
        object = object2.iterator();
        while (object.hasNext()) {
            MojoColumnMeta mojoColumnMeta = (MojoColumnMeta)object.next();
            Integer n4 = (Integer)linkedHashMap.get(mojoColumnMeta.getColumnName());
            if (n4 == null) {
                throw new IllegalArgumentException(String.format("Model requires column named '%s' but it is not present in input data", mojoColumnMeta.getColumnName()));
            }
            this.csvColPointers[n2] = n4;
            ++n2;
        }
        this.labelCount = stringArray.length;
    }

    public long getTotalDataRows() {
        return this.totalDataRows;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public MojoFrame next() {
        if (!this.hasNext) {
            throw new NoSuchElementException(String.format("No more data after reading %d rows", this.totalDataRows));
        }
        MojoFrameBuilder mojoFrameBuilder = this.model.getInputFrameBuilder();
        int n2 = this.csvColPointers.length;
        int n3 = 0;
        MojoRowBuilder mojoRowBuilder = mojoFrameBuilder.getMojoRowBuilder();
        while (this.csvReaderIter.hasNext()) {
            String[] stringArray = this.csvReaderIter.next();
            if (stringArray.length != this.labelCount) {
                throw new IllegalArgumentException(String.format("Invalid CSV data: row #%d (in current batch) has %d columns but header defines %d columns", this.totalDataRows, stringArray.length, this.labelCount));
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                int n4 = this.csvColPointers[i2];
                String string = STRIP_CR_FROM_LAST_COLUMN && n4 == n2 - 1 ? BatchedCsvMojoProcessor.stripCrFromEol(stringArray[n4]) : stringArray[n4];
                mojoRowBuilder.setValue(i2, string);
            }
            mojoRowBuilder = mojoFrameBuilder.addRow(mojoRowBuilder);
            ++this.totalDataRows;
            if (++n3 < this.batchSize) continue;
        }
        this.hasNext = this.csvReaderIter.hasNext();
        return mojoFrameBuilder.toMojoFrame();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public Iterator<MojoFrame> iterator() {
        return this;
    }
}

