# Copyright (C) 2020  Fabian Köhler <fabian.koehler@protonmail.ch>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.

from wgadmin import util

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from wgadmin.peer import Peer


class Connection:
    def __init__(self, peer_a: "Peer", peer_b: "Peer", psk: str = ""):
        self.peer_a = peer_a
        self.peer_b = peer_b

        if psk:
            self.psk = psk
        else:
            self.psk = util.generate_psk()
