#!/usr/bin/env python3
# -*- coding: utf-8 -*-
u"""Se crea la constante TESTS_TRANSCRIPCION que contiene textos de test y sus transcripciones correctas
"""

__author__ = "Iván Arias Rodríguez"
__copyright__ = "Copyright 2017, Iván Arias Rodríguez"
__credits__ = [""]
__license__ = "GPL"  # No estoy seguro
__version__ = "1.0.1"
__maintainer__ = "Iván Arias Rodríguez"
__email__ = "ivan.arias.rodriguez@gmail.com"
__status__ = "Development"  # "Prototype", "Production"


TESTS_TRANSCRIPCION = []
TESTS_TRANSCRIPCION += [(u'Los metros son históricos, mientras que el ritmo se confunde con el lenguaje '
                         u'mismo. No es difícil distinguir en cada metro los elementos intelectuales y '
                         u'abstractos y los más puramente rítmicos. En las lenguas modernas los metros '
                         u'están compuestos por un determinado número de sílabas, duración cortada por '
                         u'acentos tónicos y pausas. Los acentos y las pausas constituyen la porción más '
                         u'antigua y puramente rítmica del metro; están cerca aún del golpe del tambor, '
                         u'de la ceremonia ritual y del talón danzante que hiere la tierra. El acento es '
                         u'danza y rito. Gracias al acento, el metro se pone en pie y es unidad danzante. '
                         u'La medida silábica implica un principio de abstracción, una retórica y una '
                         u'reflexión sobre el lenguaje. Duración puramente lineal, tiende a convertirse '
                         u'en mecánica pura. Los acentos, las pausas, las aliteraciones, los choques o '
                         u'reuniones inesperadas de un sonido con otro, constituyen la porción concreta y '
                         u'permanente del metro.',
                         u'[lɔs̬.ˈme.t̪ɾo.ˈsːo.ni̞s̪.ˈt̪o.ɾi.k̠ɔs|ˈmj̃ẽn̪.t̪ɾas.k̟ɛːl.ˈri̞ð̞.mo.'
                         u'se.k̠ɔɱ.ˈfu̞n̪.d̪e.k̠o.ne.lːeŋ.ˈɡwɑ.xe.ˈmi̞s̬.mo‖no.ˈez̪.ð̞i.ˈfi.'
                         u'θi̞l̪.d̪i̞s̪.t̪i̞ŋ.ˈɡi.ɾeŋ.ˈka.ð̞a.ˈme.t̪ɾo.lo.se.le.ˈmẽn̪.t̪o.si̞n̪.'
                         u't̪e.lɛɣ̞.ˈt̪wa.le.sjas̪.ˈt̪ɾaɣ̞.t̪o.si.lɔs̬.ˈmas.ˌpu.ɾa.ˈmẽn̪.t̪ɛ.'
                         u'ˈri̞ð̞.mi.k̠ɔs‖en.las̬.ˈleŋ.ɡwas̬.mo.ˈð̞ɛɾ.nas̬.lɔs̬.ˈme.t̪ɾo.ses̪.'
                         u'ˈt̪aŋ.k̠ɔm.ˈpwes̪.t̪ɔs.po.ˈɾu̞n̪.d̪e.t̪ɛɾ.mĩ.ˈna.ð̞o.ˈnũ.me.ɾo.ð̞e.'
                         u'ˈsi.la.β̞as|d̪u.ɾa.ˈθjɔŋ.k̠ɔɾ.ˈt̪a.ð̞a.po.ɾa.ˈθen̪.t̪ɔs̪.ˈt̪o.ni.k̠o.'
                         u'si.ˈpɑu̯.sas‖lo.sa.ˈθen̪.t̪o.si.las.ˈpɑu̯.sas.k̠ɔⁿs̪.t̪i.ˈt̪u.ʝ̞en.'
                         u'la.pɔɾ.ˈθjɔⁿ.ˈma.san̪.ˈt̪i.ɣ̞wai̯.ˌpu.ɾa.ˈmẽn̪.t̪ɛ.ˈri̞ð̞.mi.ka.ð̞ɛl.'
                         u'ˈme.t̪ɾo‖es̪.ˈt̪an̟.ˈθɛɾ.kɑː.ˈu̞n̪.d̪ɛl.ˈɣ̞ɔl.pe.ð̞ɛl̪.t̪am.ˈbɔɾ|d̪e.la.'
                         u'θe.ɾe.ˈmõ.nja.ri̞.ˈt̪wa.li.ð̞ɛl̪.t̪a.ˈlɔn̪.d̪an̟.ˈθan̪.t̪e.k̟e.ˈʝ̞e.ɾe.'
                         u'la.ˈt̪jɛ.ra‖e.la.ˈθen̪.t̪o.ˈez̪.ˈð̞an̟.θai̯.ˈri̞.t̪o‖ˈɡɾa.θja.sa.la.'
                         u'ˈθen̪.t̪o|ɛl.ˈme.t̪ɾo.se.ˈpo.nẽːm.ˈpje.ˈʝ̞e.su.ni.ˈð̞a.ð̞ːan̟.'
                         u'ˈθan̪.t̪e‖la.me.ˈð̞i.ð̞a.si.ˈla.β̞i.kai̯m.ˈpli.kɑ.ˈu̞m.pɾi̞n̟.ˈθi.'
                         u'pjo.ð̞e.as̪.t̪ɾaɣ̞.ˈθjɔn|ˈu.na.rɛ.ˈt̪o.ɾi.ka.ˈʝ̞u.na.rɛ.flɛɣ̞'
                         u'.ˈsjɔn.so.β̞ɾeː.lːeŋ.ˈɡwɑ.xe‖d̪u.ɾa.ˈθjɔm.ˌpu.ɾa.ˈmẽn̪.t̪e.li.'
                         u'ne.ˈɑl|ˈt̪jen̪.d̪e.a.k̠ɔm.bɛɾ.ˈt̪i̞ɾ.seːⁿ.me.ˈka.ni.ka.ˈpu.ɾa‖lo.'
                         u'sa.ˈθen̪.t̪ɔs|las.ˈpɑu̯.sas|la.sa.li.t̪e.ɾa.ˈθjo.nes|lɔs.ˈʧo.'
                         u'k̟e.sɔ.rɛu̯.ˈnj̃õ.ne.si.nes.pe.ˈɾa.ð̞az̪.ð̞e.ˈu̞n.so.ˈni.ð̞o.k̠o.'
                         u'ˈno.t̪ɾo|k̠ɔⁿs̪.t̪i.ˈt̪u.ʝ̞en.la.pɔɾ.ˈθjɔŋ.k̠ɔŋ.ˈkɾe.t̪ai̯.pɛɾ.mã.'
                         u'ˈnẽn̪.t̪e.ð̞ɛl.ˈme.t̪ɾo]')]
TESTS_TRANSCRIPCION += [(u'Es posible que si Galileo hubiese concretado su modelo heliocentrista tras un '
                         u'éxtasis místico, la Iglesia hubiese acabado por aceptarlo sin usar la '
                         u'Inquisición como medio disuasorio para obligarle a reconocer su error. '
                         u'Pero lo hizo con una máquina diabólica: el telescopio; y con un don derivado '
                         u'de un pacto con el diablo: la observación, ampliada, eso sí, por el efecto de '
                         u'las lentes y la experimentación, merced a la cual el mundo pierde la escala '
                         u'humana y se acerca a la divinidad.',
                         u'[ˈes.po.ˈsi.β̞le.k̟e.si.ɣ̞a.li.ˈle.ou̯.ˈβ̞je.se.k̠ɔŋ.kɾe.ˈt̪a.ð̞o.'
                         u'su.mo.ˈð̞e.lo.e.ljo.θen̪.ˈt̪ɾi̞s̪.t̪a.t̪ɾa.ˈsu.ˈnes̪.t̪a.si̞s̬.ˈmi̞s̪.'
                         u't̪i.k̠o|lai̯.ˈɣ̞le.sjɑu̯.ˈβ̞je.se.a.ka.ˈβ̞a.ð̞o.po.ɾa.θeβ̞.ˈt̪aɾ.'
                         u'lo.si.nu.ˈsaɾ.lai̯ŋ.k̟i.si.ˈθjɔŋ.k̠o.mõ.ˈme.ð̞jo.ð̞i.swa.ˈso.'
                         u'ɾjo.pa.ɾɑ.o.β̞li.ˈɣ̞aɾ.le.a.rɛ.k̠o.no.ˈθɛɾ.swɛ.ˈrɔɾ‖pe.ɾo.lo.'
                         u'ˈi.θo.k̠o.ˈnũ.nã.ˈma.k̟i.na.ð̞ja.ˈβ̞o.li.ka‖ɛl̪.t̪e.les.ˈk̠o.pjo‖'
                         u'i.k̠o.ˈnũ̞n̪.ˈd̪ɔn̪.d̪e.ɾi.ˈβ̞a.ð̞o.ð̞e.ˈu̞m.ˈpaɣ̞.t̪o.k̠o.nɛl̪.ˈd̪ja.β̞lo‖'
                         u'lɑ.ɔβ̞.sɛɾ.β̞a.ˈθjɔn|am.ˈplja.ð̞a|ˈe.so.ˈsi|po.ɾe.le.ˈfɛɣ̞.t̪o.'
                         u'ð̞e.las̬.ˈlen̪.t̪e.si.la.es.pe.ɾi.mẽn̪.t̪a.ˈθjɔn|mɛɾ.ˈθe.ð̥a.la.'
                         u'ˈk̠wa.lɛl.ˈmũ̞n̪.d̪o.ˈpjɛɾ.ð̞e.la.es.ˈka.lɑu̯.ˈmã.nai̯.se.a.ˈθɛɾ.'
                         u'kaː.la.ð̞i.β̞i.ni.ˈð̞að̥]')]
TESTS_TRANSCRIPCION += [(u'Señorita: esta misma mañana, bajo la dulce llovizna del cielo, cruzó usted, '
                         u'aparición fortuita, por delante de la puerta de la casa donde aún vivo y ya '
                         u'no tengo hogar. Cuando desperté, fui a la puerta de la suya, donde ignoro si '
                         u'tiene usted hogar o no le tiene. Me habían llevado allí sus ojos, sus ojos, '
                         u'que son refulgentes estrellas mellizas en la nebulosa de mi mundo. Perdóneme, '
                         u'Eugenia, y deje que le dé familiarmente este dulce nombre; perdóneme la lírica. '
                         u'Yo vivo en perpetua lírica infinitesimal.',
                         u'[se.ɲo.ˈɾi.t̪a‖ˈes̪.t̪a.ˈmi̞s̬.mã.mã.ˈɲã.na|bɑ.χo.la.ˈð̞u̞l̟.θe.ʎo.'
                         u'ˈβ̞i̞θ̬.na.ð̞ɛl̟.ˈθje.lo|kɾu.ˈθou̯s̪.ˈt̪eð̥|a.pa.ɾi.ˈθjɔɱ.fɔɾ.ˈt̪wi.'
                         u't̪a|pɔɾ.ð̞e.ˈlan̪.t̪e.ð̞e.la.ˈpwɛɾ.t̪a.ð̞e.la.ˈka.sa.ð̞ɔn̪.d̪e.ɑ.ˈu̞m.'
                         u'ˈbi.β̞ɔi̯.ˈʝ̞a.no.ˈt̪eŋ.ɡoː.ˈɣ̞aɾ‖k̠wan̪.d̪o.ð̞es.pɛɾ.ˈt̪e|ˈfwi.a.la.'
                         u'ˈpwɛɾ.t̪a.ð̞e.la.ˈsu.ʝ̞a|d̪ɔn̪.d̪ɛi̯ɣ̞.ˈno.ɾo.si.ˈt̪je.neu̯s̪.ˈt̪e.ð̥o.'
                         u'ˈɣ̞a.ɾo.no.le.ˈt̪je.ne‖me.a.ˈβ̞i.an̠.ʎe.ˈβ̞a.ð̞o.a.ˈʎi.su.ˈsɔ.'
                         u'χɔs|su.ˈsɔ.χɔs|k̟e.ˈsɔn.rɛ.fu̞l.ˈxen̪.t̪e.ses̪.ˈt̪ɾe.ʎas̬.me.ˈʎi.'
                         u'θa.sen.la.ne.β̞u.ˈlo.sa.ð̞e.mĩ.ˈmũ̞n̪.d̪o‖pɛɾ.ˈð̞o.nẽ.me|eu̯.ˈxe.'
                         u'nja|i.ˈð̞ɛ.xe.k̟e.le.ˈð̞e.fa.mi.ˌljaɾ.ˈmẽn̪.t̪e.ˈes̪.t̪e.ˈð̞u̞l̟.θe.'
                         u'ˈnɔ̃m.bɾe‖pɛɾ.ˈð̞o.nẽ.me.la.ˈli.ɾi.ka‖ˈɟ͡ʝ̞o.ˈβ̞i.β̞o.em.pɛɾ.'
                         u'ˈpe.t̪wa.ˈli.ɾi.kai̯ɱ.fi.ni.t̪e.si.ˈmɑl]')]
TESTS_TRANSCRIPCION += [(u'Los amores de la Guindilla y Quino, el Manco, tardaron en conocerse en el '
                         u'pueblo. Además, progresaron con una lentitud crispante. Era un paso definitivo, '
                         u'a la postre. Quino, el Manco, ya había pensado en ella, en la Guindilla, antes '
                         u'del incidente con los mozos. La Guindilla no era joven y él tampoco. Por otro '
                         u'lado, la Guindilla era enjuta y delgada y poseía un negocio en marcha; y un '
                         u'evidente talento comercial. Precisamente de lo que él carecía. Últimamente, '
                         u'Quino estaba asfixiado por las hipotecas. Bien mirado, propiedad de él, lo que '
                         u'se dice de él, no restaba ni un hierbajo del huerto.',
                         u'[lo.sa.ˈmo.ɾez̪.ð̞e.la.ɣ̞i̞n̪.ˈd̪i.ʎai̯.ˈk̟i.no|ɛl.ˈmãŋ.k̠o|t̪aɾ.ˈð̞a.'
                         u'ɾo.nẽŋ.k̠o.no.ˈθɛɾ.seː.nɛl.ˈpwe.β̞lo‖a.ð̞e.ˈmas|pɾo.ɣ̞ɾe.ˈsa.'
                         u'ɾɔŋ.k̠o.ˈnũ.na.len̪.t̪i.ˈt̪u̞ð̥.kɾi̞s.ˈpan̪.t̪e‖ˈe.ɾɑ.ˈu̞m.ˈpa.so.ð̞e.'
                         u'fi.ni.ˈt̪i.β̞o|a.la.ˈpɔs̪.t̪ɾe‖ˈk̟i.no|ɛl.ˈmãŋ.k̠o|ˈɟ͡ʝ̞aː.ˈβ̞i.a.'
                         u'pen.ˈsa.ð̞o.e.ˈne.ʎa|en.la.ɣ̞i̞n̪.ˈd̪i.ʎa|ˈan̪.t̪ez̪.ð̞e.li̞n̟.θi.ˈð̞en̪.'
                         u't̪e.k̠ɔn.lɔs̬.ˈmo.θɔs‖la.ɣ̞i̞n̪.ˈd̪i.ʎa.no.ˈe.ɾɑ.ˈχo.β̞e.ˈnjɛl̪.t̪am.'
                         u'ˈpo.k̠o‖po.ˈɾo.t̪ɾo.ˈla.ð̞o|la.ɣ̞i̞n̪.ˈd̪i.ʎa.ˈe.ɾa.eɴ.ˈχu.t̪ai̯.ð̞ɛl.'
                         u'ˈɣ̞a.ð̞ai̯.po.se.ˈi.ɑ.ˈu.nːe.ˈɣ̞o.θjo.eⁿ.ˈmaɾ.ʧa‖ˈɟ͡ʝ̞u.ne.β̞i.'
                         u'ˈð̞en̪.t̪e.t̪a.ˈlen̪.t̪o.k̠o.mɛɾ.ˈθjɑl‖pɾe.ˌθi.sa.ˈmẽn̪.t̪e.ð̞e.lo.'
                         u'k̟e.ˈɛl.ka.ɾe.ˈθi.a‖ˌu̞l̪.t̪i.mã.ˈmẽn̪.t̪e|ˈk̟i.no.es̪.ˈt̪a.β̞aːs.'
                         u'fi̞ɣ̞.ˈsja.ð̞o.pɔɾ.la.si.po.ˈt̪e.kas‖ˈbjeⁿ.mi.ˈɾa.ð̞o|pɾo.pje.'
                         u'ˈð̞a.ð̞ːe.ˈɛl|lo.k̟e.se.ˈð̞i.θe.ð̞e.ˈɛl|nɔ.rɛs̪.ˈt̪a.β̞a.ˈnj̃ũ̞n̠.ɟ͡ʝ̞ɛɾ.'
                         u'ˈβ̞ɑ.χo.ð̞ɛl.ˈɣ̞wɛɾ.t̪o]')]
TESTS_TRANSCRIPCION += [(u'Julio vivía con unas tías viejas; su padre, empleado en una capital de '
                         u'provincia, era de una posición bastante modesta. Julio se mostraba muy '
                         u'independiente; podía haber buscado la protección de su primo Enrique Aracil, '
                         u'que por entonces acababa de obtener una plaza de médico en el hospital, por '
                         u'oposición, y que podía ayudarle; pero Julio no quería protección alguna, no '
                         u'iba ni a ver a su primo; pretendía debérselo todo a sí mismo. Dada su tendencia '
                         u'práctica, era un poco paradójica esta resistencia suya a ser protegido. Julio, '
                         u'muy hábil, no estudiaba casi nada, pero aprobaba siempre. Buscaba amigos menos '
                         u'inteligentes que él para explotarles; allí donde veía una superioridad '
                         u'cualquiera, fuese en el orden que fuese, se retiraba. Llegó a confesar a '
                         u'Hurtado que le molestaba pasear con gente de más estatura que él. Julio '
                         u'aprendía con gran facilidad todos los juegos. Sus padres, haciendo un '
                         u'sacrificio, podían pagarle los libros, la matrícula y la ropa. La tía de '
                         u'Julio solía darle, para que fuera alguna vez al teatro, un duro todos los meses, '
                         u'y Aracil se las arreglaba jugando a las cartas con sus amigos, de tal manera, '
                         u'que, después de ir al café y al teatro y comprar cigarrillos, al cabo del mes, '
                         u'no solo le quedaba el duro de su tía, sino que tenía dos o tres más.',
                         u'[ˈχu.ljo.β̞i.ˈβ̞i.a.k̠o.ˈnũ.nas̪.ˈt̪i.as̬.ˈβ̞jɛ.xas‖su.ˈpa.ð̞ɾe|em.ple.'
                         u'ˈa.ð̞o.e.ˈnũ.na.ka.pi.ˈt̪ɑl̪.d̪e.pɾo.ˈβ̞i̞n̟.θja|ˈe.ɾa.ð̞e.ˈu.na.po.si.'
                         u'ˈθjɔm.bas̪.ˈt̪an̪.t̪e.mo.ˈð̞es̪.t̪a‖ˈχu.ljo.se.mɔs̪.ˈt̪ɾa.β̞a.mw̃ĩ̞ːn̪.d̪e.'
                         u'pen̪.ˈd̪jen̪.t̪e‖po.ˈð̞i.aː.ˈβ̞ɛɾ.β̞u̞s.ˈka.ð̞o.la.pɾo.t̪ɛɣ̞.ˈθjɔn̪.d̪e.su.'
                         u'ˈpɾi.mo.en.ˈri̞.k̟e.a.ɾa.ˈθi̞l|k̟e.po.ɾen̪.t̪ɔn̟.θe.sa.ka.ˈβ̞a.β̞a.ð̞e.'
                         u'ɔβ̞.t̪e.ˈne.ˈɾu.na.ˈpla.θa.ð̞e.ˈme.ð̞i.k̠o.e.ne.lɔs.pi.ˈt̪ɑl|po.ɾo.'
                         u'po.si.ˈθjɔn|i.k̟e.po.ˈð̞i.aː.ʝ̞u.ˈð̞aɾ.le‖pe.ɾɔ.ˈχu.ljo.no.k̟e.ˈɾi.'
                         u'a.pɾo.t̪ɛɣ̞.ˈθjo.nɑl.ˈɣ̞u.na|no.ˈi.β̞a.nja.ˈβ̞e.ɾa.su.ˈpɾi.mo‖pɾe.'
                         u't̪en̪.ˈd̪i.a.ð̞e.ˈβ̞ɛɾ.se.lo.ˈt̪o.ð̞o.a.ˈsi.ˈmi̞s̬.mo‖ˈd̪a.ð̞a.su.t̪en̪.'
                         u'ˈd̪en̟.θja.ˈpɾaɣ̞.t̪i.ka|ˈe.ɾɑ.ˈu̞m.ˈpo.k̠o.pa.ɾa.ˈð̞ɔ.xi.ka.ˈes̪.t̪a.'
                         u'rɛ.si̞s̪.ˈt̪en̟.θja.ˈsu.ʝ̞aː.ˈsɛɾ.pɾo.t̪ɛ.ˈxi.ð̞o‖ˈχu.ljo|mu.ˈʝ̞a.β̞i̞l|'
                         u'no.es̪.t̪u.ˈð̞ja.β̞a.ˈka.si.ˈna.ð̞a|pe.ɾo.a.pɾo.ˈβ̞a.β̞a.ˈsjem.pɾe‖'
                         u'bu̞s.ˈka.β̞aː.ˈmi.ɣ̞ɔs̬.ˈmẽ.no.si̞n̪.t̪e.li̞.ˈxen̪.t̪es.k̟e.ˈɛl.pa.ɾa.es.'
                         u'plo.ˈt̪aɾ.les‖a.ˈʎi.ð̞ɔn̪.d̪e.β̞e.ˈi.ɑ.ˈu.na.su.pe.ɾjo.ɾi.ˈð̞að̥.k̠wɑl.'
                         u'ˈk̟je.ɾa|ˈfwe.seː.ne.ˈlɔɾ.ð̞eŋ.k̟e.ˈfwe.se|sɛ.rɛ.t̪i.ˈɾa.β̞a‖ʎe.ˈɣ̞o.'
                         u'a.k̠ɔɱ.fe.ˈsa.ɾɑu̯ɾ.ˈt̪a.ð̞o.k̟e.le.mo.les̪.ˈt̪a.β̞a.pa.se.ˈaɾ.k̠ɔŋ.ˈxen̪.'
                         u't̪e.ð̞e.ˈma.ses̪.t̪a.ˈt̪u.ɾa.k̟e.ˈɛl‖ˈχu.ljo.a.pɾen̪.ˈd̪i.a.k̠ɔŋ.ˈɡɾaɱ.fa.'
                         u'θi.li.ˈð̞að̥.ˈt̪o.ð̞ɔs̬.lɔs.ˈχwe.ɣ̞ɔs‖su̞s.ˈpa.ð̞ɾes|a.ˈθjen̪.d̪o.ˈu̞n.sa.'
                         u'kɾi.ˈfi.θjo|po.ˈð̞i.am.pa.ˈɣ̞aɾ.le.lɔs̬.ˈli.β̞ɾɔs|la.ma.ˈt̪ɾi.k̠u.lai̯.'
                         u'la.ˈrɔ.pa‖la.ˈt̪i.a.ð̞ɛ.ˈχu.ljo.so.ˈli.a.ˈð̞aɾ.le|pa.ɾa.k̟e.ˈfwe.ɾɑːl.'
                         u'ˈɣ̞u.na.ˈβ̞e.θɑl̪.t̪e.ˈa.t̪ɾo|ˈu̞n̪.ˈd̪u.ɾo.ˈt̪o.ð̞ɔs̬.lɔs̬.ˈme.ses|ɟ͡ʝ̞a.ɾa.'
                         u'ˈθi̞l.se.la.sa.rɛ.ˈɣ̞la.β̞ɑ.χu.ˈɣ̞an̪.d̪o.a.las.ˈkaɾ.t̪as.k̠ɔn.su.sa.'
                         u'ˈmi.ɣ̞ɔs|d̪e.ˈt̪ɑl.mã.ˈne.ɾa|k̟e|d̪es.ˈpwez̪.ð̞e.ˈi.ɾɑl.ka.ˈfe.ʝ̞ɑl̪.t̪e.'
                         u'ˈa.t̪ɾɔi̯.k̠ɔm.ˈpɾaɾ.θi.ɣ̞a.ˈri̞.ʎɔs|ɑl.ˈka.β̞o.ð̞ɛl.ˈmes|no.ˈso.lo.le.'
                         u'k̟e.ˈð̞a.β̞a.ɛl̪.ˈd̪u.ɾo.ð̞e.su.ˈt̪i.a|si.no.k̟e.t̪e.ˈni.a.ˈð̞o.so.'
                         u'ˈt̪ɾes̬.ˈmas]')]
TESTS_TRANSCRIPCION += [(u'Vetusta, la muy noble y leal ciudad, corte en lejano siglo, hacía la digestión '
                         u'del cocido y de la olla podrida, y descansaba oyendo entre sueños el monótono y '
                         u'familiar zumbido de la campana de coro, que retumbaba allá en lo alto de la '
                         u'esbelta torre en la Santa Basílica. La torre de la catedral, poema romántico '
                         u'de piedra, delicado himno, de dulces líneas de belleza muda y perenne, era '
                         u'obra del siglo dieciséis, aunque antes comenzada, de estilo gótico, pero, cabe '
                         u'decir, moderado por un instinto de prudencia y armonía que modificaba las '
                         u'vulgares exageraciones de esta arquitectura. La vista no se fatigaba '
                         u'contemplando horas y horas aquel índice de piedra que señalaba al cielo; no era '
                         u'una de esas torres cuya aguja se quiebra de sutil, más flacas que esbeltas, '
                         u'amaneradas como señoritas cursis que aprietan demasiado el corsé; era maciza '
                         u'sin perder nada de su espiritual grandeza, y hasta sus segundos corredores, '
                         u'elegante balaustrada, subía como fuerte castillo, lanzándose desde allí en '
                         u'pirámide de ángulo gracioso, inimitable en sus medidas y proporciones. Como haz '
                         u'de músculos y nervios, la piedra, enroscándose en la piedra, trepaba a la '
                         u'altura, haciendo equilibrios de acróbata en el aire; y como prodigio de juegos '
                         u'malabares, en una punta de caliza se mantenía, cual imantada, una bola grande '
                         u'de bronce dorado, y encima otra más pequeña, y sobre ésta una cruz de hierro '
                         u'que acababa en pararrayos.',
                         u'[be.ˈt̪u̞s̪.t̪a|la.mw̃ĩ.ˈno.β̞lɛi̯.le.ˈɑl̟.θju.ˈð̞að̥|ˈk̠ɔɾ.t̪eːn.'
                         u'lɛ.ˈxa.no.ˈsi.ɣ̞lo|a.ˈθi.a.la.ð̞i̞.xes̪.ˈt̪jɔn̪.d̪ɛl.k̠o.ˈθi.ð̞ɔi̯.'
                         u'ð̞e.lɑ.ˈo.ʎa.po.ˈð̞ɾi.ð̞a|i.ð̞es.kan.ˈsa.β̞ɑ.o.ˈʝ̞en̪.d̪o.en̪.t̪ɾe.'
                         u'ˈswe.ɲo.sɛl.mõ.ˈno.t̪o.nɔi̯.fa.mi.ˈljaɾ.θu̞m.ˈbi.ð̞o.ð̞e.la.'
                         u'kam.ˈpa.na.ð̞e.ˈk̠o.ɾo|k̟ɛ.rɛ.t̪u̞m.ˈba.β̞aː.ˈʎa.en.lo.ˈɑl̪.t̪o.'
                         u'ð̞e.la.es̬.ˈβ̞ɛl̪.t̪a.ˈt̪ɔ.rɛːn.la.ˈsan̪.t̪a.β̞a.ˈsi.li.ka‖'
                         u'la.ˈt̪ɔ.rɛ.ð̞e.la.ka.t̪e.ˈð̞ɾɑl|po.ˈe.ma.rɔ.ˈmãn̪.t̪i.k̠o.ð̞e.'
                         u'ˈpje.ð̞ɾa|d̪e.li.ˈka.ð̞o.ˈi̞m̥.no|d̪e.ˈð̞u̞l̟.θes̬.ˈli.ne.az̪.ð̞e.β̞e.'
                         u'ˈʎe.θa.ˈmu.ð̞ai̯.pe.ˈɾe.nːe|ˈe.ɾɑ.ˈo.β̞ɾa.ð̞ɛl.ˈsi.ɣ̞lo.ð̞je.θi.'
                         u'ˈsɛi̯s|ɑu̯ŋ.k̟e.ˈan̪.t̪es.k̠o.mẽn̟.ˈθa.ð̞a|d̪eːs̪.ˈt̪i.lo.ˈɣ̞o.t̪i.k̠o|'
                         u'pe.ɾo|ˈka.β̞e.ð̞e.ˈθi̞ɾ|mo.ð̞e.ˈɾa.ð̞o.po.ˈɾu.nĩ̞ⁿs̪.ˈt̪i̞n̪.t̪o.ð̞e.'
                         u'pɾu.ˈð̞en̟.θja.ʝ̞aɾ.mõ.ˈni.a.k̟e.mo.ð̞i.fi.ˈka.β̞a.las̬.β̞u̞l.'
                         u'ˈɣ̞a.ɾe.sɛɣ̞.sɑ.xe.ɾa.ˈθjo.nez̪.ð̞e.ˈes̪.t̪aːɾ.k̟i.t̪ɛɣ̞.ˈt̪u.ɾa‖'
                         u'la.ˈβ̞i̞s̪.t̪a.no.se.fa.t̪i.ˈɣ̞a.β̞a.k̠ɔn̪.t̪em.ˈplan̪.d̪o.ˈo.ɾa.'
                         u'ˈsjo.ɾa.sa.ˈk̟e.ˈli̞n̪.d̪i.θe.ð̞e.ˈpje.ð̞ɾa.k̟e.se.ɲa.ˈla.β̞ɑːl̟.'
                         u'ˈθje.lo‖no.ˈe.ɾɑ.ˈu.na.ð̞e.ˈe.sas̪.ˈt̪ɔ.rɛs.k̠u.ʝ̞aː.ˈɣ̞u̞.xa.se.'
                         u'ˈk̟je.β̞ɾa.ð̞e.su.ˈt̪i̞l|ˈmas.ˈfla.kas.k̟eːs̬.ˈβ̞ɛl̪.t̪as|'
                         u'a.mã.ne.ˈɾa.ð̞as.k̠o.mo.se.ɲo.ˈɾi.t̪as.ˈk̠u̞ɾ.si̞s.k̟e.a.ˈpɾje.'
                         u't̪an̪.d̪e.ma.ˈsja.ð̞o.ɛl.k̠ɔɾ.ˈse‖ˈe.ɾa.ma.ˈθi.θa.si̞m.pɛɾ.'
                         u'ˈð̞ɛɾ.ˈna.ð̞a.ð̞e.swes.pi.ɾi.ˈt̪wɑl.ɣ̞ɾan̪.ˈd̪e.θa|ɟ͡ʝ̞as̪.t̪a.'
                         u'su.sːe.ˈɣ̞u̞n̪.d̪ɔs.k̠ɔ.rɛ.ˈð̞o.ɾes|e.le.ˈɣ̞an̪.t̪e.β̞a.lɑu̯s̪.ˈt̪ɾa.ð̞a|'
                         u'su.ˈβ̞i.a.k̠o.mo.ˈfwɛɾ.t̪e.kas̪.ˈt̪i.ʎo|lan̟.ˈθan̪.d̪o.se.ð̞ez̪.ð̞e.'
                         u'a.ˈʎi.em.pi.ˈɾa.mi.ð̞e.ð̞e.ˈaŋ.ɡu.lo.ɣ̞ɾa.ˈθjo.so|'
                         u'i.nĩ.mi.ˈt̪a.β̞leːn.su̞s̬.me.ˈð̞i.ð̞a.si.pɾo.pɔɾ.ˈθjo.nes‖'
                         u'k̠o.mo.ˈaθ̬.ð̞e.ˈmu̞s.k̠u.lo.si.ˈnɛɾ.β̞jɔs|la.ˈpje.ð̞ɾa|en.rɔs.'
                         u'ˈkan̪.d̪o.seːn.la.ˈpje.ð̞ɾa|t̪ɾe.ˈpa.β̞aː.lɑːl̪.ˈt̪u.ɾa|a.ˈθjen̪.'
                         u'd̪o.e.k̟i.ˈli.β̞ɾjɔz̪.ð̞e.a.ˈkɾo.β̞a.t̪a.e.ne.ˈlai̯.ɾe‖i.k̠o.mo.'
                         u'pɾo.ˈð̞i̞.xjo.ð̞ɛ.ˈχwe.ɣ̞ɔs̬.ma.la.ˈβ̞a.ɾes|e.ˈnũ.na.ˈpu̞n̪.t̪a.ð̞e.'
                         u'ka.ˈli.θa.se.mãn̪.t̪e.ˈni.a|ˈk̠wa.li.mãn̪.ˈt̪a.ð̞a|ˈu.na.ˈβ̞o.la.'
                         u'ˈɣ̞ɾan̪.d̪e.ð̞e.ˈβ̞ɾɔn̟.θe.ð̞o.ˈɾa.ð̞o|ɟ͡ʝ̞en̟.ˈθi.mɑ.ˈo.t̪ɾa.ˈmas.pe.'
                         u'ˈk̟e.ɲa|i.so.β̞ɾe.ˈes̪.t̪ɑ.ˈu.na.ˈkɾu̞θ̬.ð̞e.ˈʝ̞ɛ.rɔ.k̟e.a.ka.ˈβ̞a.β̞a.'
                         u'em.pa.ɾa.ˈra.ʝ̞ɔs]')]
TESTS_TRANSCRIPCION += [(u'Se me encogió el corazón cuando vi a ese muchacho sentado en el borde del sofá '
                         u'con los paquetes envueltos en papel de regalo, su pelo recién cortado, sin saber '
                         u'dónde meter ese amor que anduvo juntando todos estos años para Irene; buen mozo '
                         u'me pareció, alto y elegante como un príncipe, bien vestido como siempre anda él, '
                         u'tieso como un palo de escoba, un verdadero caballero, pero de poco le vale su '
                         u'pinta de galán, porque la niña no se fija en esas cosas y menos ahora que anda '
                         u'enamorada del fotógrafo; camarón que se duerme se lo lleva la corriente, no '
                         u'debió irse Gustavo dejándola sola por tantos meses. Yo no entiendo a estas '
                         u'parejas modernas, en mis tiempos no había tanta libertad y todo funcionaba como '
                         u'es debido: la mujer callada en su casa. Las novias esperaban bordando sábanas y '
                         u'no andaban encaramadas al anca de las motocicletas de otros hombres; eso debió '
                         u'prevenirlo el Capitán en vez de partir de viaje tan tranquilo, yo lo vi desde el '
                         u'principio y se lo dije: ausencias causan olvidos; pero nadie me hizo caso, me '
                         u'miraron con lástima, como si yo fuera una estúpida, pero no tengo ni un pelo de '
                         u'tonta, más sabe el diablo por viejo que por diablo.',
                         u'[se.mẽːŋ.k̠ɔ.ˈxjo.ɛl.k̠o.ɾa.ˈθɔŋ.k̠wan̪.d̪o.ˈβ̞i.a.ˈe.se.mu.ˈʧa.'
                         u'ʧo.sen̪.ˈt̪a.ð̞o.e.nɛl.ˈβ̞ɔɾ.ð̞e.ð̞ɛl.so.ˈfa.k̠ɔn.lɔs.pa.ˈk̟e.t̪e.'
                         u'sem.ˈbwɛl̪.t̪o.sem.pa.ˈpɛl̪.d̪ɛ.rɛ.ˈɣ̞a.lo|su.ˈpe.lɔ.rɛ.ˈθjeŋ.'
                         u'k̠ɔɾ.ˈt̪a.ð̞o|si̞n.sa.ˈβ̞ɛɾ.ˈð̞ɔn̪.d̪e.me.ˈt̪e.ˈɾe.se.a.ˈmɔɾ.k̟e.an̪.'
                         u'ˈd̪u.β̞ɔ.χu̞n̪.ˈt̪an̪.d̪o.ˈt̪o.ð̞o.ˈses̪.t̪o.ˈsa.ɲɔs.pa.ɾai̯.ˈɾe.ne‖'
                         u'ˈbweⁿ.ˈmo.θo.me.pa.ɾe.ˈθjo|ˈɑl̪.t̪o.ʝ̞e.le.ˈɣ̞an̪.t̪e.k̠o.mo.ˈu̞m.'
                         u'ˈpɾi̞n̟.θi.pe|ˈbjem.bes̪.ˈt̪i.ð̞o.k̠o.mo.ˈsjem.pɾe.ˈan̪.d̪a.ˈɛl|'
                         u'ˈt̪je.so.k̠o.mo.ˈu̞m.ˈpa.lo.ð̞eːs.ˈk̠o.β̞a|ˈu̞m.bɛɾ.ð̞a.ˈð̞e.ɾo.ka.'
                         u'β̞a.ˈʎe.ɾo|pe.ɾo.ð̞e.ˈpo.k̠o.le.ˈβ̞a.le.su.ˈpi̞n̪.t̪a.ð̞e.ɣ̞a.ˈlan|'
                         u'pɔɾ.k̟e.la.ˈnĩ.ɲã.no.se.ˈfi̞.xa.e.ˈne.sas.ˈk̠o.sa.si.ˈmẽ.no.'
                         u'sɑ.ˈɔ.ɾa.k̟e.ˈan̪.d̪a.e.nã.mo.ˈɾa.ð̞a.ð̞ɛl.fo.ˈt̪o.ɣ̞ɾa.fo‖ka.ma.'
                         u'ˈɾɔŋ.k̟e.se.ˈð̞wɛɾ.me.se.lo.ˈʎe.β̞a.la.k̠ɔ.ˈrjen̪.t̪e|no.ð̞e.ˈβ̞jo.'
                         u'ˈi̞ɾ.se.ɣ̞u̞s̪.ˈt̪a.β̞o.ð̞ɛ.ˈxan̪.d̪o.la.ˈso.la.pɔɾ.ˈt̪an̪.t̪ɔs̬.ˈme.ses‖'
                         u'ˈɟ͡ʝ̞o.no.en̪.ˈt̪jen̪.d̪o.a.ˈes̪.t̪as.pa.ˈɾɛ.xas̬.mo.ˈð̞ɛɾ.nas|eⁿ.mi̞s̪.'
                         u'ˈt̪jem.pɔs̬.no.a.ˈβ̞i.a.ˈt̪an̪.t̪a.li.β̞ɛɾ.ˈt̪a.ð̥i.ˈt̪o.ð̞o.fu̞n̟.θjo.'
                         u'ˈna.β̞a.k̠o.mo.ˈez̪.ð̞e.ˈβ̞i.ð̞o‖la.mu̞.ˈxɛɾ.ka.ˈʎa.ð̞a.en.su.ˈka.sa‖'
                         u'las̬.ˈno.β̞ja.ses.pe.ˈɾa.β̞am.bɔɾ.ˈð̞an̪.d̪o.ˈsa.β̞a.na.si.no.an̪.'
                         u'ˈd̪a.β̞a.nẽŋ.ka.ɾa.ˈma.ð̞a.sa.ˈlaŋ.ka.ð̞e.las̬.mo.t̪o.θi.ˈkle.t̪az̪.'
                         u'ð̞e.ˈo.t̪ɾo.ˈsɔm.bɾes‖ˈe.so.ð̞e.ˈβ̞jo.pɾe.β̞e.ˈni̞ɾ.lo.ɛl.ka.pi.'
                         u'ˈt̪a.nẽm.ˈbeθ̬.ð̞e.paɾ.ˈt̪i̞ɾ.ð̞e.ˈβ̞jɑ.xe.t̪an̪.t̪ɾaŋ.ˈk̟i.lo|'
                         u'ˈɟ͡ʝ̞o.lo.ˈβ̞i.ð̞ez̪.ð̞ɛːl.pɾi̞n̟.ˈθi.pjɔi̯.se.lo.ˈð̞i̞.xe‖ɑu̯.ˈsen̟.θjas.'
                         u'ˈkɑu̯.sa.nɔl.ˈβ̞i.ð̞ɔs‖pe.ɾo.ˈna.ð̞je.me.ˈi.θo.ˈka.so|mẽ.mi.ˈɾa.'
                         u'ɾɔŋ.k̠ɔn.ˈlas̪.t̪i.ma|k̠o.mo.si.ˈʝ̞o.ˈfwe.ɾɑ.ˈu.na.es̪.ˈt̪u.pi.ð̞a|'
                         u'pe.ɾo.no.ˈt̪eŋ.ɡo.ˈnj̃ũ̞m.ˈpe.lo.ð̞e.ˈt̪ɔn̪.t̪a|ˈma.ˈsːa.β̞ɛːl̪.'
                         u'ˈd̪ja.β̞lo.pɔɾ.ˈβ̞jɛ.χo.k̟e.pɔɾ.ˈð̞ja.β̞lo]')]
TESTS_TRANSCRIPCION += [(u'Todo calla; todo reposa. Pasa de tarde en tarde, cruzando el ancho ámbito, con '
                         u'esa indolencia privativa de los perros de pueblo, un alto mastín que se detiene '
                         u'un momento, sin saber por qué, y luego se pierde a lo lejos por una empinada '
                         u'calleja; una bandada de gorriones se abate rápida sobre el suelo, picotea, '
                         u'salta, brinca, se levanta veloz y se aleja piando, moviendo voluptuosamente '
                         u'las alas sobre el azul límpido. A lo lejos, como una nota metálica, incisiva, '
                         u'que rasga de pronto la diafanidad del ambiente, vibra el cacareo sostenido de '
                         u'un gallo.',
                         u'[ˈt̪o.ð̞o.ˈka.ʎa‖ˈt̪o.ð̞ɔ.rɛ.ˈpo.sa‖ˈpa.sa.ð̞e.ˈt̪aɾ.ð̞eːn̪.ˈt̪aɾ.ð̞e|'
                         u'kɾu.ˈθan̪.d̪o.e.ˈlan̠.ʧo.ˈam.bi.t̪o|k̠o.ˈne.sai̯n̪.d̪o.ˈlen̟.θja.pɾi.'
                         u'β̞a.ˈt̪i.β̞a.ð̞e.lɔs.ˈpɛ.rɔz̪.ð̞e.ˈpwe.β̞lo|ˈu.ˈnɑl̪.t̪o.mas̪.ˈt̪i̞ŋ.k̟e.'
                         u'se.ð̞e.ˈt̪je.ne.ˈu̞ⁿ.mõ.ˈmẽn̪.t̪o|si̞n.sa.ˈβ̞ɛɾ.pɔɾ.ˈk̟e|i.ˈlwe.ɣ̞o.se.'
                         u'ˈpjɛɾ.ð̞e.a.lo.ˈlɛ.χɔs.po.ˈɾu.na.em.pi.ˈna.ð̞a.ka.ˈʎɛ.xa‖'
                         u'ˈu.na.β̞an̪.ˈd̪a.ð̞a.ð̞e.ɣ̞ɔ.ˈrjo.ne.sːe.a.ˈβ̞a.t̪ɛ.ˈra.pi.ð̞a.so.'
                         u'β̞ɾɛːl.ˈswe.lo|pi.k̠o.ˈt̪e.a|ˈsɑl̪.t̪a|ˈbɾi̞ŋ.ka|se.le.ˈβ̞an̪.t̪a.'
                         u'β̞e.ˈlo.θi.se.a.ˈlɛ.xa.ˈpjan̪.d̪o|mo.ˈβ̞jen̪.d̪o.β̞o.lu̞β̞.ˌt̪wo.sa.'
                         u'ˈmẽn̪.t̪e.la.ˈsa.la.sːo.β̞ɾeː.la.ˈθu.ˈlːi̞m.pi.ð̞o‖a.lo.ˈlɛ.χɔs|'
                         u'k̠o.mo.ˈu.nã.ˈno.t̪a.me.ˈt̪a.li.ka|i̞n̟.θi.ˈsi.β̞a|k̟ɛ.ˈras̬.ɣ̞a.ð̞e.'
                         u'ˈpɾɔn̪.t̪o.la.ð̞ja.fa.ni.ˈð̞a.ð̞ːe.lam.ˈbjen̪.t̪e|ˈbi.β̞ɾa.ɛl.ka.ka.'
                         u'ˈɾe.o.sɔs̪.t̪e.ˈni.ð̞o.ð̞e.ˈu̞ŋ.ˈɡa.ʎo]')]
TESTS_TRANSCRIPCION += [(u'La cumbre. Ahí está el ocaso, todo empurpurado, herido por sus propios '
                         u'cristales, que le hacen sangre por doquiera. A su esplendor, el pinar verde se '
                         u'agria, vagamente enrojecido; y las hierbas y las florecillas, encendidas y '
                         u'transparentes, embalsaman el instante sereno de una esencia mojada, penetrante '
                         u'y luminosa. Yo me quedo extasiado en el crepúsculo. Platero, granas de ocaso sus '
                         u'ojos negros, se va, manso, a un charquero de aguas de carmín, de rosa, de '
                         u'violeta; hunde suavemente su boca en los espejos, que parece que se hacen '
                         u'líquidos al tocarlos él; y hay por su enorme garganta como un pasar profundo de '
                         u'umbrías aguas de sangre. El paraje es conocido, pero el momento lo trastorna y '
                         u'lo hace extraño, ruinoso y monumental. Se dijera, a cada instante, que vamos a '
                         u'descubrir un palacio abandonado… La tarde se prolonga más allá de sí misma, y '
                         u'la hora, contagiada de eternidad, es infinita, pacífica, insondeable…',
                         u'[la.ˈk̠u̞m.bɾe‖a.ˈi.es̪.ˈt̪a.e.lo.ˈka.so|ˈt̪o.ð̞o.em.pu̞ɾ.pu.ˈɾa.ð̞o|'
                         u'e.ˈɾi.ð̞o.pɔɾ.su̞s.ˈpɾo.pjɔs.kɾi̞s̪.ˈt̪a.les|k̟e.le.ˈa.θen.ˈsaŋ.'
                         u'ɡɾe.pɔɾ.ð̞o.ˈk̟je.ɾa‖a.swes.plen̪.ˈd̪ɔɾ|ɛl.pi.ˈnaɾ.ˈβ̞ɛɾ.ð̞e.se.'
                         u'ˈa.ɣ̞ɾja|ˌba.ɣ̞a.ˈmẽn̪.t̪eːn.rɔ.xe.ˈθi.ð̞o‖i.las̬.ˈʝ̞ɛɾ.β̞a.si.las.'
                         u'flo.ɾe.ˈθi.ʎas|en̟.θen̪.ˈd̪i.ð̞a.si.t̪ɾaⁿs.pa.ˈɾen̪.t̪es|em.bɑl.ˈsa.'
                         u'mã.ne.li̞ⁿs̪.ˈt̪an̪.t̪e.se.ˈɾe.no.ð̞e.ˈu.na.e.ˈsen̟.θja.mɔ.ˈxa.ð̞a|'
                         u'pe.ne.ˈt̪ɾan̪.t̪ɛi̯.lu.mĩ.ˈno.sa‖ˈɟ͡ʝ̞o.me.ˈk̟e.ð̞o.es̪.t̪a.ˈsja.ð̞o.'
                         u'e.nɛl.kɾe.ˈpu̞s.k̠u.lo‖pla.ˈt̪e.ɾo|ˈɡɾa.naz̪.ð̞e.o.ˈka.so.su.ˈsɔ.'
                         u'χɔs̬.ˈne.ɣ̞ɾɔs|se.ˈβ̞a|ˈmãn.so|ɑ.ˈu̞n̠.ʧaɾ.ˈk̟e.ɾo.ð̞e.ˈa.ɣ̞waz̪.ð̞e.'
                         u'kaɾ.ˈmĩ̞n|d̪ɛ.ˈrɔ.sa|d̪e.β̞jo.ˈle.t̪a‖ˈu̞n̪.d̪e.ˌswa.β̞e.ˈmẽn̪.t̪e.su.'
                         u'ˈβ̞o.ka.en.lo.ses.ˈpɛ.χɔs|k̟e.pa.ˈɾe.θe.k̟e.se.ˈa.θen.ˈli.k̟i.'
                         u'ð̞o.sɑl̪.t̪o.ˈkaɾ.lo.ˈsɛl‖ˈɟ͡ʝ̞ai̯.pɔɾ.swe.ˈnɔɾ.me.ɣ̞aɾ.ˈɣ̞an̪.t̪a.'
                         u'k̠o.mo.ˈu̞m.pa.ˈsaɾ.pɾo.ˈfu̞n̪.d̪o.ð̞eu̯m.ˈbɾi.a.ˈsa.ɣ̞waz̪.ð̞e.ˈsaŋ.ɡɾe‖'
                         u'ɛl.pa.ˈɾɑ.xe.ˈes.k̠o.no.ˈθi.ð̞o|pe.ɾo.ɛl.mõ.ˈmẽn̪.t̪o.lo.t̪ɾas̪.ˈt̪ɔɾ.'
                         u'nai̯.lo.ˈa.θeːs̪.ˈt̪ɾa.ɲo|rwi.ˈno.sɔi̯.mõ.nũ.mẽn̪.ˈt̪ɑl‖se.ð̞i̞.ˈxe.ɾa|'
                         u'a.ˈka.ð̞ai̯ⁿs̪.ˈt̪an̪.t̪e|k̟e.ˈβ̞a.mo.sa.ð̞es.k̠u.ˈβ̞ɾi.ˈɾu̞m.pa.ˈla.θjo.'
                         u'a.β̞an̪.d̪o.ˈna.ð̞o‖la.ˈt̪aɾ.ð̞e.se.pɾo.ˈlɔŋ.ɡa.ˈma.sa.ˈʎa.ð̞e.ˈsi.'
                         u'ˈmi̞s̬.ma|i.lɑ.ˈɔ.ɾa|k̠ɔn̪.t̪ɑ.ˈxja.ð̞a.ð̞eː.t̪ɛɾ.ni.ˈð̞að̥|ˈe.si̞ɱ.fi.'
                         u'ˈni.t̪a|pa.ˈθi.fi.ka|i̞n.sɔn̪.d̪e.ˈa.β̞le]')]
TESTS_TRANSCRIPCION += [(u'La lingüística estudia el lenguaje humano. El lenguaje se manifiesta sólo en los '
                         u'seres humanos a través de las lenguas que les permiten hablar entre sí y '
                         u'consigo mismos. Hemos dicho que se manifiesta sólo en los seres humanos, pues '
                         u'cualquier otra cosa que reciba la denominación de lenguaje lo será sólo '
                         u'metafóricamente; es decir, por similitud al lenguaje humano. Los mismos seres '
                         u'humanos hablan entre sí; esto es, se comunican intercambiando mensajes con los '
                         u'demás seres humanos de su entorno; pero también hablan consigo mismos, aunque '
                         u'no se profieran palabras: el lenguaje es también la base del pensamiento '
                         u'humano; no es posible conectar dos ideas, ni tan siquiera estructurar una '
                         u'sola sin la ayuda del lenguaje. De ahí que sea el centro de nuestra vida '
                         u'intelectual y social. Por esto mismo, las lenguas, manifestaciones concretas del '
                         u'lenguaje humano, juegan un papel fundamental en la cultura de cualquier pueblo.',
                         u'[la.li̞ŋ.ˈɡwi̞s̪.t̪i.ka.es̪.ˈt̪u.ð̞ja.e.lːeŋ.ˈɡwɑ.xeu̯.ˈmã.no‖'
                         u'e.lːeŋ.ˈɡwɑ.xe.se.mã.ni.ˈfjes̪.t̪a.ˈso.lo.en.lo.ˈsːe.ɾe.'
                         u'su.ˈmã.no.sa.t̪ɾa.ˈβ̞ez̪.ð̞e.las̬.ˈleŋ.ɡwas.k̟e.les.pɛɾ.ˈmi.'
                         u't̪e.na.ˈβ̞la.ɾen̪.t̪ɾe.ˈsiː.k̠ɔn.ˈsi.ɣ̞o.ˈmi̞s̬.mɔs‖ˈe.mɔz̪.ˈð̞i.'
                         u'ʧo.k̟e.se.mã.ni.ˈfjes̪.t̪a.ˈso.lo.en.lo.ˈsːe.ɾe.su.ˈmã.nɔs|'
                         u'pwes.k̠wɑl.ˈk̟je.ˈɾo.t̪ɾa.ˈk̠o.sa.k̟ɛ.rɛ.ˈθi.β̞a.la.ð̞e.nõ.mĩ.'
                         u'na.ˈθjɔn̪.d̪e.leŋ.ˈɡwɑ.xe.lo.se.ˈɾa.ˈso.lo.me.t̪a.ˌfo.ɾi.'
                         u'ka.ˈmẽn̪.t̪e‖ˈez̪.ð̞e.ˈθi̞ɾ|pɔɾ.si.mi.li.ˈt̪u.ð̥a.lːeŋ.ˈɡwɑ.'
                         u'xeu̯.ˈmã.no‖lɔs̬.ˈmi̞s̬.mo.ˈsːe.ɾe.su.ˈmã.no.ˈsa.β̞la.nẽn̪.'
                         u't̪ɾe.ˈsi‖ˈes̪.t̪o.ˈes|se.k̠o.mũ.ˈni.ka.nĩ̞n̪.t̪ɛɾ.kam.ˈbjan̪.d̪o.'
                         u'mẽn.ˈsɑ.xes.k̠ɔn.lɔz̪.ð̞e.ˈma.ˈsːe.ɾe.su.ˈmã.nɔz̪.ð̞e.swen̪.'
                         u'ˈt̪ɔɾ.no‖pe.ɾo.t̪am.ˈbje.ˈna.β̞laŋ.k̠ɔn.ˈsi.ɣ̞o.ˈmi̞s̬.mɔs|'
                         u'ɑu̯ŋ.k̟e.no.se.pɾo.ˈfje.ɾam.pa.ˈla.β̞ɾas‖e.lːeŋ.ˈɡwɑ.xe.ˈes̪.'
                         u't̪am.ˈbjen.la.ˈβ̞a.se.ð̞ɛl.pen.sa.ˈmj̃ẽn̪.t̪ou̯.ˈmã.no‖no.ˈes.'
                         u'po.ˈsi.β̞le.k̠o.nɛɣ̞.ˈt̪aɾ.ˈð̞o.si.ˈð̞e.as|ni.t̪an.si.ˈk̟je.ɾa.'
                         u'es̪.t̪ɾu̞ɣ̞.t̪u.ˈɾa.ˈɾu.na.ˈso.la.si̞n.laː.ˈʝ̞u.ð̞a.ð̞e.lːeŋ.ˈɡwɑ.xe‖'
                         u'd̪e.a.ˈi.k̟e.ˈse.a.ɛl̟.ˈθen̪.t̪ɾo.ð̞e.ˈnwes̪.t̪ɾa.ˈβ̞i.ð̞ai̯n̪.t̪e.'
                         u'lɛɣ̞.ˈt̪wa.li.so.ˈθjɑl‖po.ˈɾes̪.t̪o.ˈmi̞s̬.mo|las̬.ˈleŋ.ɡwas|'
                         u'mã.ni.fes̪.t̪a.ˈθjo.nes.k̠ɔŋ.ˈkɾe.t̪az̪.ð̞e.lːeŋ.ˈɡwɑ.xeu̯.ˈmã.'
                         u'no|ˈχwe.ɣ̞a.ˈnũ̞m.pa.ˈpɛl.fu̞n̪.d̪a.mẽn̪.ˈt̪a.len.la.k̠u̞l̪.ˈt̪u.ɾa.'
                         u'ð̞e.k̠wɑl.ˈk̟jɛɾ.ˈpwe.β̞lo]')]
TESTS_TRANSCRIPCION += [(u'El hombre viene subiendo por el medio del camino, silbando entre dientes una '
                         u'canción y tirando sin demasiadas ganas de la caballería. Trae un viejo tabardo '
                         u'de piel vuelta, descolorido ya por los años y la lluvia, y un sombrero hongo de '
                         u'fieltro hundido hasta los ojos. Quizá por eso no nos ve hasta que está ya '
                         u'prácticamente encima de nosotros. Aún no son las ocho todavía de un día que ha '
                         u'amanecido hinchado de negros nubarrones, amenazando lluvia, y, aquí arriba, en '
                         u'el puerto de Amarza, la humedad y la luz se funden formando una misma '
                         u'sustancia, una niebla pegajosa y fría que empapa mansamente la tierra y el '
                         u'espacio. Cuando no nos ve, parados en medio del camino, al final de una '
                         u'revuelta, el hombre tira del ronzal a la caballería y se detiene. De reojo, '
                         u'bajo el ala del sombrero, mientras Ramiro y yo nos acercamos, observa los '
                         u'hayedos más cercanos buscando otras personas. Recibe con recelo mi saludo. '
                         u'Pero sus ojos, hundidos bajo el sombrero no dejan traslucir la menor sombra '
                         u'de miedo.',
                         u'[e.ˈlɔm.bɾe.ˈβ̞je.ne.su.ˈβ̞jen̪.d̪o.po.ɾɛl.ˈme.ð̞jo.ð̞ɛl.ka.'
                         u'ˈmĩ.no|si̞l.ˈβ̞an̪.d̪o.en̪.t̪ɾe.ˈð̞jen̪.t̪e.ˈsu.na.kan̟.ˈθjo.ni.'
                         u't̪i.ˈɾan̪.d̪o.si̞n̪.d̪e.ma.ˈsja.ð̞as̬.ˈɣ̞a.naz̪.ð̞e.la.ka.β̞a.ʎe.'
                         u'ˈɾi.a‖ˈt̪ɾa.e.ˈu̞m.ˈbjɛ.χo.t̪a.ˈβ̞aɾ.ð̞o.ð̞e.ˈpjɛl.ˈβ̞wɛl̪.t̪a|'
                         u'd̪es.k̠o.lo.ˈɾi.ð̞o.ˈʝ̞a.pɔɾ.lo.ˈsa.ɲo.si.la.ˈʎu.β̞ja|ˈɟ͡ʝ̞u̞n.'
                         u'sɔm.ˈbɾe.ɾo.ˈɔŋ.ɡo.ð̞e.ˈfjɛl̪.t̪ɾɔu̯n̪.ˈd̪i.ð̞o.as̪.t̪a.lo.ˈsɔ.χɔs‖'
                         u'k̟i.ˈθa.po.ˈɾe.so.nõ.nɔs̬.ˈβ̞e.as̪.t̪a.k̟eːs̪.ˈt̪a.ˈʝ̞a.ˌpɾaɣ̞.t̪i.'
                         u'ka.ˈmẽn̪.t̪eːn̟.ˈθi.ma.ð̞e.no.ˈso.t̪ɾɔs‖ɑ.ˈu.nːo.ˈsɔn.la.ˈso.'
                         u'ʧo.t̪o.ð̞a.ˈβ̞i.a.ð̞e.ˈu̞n̪.ˈd̪i.a.k̟e.ˈaː.mã.ne.ˈθi.ð̞ɔi̯n̠.ˈʧa.ð̞o.'
                         u'ð̞e.ˈne.ɣ̞ɾɔs̬.nu.β̞a.ˈrɔ.nes|a.mẽ.na.ˈθan̪.d̪o.ˈʎu.β̞ja|i|a.'
                         u'ˈk̟i.a.ˈri̞.β̞a|e.nɛl.ˈpwɛɾ.t̪o.ð̞e.a.ˈmaɾ.θa|lɑu̯.me.ˈð̞a.ð̥i.'
                         u'la.ˈlu̞θ.se.ˈfu̞n̪.d̪eɱ.fɔɾ.ˈmãn̪.d̪o.ˈu.nã.ˈmi̞s̬.ma.su̞s̪.ˈt̪an̟.'
                         u'θja|ˈu.nã.ˈnje.β̞la.pe.ɣ̞ɑ.ˈχo.sai̯.ˈfɾi.a.k̟eːm.ˈpa.pa.ˌmãn.'
                         u'sa.ˈmẽn̪.t̪e.la.ˈt̪jɛ.ra.ʝ̞e.les.ˈpa.θjo‖k̠wan̪.d̪o.nõ.nɔs̬.ˈβ̞e|'
                         u'pa.ˈɾa.ð̞o.seⁿ.ˈme.ð̞jo.ð̞ɛl.ka.ˈmĩ.no|ɑl.fi.ˈnɑl̪.d̪e.ˈu.na.'
                         u'rɛ.ˈβ̞wɛl̪.t̪a|e.ˈlɔm.bɾe.ˈt̪i.ɾa.ð̞ɛl.rɔn̟.ˈθa.la.la.ka.β̞a.ʎe.'
                         u'ˈɾi.ai̯.se.ð̞e.ˈt̪je.ne‖d̪ɛ.rɛ.ˈɔ.χo|bɑ.χo.e.ˈla.la.ð̞ɛl.sɔm.'
                         u'ˈbɾe.ɾo|ˈmj̃ẽn̪.t̪ɾa.ra.ˈmi.ɾɔi̯.ˈʝ̞o.no.sa.θɛɾ.ˈka.mɔs|ɔβ̞.'
                         u'ˈsɛɾ.β̞a.lo.sa.ˈʝ̞e.ð̞ɔs̬.ˈmas.θɛɾ.ˈka.nɔs̬.β̞u̞s.ˈkan̪.d̪o.ˈo.t̪ɾas.'
                         u'pɛɾ.ˈso.nas‖rɛ.ˈθi.β̞e.k̠ɔn.rɛ.ˈθe.lo.mi.sa.ˈlu.ð̞o‖'
                         u'pe.ɾo.su.ˈsɔ.χɔs|u̞n̪.ˈd̪i.ð̞ɔs̬.β̞ɑ.χo.ɛl.sɔm.ˈbɾe.ɾo.no.ˈð̞ɛ.'
                         u'xan̪.t̪ɾas̬.lu.ˈθi̞ɾ.la.mẽ.ˈnɔɾ.ˈsɔm.bɾa.ð̞e.ˈmje.ð̞o]')]

TESTS_TRANSCRIPCION += [(u'El viento norte y el sol porfiaban sobre cuál de ellos era el más fuerte, '
                         u'cuando acertó a pasar un viajero envuelto en ancha capa. Convinieron en que '
                         u'quien antes lograra obligar al viajero a quitarse la capa sería considerado '
                         u'más poderoso. El viento norte sopló con gran furia, pero cuanto más soplaba, '
                         u'más se arrebujaba en su capa el viajero; por fin el viento norte abandonó la '
                         u'empresa. Entonces brilló el sol con ardor, e inmediatamente se despojó de su '
                         u'capa el viajero; por lo que el viento norte hubo de reconocer la superioridad '
                         u'del sol.',
                         u'[ɛl.ˈβ̞jen̪.t̪o.ˈnɔɾ.t̪e.ʝ̞ɛl.ˈsɔl.pɔɾ.ˈfja.β̞an.so.β̞ɾe.ˈk̠wɑl̪.'
                         u'd̪e.ˈe.ʎo.ˈse.ɾa.ɛl.ˈmas.ˈfwɛɾ.t̪e|k̠wan̪.d̪o.a.θɛɾ.ˈt̪o.a.pa.'
                         u'ˈsa.ˈɾu̞m.bjɑ.ˈxe.ɾo.em.ˈbwɛl̪.t̪o.e.ˈnãn̠.ʧa.ˈka.pa‖'
                         u'k̠ɔm.bi.ˈnje.ɾo.nẽŋ.k̟e.k̟je.ˈnãn̪.t̪es̬.lo.ˈɣ̞ɾa.ɾɑ.o.β̞li.ˈɣ̞a.'
                         u'ɾɑl.β̞jɑ.ˈxe.ɾo.a.k̟i.ˈt̪aɾ.se.la.ˈka.pa.se.ˈɾi.a.k̠ɔn.si.ð̞e.'
                         u'ˈɾa.ð̞o.ˈmas.po.ð̞e.ˈɾo.so‖ɛl.ˈβ̞jen̪.t̪o.ˈnɔɾ.t̪e.so.ˈplo.k̠ɔŋ.'
                         u'ˈɡɾaɱ.ˈfu.ɾja|pe.ɾo.k̠wan̪.t̪o.ˈma.sːo.ˈpla.β̞a|ˈma.sːe.a.rɛ.'
                         u'β̞u̞.ˈxa.β̞a.en.su.ˈka.pa.ɛl.β̞jɑ.ˈxe.ɾo‖pɔɾ.ˈfi.nɛl.ˈβ̞jen̪.t̪o.'
                         u'ˈnɔɾ.t̪e.a.β̞an̪.d̪o.ˈno.la.em.ˈpɾe.sa‖en̪.t̪ɔn̟.θes̬.β̞ɾi.ˈʎo.ɛl.'
                         u'ˈsɔl.k̠o.naɾ.ˈð̞ɔɾ|ɛi̯ⁿ.me.ˌð̞ja.t̪a.ˈmẽn̪.t̪e.se.ð̞es.pɔ.ˈχo.ð̞e.'
                         u'su.ˈka.pa.ɛl.β̞jɑ.ˈxe.ɾo‖pɔɾ.lo.k̟ɛːl.ˈβ̞jen̪.t̪o.ˈnɔɾ.t̪e.ˈu.'
                         u'β̞o.ð̞ɛ.rɛ.k̠o.no.ˈθɛɾ.la.su.pe.ɾjo.ɾi.ˈð̞a.ð̞ːɛl.ˈsɔl]')]

TESTS_TRANSCRIPCION += [(u'¿ui, ¿uiui?, hui, uy, uiue, uiui, puiue, piui, pauui, paiui, caue, caiéis, tyyo, '
                         u'yiu, yy, tyu',
                         u'[ˈɡwi‖ˈɡwi.ɣ̞wi‖ˈɡwi|ˈɡwi|ˈɡwi.ɣ̞we|ˈɡwi.ɣ̞wi|ˈpwi.ɣ̞we|ˈpi.ɣ̞wi|'
                         u'ˈpɑu̯.ɣ̞wi|ˈpai̯.ɣ̞wi|ˈka.ɣ̞we|ka.ˈʝ̞ɛi̯s|ˈt̪i.ʝ̞o|ˈɟ͡ʝ̞ju|ˈɟ͡ʝ̞i|ˈt̪ʝ̞u]')]
TESTS_TRANSCRIPCION += [(u'muy, fui. muy hábil, fui hábil. muy abril, fui abril. muy indio, fui indio. '
                         u'muy hindú, fui hindú. cónvoy, voy. cónvoy hábil, voy hábil. cónvoy abril, '
                         u'voy abril. cónvoy indio, voy indio. cónvoy hindú, voy hindú. maría y ana. '
                         u'muy alta, muy altanera',
                         u'[mwi|ˈfwi‖mu.ˈʝ̞a.β̞i̞l|ˈfwi.ˈa.β̞i̞l‖mwi.a.ˈβ̞ɾi̞l|ˈfwi.a.ˈβ̞ɾi̞l‖'
                         u'ˈmw̃ĩ̞ːn̪.d̪jo|ˈfwi̞ːn̪.d̪jo‖mw̃ĩ̞ːn̪.ˈd̪u|ˈfwi̞ːn̪.ˈd̪u‖ˈk̠ɔm.bɔi̯|ˈbɔi̯‖'
                         u'ˈk̠ɔm.bo.ˈʝ̞a.β̞i̞l|ˈbɔi̯.ˈa.β̞i̞l‖ˈk̠ɔm.bo.ʝ̞a.ˈβ̞ɾi̞l|ˈbɔi̯.a.ˈβ̞ɾi̞l‖'
                         u'ˈk̠ɔm.bɔi̯.ˈi̞n̪.d̪jo|ˈbɔi̯.ˈi̞n̪.d̪jo‖ˈk̠ɔm.bɔi̯.i̞n̪.ˈd̪u|ˈbɔi̯.i̞n̪.ˈd̪u‖'
                         u'ma.ˈɾi.a.ˈʝ̞a.na‖mu.ˈʝ̞ɑl̪.t̪a|mwi.ɑl̪.t̪a.ˈne.ɾa]')]
TESTS_TRANSCRIPCION += [(u'ob, obb, obbi, obbti, obbbbb, obbbbbi. od, odd, oddi, oddti, oddddd, '
                         u'odddddi. og, ogg, oggi, oggti, oggggg, ogggggi. op, opp, oppi, oppti, oppppp, '
                         u'opppppi. ot, ott, otti, ottti, ottttt, ottttti. ok, okk, okki, okkti, okkkkk, '
                         u'okkkkki. of, off, offi, offti, offfff, offfffi. oz, ozz, ozzi, ozzti, ozzzzz, '
                         u'ozzzzzi. os, oss, ossi, ossti, osssss, osssssi. oj, ojj, ojjo, ojjti, ojjjjj, '
                         u'ojjjjji. on, onn, onni, onnti, onnnnn, onnnnni. om, omm, ommi, ommti, ommmmm, '
                         u'ommmmmi. oñ, oññ, oññi, oññti, oñññññ, oñññññi. ol, oll, olli, ollti, olllll, '
                         u'ollllli. or, orr, orri, orrti, orrrrr, orrrrri. och, ochch, ochchi, ochchti, '
                         u'ochchchchch, ochchchchchi',
                         u'[ˈɔβ̥|ˈɔbː|ˈo.β̞ːi|ˈɔbː.t̪i|ˈɔbː|ˈo.β̞ːi‖'
                         u'ˈɔð̥|ˈɔdː|ˈo.ð̞ːi|ˈɔdː.t̪i|ˈɔdː|ˈo.ð̞ːi‖'
                         u'ˈɔɣ̥|ˈɔɡː|ˈɔɣ̥.xi|ˈɔɡː.t̪i|ˈɔɡː|ˈɔɡː.xi‖'
                         u'ˈɔβ̞|ˈɔpː|ˈo.pːi|ˈɔpː.t̪i|ˈɔpː|ˈo.pːi‖'
                         u'ˈɔð̞|ˈɔtː|ˈo.tːi|ˈo.tːi|ˈɔtː|ˈo.tːi‖'
                         u'ˈɔɣ̞|ˈɔkː|ˈo.kːi|ˈɔkː.t̪i|ˈɔkː|ˈo.kːi‖'
                         u'ˈɔf|ˈɔfː|ˈo.fːi|ˈɔfː.t̪i|ˈɔfː|ˈo.fːi‖'
                         u'ˈɔθ|ˈɔθː|ˈo.θːi|ˈɔθː.t̟i|ˈɔθː|ˈo.θːi‖'
                         u'ɔs|ˈɔsː|ˈo.sːi|ˈɔs̪ː.t̪i|ˈɔsː|ˈo.sːi‖'
                         u'ˈɔx̥|ˈɔxː|ˈɔ.χːo|ˈɔxː.t̪i|ˈɔxː|ˈɔ.xːi‖'
                         u'ˈɔn|ˈɔnː|ˈo.nːi|ˈɔn̪ː.t̪i|ˈɔnː|ˈo.nːi‖'
                         u'ˈɔn|ˈɔmː|ˈo.mːi|ˈɔmː.t̪i|ˈɔmː|ˈo.mːi‖'
                         u'ˈɔɲ|ˈɔɲː|ˈo.ɲːi|ˈɔɲː.t̪i|ˈɔɲː|ˈo.ɲːi‖'
                         u'ˈɔl|ˈɔl|ˈo.ʎi|ˈɔl̪.t̪i|ˈɔlː|ˈo.ʎːi‖'
                         u'ˈɔɾ|ˈɔr|ˈɔ.ri̞|ˈɔr.t̪i|ˈɔrː|ˈɔ.rːi̞‖'
                         u'ˈoʧ|ˈoʧː|ˈo.ʧːi|ˈoʧː.t̪i|ˈoʧː|ˈo.ʧːi]')]
TESTS_TRANSCRIPCION += [(u'a, uuuuuuuuuuuuu. hoy hui y hui u oí o hay hueco. '
                         u'obvio y subversivo akgar otdon chií chiita zooobservatorio dásela a Aarón. '
                         u'pop bar, popbar, pob bar, pobbar. '
                         u'Zoólogo, zoología, oocito, no oocito, no óocito, no oócito, nó oócito, nó óocito, '
                         u'nó oocito',
                         u'[a|uː.uː.uː.uː.uː.u.ˈuː‖ˈɔi̯.ˈɣ̞wiː.ˈɣ̞wi.ɣ̞wo.ˈi.o.ˈai̯.ˈɣ̞we.k̠o‖'
                         u'ˈo.β̞ːjɔi̯.su.β̞ːɛɾ.ˈsi.β̞o.a.ˈɣ̞ːa.ˈɾɔ.ð̞ːɔn̠.ʧi.ˈi.ʧi.ˈi.t̪a.'
                         u'θoː.ɔβ̞.sɛɾ.β̞a.ˈt̪o.ɾjo.ˈð̞a.se.laː.aː.ˈɾɔn‖'
                         u'ˈpɔ.ˈβ̞ːaɾ|pɔ.ˈβ̞ːaɾ|ˈpo.ˈβ̞ːaɾ|po.ˈβ̞ːaɾ‖θo.ˈo.lo.ɣ̞o|θoː.lɔ.ˈxi.a|'
                         u'oː.ˈθi.t̪o|noː.o.ˈθi.t̪o|no.ˈoː.θi.t̪o|noː.ˈo.θi.t̪o|'
                         u'ˈnoː.ˈo.θi.t̪o|ˈno.ˈoː.θi.t̪o|ˈnoː.o.ˈθi.t̪o]')]
TESTS_TRANSCRIPCION += [(u'-Las ONGs han declarado que la U.R.S.S. está sobrevalorada, igual que EE.UU. y '
                         u'que la OMS. '
                         u'Solo UGT defiende a CC.OO. en la XII cumbre del siglo XXI, a 2ª hora con -34,2°C. '
                         u'Usa NIF o DNI para pagar el IRPF de la WWF. Han volado un WC con TNT. '
                         u'Las IPs del servidor DNS usan WIFI con SHA2. '
                         u'Yo nací entre la noche del 26/07 y el 27/07/1976. '
                         u'Comenzó el parto a las 22:45 y acabó a las 00:23:56. 7 + 8 = -25. '
                         u'Quiero otro DVD69 con el 15% de descuento. '
                         u'Hispano-letón, lee-ensayos',
                         u'[la.so.e.nɛ.ˈxe.ˈsan̪.d̪e.kla.ˈɾa.ð̞o.k̟e.lɑ.ˈu̞ɾ.sːes̪.ˈt̪a.so.β̞ɾe.'
                         u'β̞a.lo.ˈɾa.ð̞a|i.ˈɣ̞wɑl.k̟eː.eu̯.ˈɣ̞wi.k̟e.lɑ.ˈɔⁿs‖ˈso.lou̯.xe.ˈt̪e.ð̞e.'
                         u'ˈfjen̪.d̪e.a.θe.θe.o.ˈo.en.la.ˈð̞o.θe.ˈk̠u̞m.bɾe.ð̞ɛl.ˈsi.ɣ̞lo.β̞ɛi̯n̪.'
                         u'ˈt̪ju.no|a.se.ˈɣ̞u̞n̪.d̪ɑ.ˈɔ.ɾa.k̠ɔⁿ.ˈmẽ.nɔs̪.ˈt̪ɾɛi̯n̪.t̪ai̯.ˈk̠wa.t̪ɾo.ˈk̠o.ma.'
                         u'ˈð̞ɔs̬.ˈɣ̞ɾa.ð̞ɔs.θen̪.ˈt̪i.ɣ̞ɾa.ð̞ɔs‖ˈu.sa.ˈni.fo.ð̞eː.ne.ˈi.pa.ɾa.pa.ˈɣ̞a.'
                         u'ɾɛl̠.ɟ͡ʝ̞ɛ.rɛ.pe.ˈe.fe.ð̞e.lɑu̯.β̞e.ð̞o.β̞leu̯.β̞e.ð̞o.β̞le.ˈe.fe‖'
                         u'ˈam.bo.ˈla.ð̞o.ˈu.nu.β̞e.ð̞o.β̞le.ˈθe.k̠ɔn̪.t̪eː.ne.ˈt̪e‖la.si.ˈpez̪.ð̞ɛl.sɛɾ.β̞i.'
                         u'ˈð̞ɔɾ.ð̞eː.ne.ˈe.se.ˈu.saŋ.ˈɡwi.fi.k̠o.ˈne.se.ˈa.ʧe.ˈa.ˈð̞ɔs‖'
                         u'ˈɟ͡ʝ̞o.na.ˈθi.en̪.t̪ɾe.la.ˈno.ʧe.ð̞ɛl.β̞ɛi̯n̪.t̪i.ˈsɛi̯z̪.ð̞ɛ.ˈχu.ljo.'
                         u'ʝ̞ɛl.β̞ɛi̯n̪.t̪i.ˈsje.t̪e.ð̞ɛ.ˈχu.ljo.ð̞e.ˈmi̞l.no.β̞e.ˈθjen̪.t̪o.sːe.ˈt̪en̪.'
                         u't̪ai̯.ˈsɛi̯s‖k̠o.mẽn̟.ˈθo.ɛl.ˈpaɾ.t̪o.a.la.ˈsɔn̟.θe.ˈmẽ.nɔs.ˈk̠waɾ.t̪o.ʝ̞a.'
                         u'ka.ˈβ̞o.a.laz̪.ˈð̞o.θɛi̯.β̞ɛi̯n̪.t̪i.ˈt̪ɾe.si.θi̞ŋ.ˈk̠wen̪.t̪ai̯.ˈsɛi̯.sːe.'
                         u'ˈɣ̞u̞n̪.d̪ɔs‖ˈsje.t̪e.ˈma.ˈso.ʧɔi̯.ˈɣ̞wɑl.ˈmẽ.nɔs̬.β̞ɛi̯n̪.t̪i.ˈθi̞ŋ.k̠o‖ˈk̟je.ɾo.'
                         u'ˈo.t̪ɾo.ˈð̞e.ˈu.β̞e.ˈð̞e.se.ˈsen̪.t̪ai̯.ˈnwe.β̞e.k̠o.nɛl.ˈk̟i̞n̟.θe.pɔɾ.ˈθjen̪.'
                         u't̪o.ð̞e.ð̞es.ˈk̠wen̪.t̪o‖'
                         u'i̞s.pa.no.le.ˈt̪ɔn|leː.en.ˈsa.ʝ̞ɔs]')]
TESTS_TRANSCRIPCION += [(u'-() Del ala\nQué ¿verás ¿ahora si (eso) (rula: veamos ¡bien!\n) según sea ) '
                         u'siempre'
                         u' ()()()() ama a Ana?\n? Ave César: ¡morituri! "te" te te "te".',
                         u'[d̪e.ˈla.la‖ˈk̟e‖be.ˈɾas‖ɑ.ˈɔ.ɾa.ˈsje.so|ˈɾu.la‖be.ˈa.mɔs‖ˈbjen‖se.ˈɣ̞u̞n.ˈse.a|'
                         u'ˈsjem.pɾe|ˈa.maː.ˈa.na‖ˈa.β̞e.ˈθe.saɾ‖mo.ɾi.ˈt̪u.ɾi‖t̪e.t̪e.t̪e.t̪e]')]
