# mypy-boto3-elastictranscoder

[![PyPI - mypy-boto3-elastictranscoder](https://img.shields.io/pypi/v/mypy-boto3-elastictranscoder.svg?color=blue)](https://pypi.org/project/mypy-boto3-elastictranscoder)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-elastictranscoder.svg?color=blue)](https://pypi.org/project/mypy-boto3-elastictranscoder)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.ElasticTranscoder 1.14.41](https://boto3.amazonaws.com/v1/documentation/api/1.14.41/reference/services/elastictranscoder.html#ElasticTranscoder) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.2.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

## How to install

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `ElasticTranscoder` service.

```bash
python -m pip install boto3-stubs[elastictranscoder]
```

## How to use

### Client annotations

`ElasticTranscoderClient` provides annotations for `boto3.client("elastictranscoder")`.

```python
import boto3

from mypy_boto3_elastictranscoder import ElasticTranscoderClient
from mypy_boto3_elastictranscoder.paginator import (
    ListJobsByPipelinePaginator,
    ListJobsByStatusPaginator,
    ListPipelinesPaginator,
    ListPresetsPaginator,
)
from mypy_boto3_elastictranscoder.type_defs import ArtworkTypeDef, ...
from mypy_boto3_elastictranscoder.waiter import JobCompleteWaiter

client: ElasticTranscoderClient = boto3.client("elastictranscoder")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: ElasticTranscoderClient = session.client("elastictranscoder")
```

### Paginators annotations

`mypy_boto3_elastictranscoder.paginator` module contains type annotations for all paginators.

```python

client: ElasticTranscoderClient = boto3.client("elastictranscoder")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_jobs_by_pipeline_paginator: ListJobsByPipelinePaginator = client.get_paginator("list_jobs_by_pipeline")
list_jobs_by_status_paginator: ListJobsByStatusPaginator = client.get_paginator("list_jobs_by_status")
list_pipelines_paginator: ListPipelinesPaginator = client.get_paginator("list_pipelines")
list_presets_paginator: ListPresetsPaginator = client.get_paginator("list_presets")
```


### Waiters annotations

`mypy_boto3_elastictranscoder.waiter` module contains type annotations for all waiters.

```python

client: ElasticTranscoderClient = boto3.client("elastictranscoder")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
job_complete_waiter: JobCompleteWaiter = client.get_waiter("job_complete")
```





### Typed dictionations

`mypy_boto3_elastictranscoder.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python

def get_structure() -> ArtworkTypeDef:
    return {
      ...
    }
```


## Dynamic type annotations

`mypy_boto3` command generates `boto3.client/resource` type annotations for
`mypy_boto3_elastictranscoder` and other installed services.

```bash
# Run this command after you add or remove service packages
python -m mypy_boto3
```

Generated type annotations provide overloads for `boto3.client` and `boto3.resource`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully if you have many services installed
- `VSCode` does not currently support function overloads, use explicit type annotations

```python

# Type is discovered correctly by mypy and PyCharm
# VSCode still needs explicit type annotations
client = boto3.client("elastictranscoder")

session_client = boto3.Session().client("elastictranscoder")
```
