from vk_api import VkApi, VkUpload
from vk_api.longpoll import VkLongPoll, VkEventType
from vk_api.utils import get_random_id
from vk_api.keyboard import VkKeyboard, VkKeyboardColor


def help() -> None:
    print("""
    help - список всех команд
    get_RGCM - вывод словарь что возвращает getConversationMembers
    get_vk_api_docs - вывод подсказка по использованию общих команд vk_api
    get_all_docs - вывод всей документации
    get_events_docs - вывод подсказки по использованию events
    get_keyboard_docs - вывод подсказки по использованию keyboard
    get_name(user_id) - возврат имени пользователя по его user_id
    get_lname(user_id) - возврат фамилии пользователя по его user_id
    get_full_name(user_id, separately) - возврат фамилии и имени пользователя по его user_id, настройка 
        separately может принимать 
        True - вернуть ФИ 2 строчками 
        False - вернуть ФИ одной строчкой
    send_message(sender, message, keyboard, chat_id) - отправляет сообщение пользователю
        sender - id отправителя сообщения
        message - текст что необходимо отправить
        keyboard - какую клавиатуру необходимо отрисовать (False = отправить сообщение без клавиатуры)
        chat_id - id групового чата (нельзя использовать вместе с sender)
    send_sticker(sender, sticker_id, keyboard, chat_id) - отправляет стикер пользователю
        sender - id отправителя сообщения
        sticker_id - номер стикера что необходимо отправить (важно стикер должен быть у создателя в наличии)
        keyboard - какую клавиатуру необходимо отрисовать (False = отправить сообщение без клавиатуры)
        chat_id - id групового чата (нельзя использовать вместе с sender)
    send_photo(sender, message, image_path, keyboard, chat_id) - отправляет фото пользователю
        sender - id отправителя сообщения
        message - текст что необходимо отправить
        image_path - путь к фото что необходимо отправить
        keyboard - какую клавиатуру необходимо отрисовать (False = отправить сообщение без клавиатуры)
        chat_id - id групового чата (нельзя использовать вместе с sender)
    get_skeleton - выводит скелет бота для быстрого старта
    """)


def get_RGCM() -> None:
    print("""
    *** Возврат getConversationMembers ***
     {'items':
        *** Для каждого пользователя в чате ***
        [{
        'member_id': id первого участника чата
        'invited_by': id участника что пригласил пользователя
        'join_date': дата и время присоеденения пользователя в формате Unix-time
        'is_admin': проверка на админ права
        'is_owner': проверка на владельца сервера
        }],
     'count': Количество участников чата
     'profiles':
        *** Для каждого пользователя в чате ***
        [{
        'id': id пользователя
        'first_name': Имя пользователя
        'last_name': Фамилия пользователя
        'is_closed': Закрыта ли страничка
        'can_access_closed': можно ли получить доступ к закрытой страничке
        'sex': пол
        'screen_name': уникальное имя пользователя
        'photo_50': фото аватара профиля
        'photo_100': полное фото аватара
        'online': проверка на онлайн пользователь или нет
        'online_info':
            {
            'visible': видимость тебя в сети (невидимка включена или нет)
            'last_seen': Последний раз в сети в unix времени
            'is_online': Сейчас онлайн
            'is_mobile': Из телефона
            }
        }]
     'groups':
        *** Для каждой группы в чате***
        [{
        'id': id группы
        'name': имя группы
        'screen_name': уникальное имя группы
        'is closed': закрытая ли группа?
        'type': тип группы
        'photo_50': фото аватара профиля
        'photo_100': полное фото аватара
        'photo_200': фото в мини профиле
     }""")


def get_vk_api_docs() -> None:
    print("""
    *** vk.api ***
    vk.api.longpoll.VkLongPoll - бот для отправки личных сообщений (бот группы)
    vk.api.botlongpoll.BotLongPoll - бот для чатов группы (в отличии от обычного бота помимо auth надо передать group_id (id - группового чата))
    vk.api.VkUpload - загрузчик медиа ресурсов на сервера вк (нужно передать auth)
    VkApi(token=token).get_api - возвращает класс для взаимодействия ботом с апи
    get_api.users.get - возвращает список со следующими значениями:
        id - id пользователя
        first_name - Имя пользователя 
        last_name - Фамилия пользователя
        is_closed - закрыта ли страница
        can_access_closed - есть ли доступ к закрытой странице
    get_api.messages.getConversationMembers - собирает информацию о участниках чата, принимает параметры:
        peer_id - Есть три варианта использования
            id чата с пользователем (user_id)
            id беседы/групового чата (user_id + 2000000000)
            id чата с сообществом (-user_id)
        group_id - id группы
    возврат getConversationMembers можно посмотреть командой get_RGCM()""")


def get_all_docs() -> None:
    print("""
    *** vk.api ***
    vk.api.longpoll.VkLongPoll - бот для отправки личных сообщений (бот группы)
    vk.api.botlongpoll.BotLongPoll - бот для чатов группы (в отличии от обычного бота помимо auth надо передать group_id (id - группового чата))
    vk.api.VkUpload - загрузчик медиа ресурсов на сервера вк (нужно передать auth)
    VkApi(token=token).get_api - возвращает класс для взаимодействия ботом с апи
    get_api.users.get - возвращает список со следующими значениями:
        id - id пользователя
        first_name - Имя пользователя 
        last_name - Фамилия пользователя
        is_closed - закрыта ли страница
        can_access_closed - есть ли доступ к закрытой странице
    get_api.messages.getConversationMembers - собирает информацию о участниках чата, принимает параметры:
        peer_id - Есть три варианта использования
            id чата с пользователем (user_id)
            id беседы/групового чата (user_id + 2000000000)
            id чата с сообществом (-user_id)
        group_id - id группы
    возврат getConversationMembers можно посмотреть командой get_RGCM()

    *** Events ***
    VkEventType.MESSAGE_NEW - тип события "Новое сообщение"
    VkBotEventType.MESSAGE_NEW - тип события "Новое сообщение" в чате группы
    event.type - содержит в себе код типа отправленного сообщения
    event.to_me - проверяет что сообщение направлено именно сообществу а не груповому каналу
    event.from_chat - отвечает только для чатов
    event.chat_id - id чата где пришло сообщение
    event.user_id - id юзера который отправил нам сообщение
    event.text - содержит текст сообщения пользователя (только для личных сообщений)
    event.message.get - словарь со всеми данными сообщения (только для групповых чатов)

    *** Keyboard ***
    Для создания клавиатуры необходимо создать обьект keyboard с помощью метода vk_api.keyboard.VkKeyboard
    внутри этого метода есть параметр one_time отвечающий за срок жизни клавиатуры (false - делает клавиатуру статической)
    далее создается сама клавиатура:
    keyboard.add_button = Добавление обычной кнопки. Принимает 2 параметра:
        label = текст кнопки
        color = цвет кнопки
            *** Список цветов ***
            DEFAULT - серый
            POSITIVE - зелёный
            NEGATIVE - красный
            PRIMARY - Синий
    keyboard.add_vkpay_button = Добавление кнопки оплаты при помощи Vk Pay. Принимает 2 параметра:
        label = текст кнопки
        link = ссылка для перехода
    keyboard.add_vkapps_button = Добавление кнопки для приложения Вконтакте
    keyboard.add_location_button = Добавление кнопки отправляющей местоположение
    keyboard.add_openlink_button = Добавление кнопки с ссылкой
    keyboard.add_line = Добавляет разрыв (переход на новую строку) между кнопками
    """)


def get_events_docs() -> None:
    print("""
    *** Events ***
    VkEventType.MESSAGE_NEW - тип события "Новое сообщение"
    VkBotEventType.MESSAGE_NEW - тип события "Новое сообщение" в чате группы
    event.type - содержит в себе код типа отправленного сообщения
    event.to_me - проверяет что сообщение направлено именно сообществу а не груповому каналу
    event.from_chat - отвечает только для чатов
    event.chat_id - id чата где пришло сообщение
    event.user_id - id юзера который отправил нам сообщение
    event.text - содержит текст сообщения пользователя (только для личных сообщений)
    event.message.get - словарь со всеми данными сообщения (только для групповых чатов)
    """)


def get_keyboard_docs() -> None:
    print("""
    Для создания клавиатуры необходимо создать обьект keyboard с помощью метода vk_api.keyboard.VkKeyboard
    внутри этого метода есть параметр one_time отвечающий за срок жизни клавиатуры (false - делает клавиатуру статической)
    далее создается сама клавиатура:
    keyboard.add_button = Добавление обычной кнопки. Принимает 2 параметра:
        label = текст кнопки
        color = цвет кнопки
            *** Список цветов ***
            DEFAULT - серый
            POSITIVE - зелёный
            NEGATIVE - красный
            PRIMARY - Синий
    keyboard.add_vkpay_button = Добавление кнопки оплаты при помощи Vk Pay. Принимает 2 параметра:
        label = текст кнопки
        link = ссылка для перехода
    keyboard.add_vkapps_button = Добавление кнопки для приложения Вконтакте
    keyboard.add_location_button = Добавление кнопки отправляющей местоположение
    keyboard.add_openlink_button = Добавление кнопки с ссылкой
    keyboard.add_line = Добавляет разрыв (переход на новую строку) между кнопками
    """)

class VkBotHelper:
    def __init__(self, token: str):
        self.auth = VkApi(token=token)
        self.upload = VkUpload(self.auth)
        self.getapi = self.auth.get_api()


    def get_name(user_id: int) -> str:
        return getapi.users.get(user_id=user_id)['first_name']


    def get_lname(user_id: int) -> str:
        return getapi.users.get(user_id=user_id)['last_name']


    def get_full_name(user_id: int, separately=False):
        if separately:
            return getapi.users.get(user_id=user_id)['first_name'], getapi.users.get(user_id=user_id)['last_name']
        else:
            return f"{getapi.users.get(user_id=user_id)['first_name']} {getapi.users.get(user_id=user_id)['last_name']}"


    def send_message(sender: int, message: str, keyboard=None, chat_id=None) -> None:
        if chat_id is None:
            id = 'user_id'
            sender = sender
        else:
            id = 'chat_id'
            sender = chat_id
        if keyboard is None:
            auth.method('messages.send', {id: sender,
                                          'message': message,
                                          'random_id': get_random_id()})
        else:
            auth.method('messages.send', {id: sender,
                                          'message': message,
                                          'random_id': get_random_id(),
                                          'keyboard': keyboard})


    def send_sticker(sender: int, sticker: int, keyboard=None, chat_id=None) -> None:
        if chat_id is None:
            id = 'user_id'
            sender = sender
        else:
            id = 'chat_id'
            sender = chat_id
        if keyboard is None:
            auth.method('messages.send', {id: sender,
                                          'sticker_id': sticker,
                                          'random_id': get_random_id()})
        else:
            auth.method('messages.send', {id: sender,
                                          'sticker_id': sticker,
                                          'random_id': get_random_id(),
                                          'keyboard': keyboard})


    def send_photo(sender: int, message: str, image_path: str, keyboard=None, chat_id=None) -> None:
        if chat_id is None:
            id = 'user_id'
            sender = sender
        else:
            id = 'chat_id'
            sender = chat_id
        attachments = []
        upload_image = upload.photo_messages(photos=image_path)[0]
        attachments.append(f"photo-{upload_image.owner_id}_{upload_image.id}")
        if keyboard is None:
            auth.method('messages.send', {id: sender,
                                          'message': message,
                                          'random_id': get_random_id(),
                                          'attachment': ','.join(attachments)
                                          })
        else:
            auth.method('messages.send', {id: sender,
                                          'message': message,
                                          'random_id': get_random_id(),
                                          'attachment': ','.join(attachments),
                                          'keyboard': keyboard
                                      })


def get_skeleton() -> None:
    print("""
    from config import token
    from VKBotHelper import *
    
    
    
    auth = VkApi(token=token)
    longpoll = VkLongPoll(auth)
    VKB = VKBotHelper.VkBotHelper(token)
    keyboard = VkKeyboard(one_time=True)
    keyboard.add_openlink_button(label="котик", link="https://vk.com")
    keyboard.add_button('Первая кнопка',
                        color=VkKeyboardColor.POSITIVE)
    keyboard.add_line()
    for event in longpoll.listen():
        if event.type == VkEventType.MESSAGE_NEW and event.to_me and event.text:
            res_msg = event.text
            sender = event.user_id
            VKB.send_message(sender, "Ты крутой &#128526;", keyboard=keyboard)
    """)