"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from .httpclient import AsyncHttpClient, HttpClient
from .sdkconfiguration import SDKConfiguration
from .utils.logger import Logger, get_default_logger
from .utils.retries import RetryConfig
from codat_sync_for_commerce import utils
from codat_sync_for_commerce._hooks import SDKHooks
from codat_sync_for_commerce.advanced_controls import AdvancedControls
from codat_sync_for_commerce.connections import Connections
from codat_sync_for_commerce.integrations import Integrations
from codat_sync_for_commerce.models import shared
from codat_sync_for_commerce.sync import Sync
from codat_sync_for_commerce.sync_flow_settings import SyncFlowSettings
from codat_sync_for_commerce.types import OptionalNullable, UNSET
import httpx
from typing import Callable, Dict, Optional, Union


class CodatSyncCommerce(BaseSDK):
    r"""Sync for Commerce: The API for Sync for Commerce.

    Sync for Commerce automatically replicates and reconciles sales data from a merchant’s source PoS, Payments, and eCommerce systems into their accounting software. This eliminates manual processing by merchants and transforms their ability to run and grow their business.

    [Explore product](https://docs.codat.io/commerce/overview) | [See our OpenAPI spec](https://github.com/codatio/oas)

    Not seeing the endpoints you're expecting? We've [reorganized our products](https://docs.codat.io/updates/230901-new-products), and you may be using a [different version of Sync for Commerce](https://docs.codat.io/sync-for-commerce-v1-api#/).

    ---

    <!-- Start Codat Tags Table -->
    ## Endpoints

    | Endpoints | Description |
    | :- |:- |
    | Connections | Create new and manage existing data connections for a company. |
    | Sync | Initiate data syncs and monitor their status. |
    | Sync flow settings | Control text and visibility settings for the Sync Flow. |
    | Integrations | Get a list of integrations supported by Sync for Commerce and their logos. |
    | Advanced controls | View and manage mapping configured for a company's commerce sync. |
    <!-- End Codat Tags Table -->
    """

    sync_flow_settings: SyncFlowSettings
    r"""Control text and visibility settings for the Sync Flow."""
    advanced_controls: AdvancedControls
    r"""View and manage mapping configured for a company's commerce sync."""
    connections: Connections
    r"""Create new and manage existing data connections for a company."""
    sync: Sync
    r"""Initiate data syncs and monitor their status."""
    integrations: Integrations
    r"""Get a list of integrations supported by Sync for Commerce and their logos."""

    def __init__(
        self,
        security: Union[shared.Security, Callable[[], shared.Security]],
        server_idx: Optional[int] = None,
        server_url: Optional[str] = None,
        url_params: Optional[Dict[str, str]] = None,
        client: Optional[HttpClient] = None,
        async_client: Optional[AsyncHttpClient] = None,
        retry_config: OptionalNullable[RetryConfig] = UNSET,
        timeout_ms: Optional[int] = None,
        debug_logger: Optional[Logger] = None,
    ) -> None:
        r"""Instantiates the SDK configuring it with the provided parameters.

        :param security: The security details required for authentication
        :param server_idx: The index of the server to use for all methods
        :param server_url: The server URL to use for all methods
        :param url_params: Parameters to optionally template the server URL with
        :param client: The HTTP client to use for all synchronous methods
        :param async_client: The Async HTTP client to use for all asynchronous methods
        :param retry_config: The retry configuration to use for all supported methods
        :param timeout_ms: Optional request timeout applied to each operation in milliseconds
        """
        if client is None:
            client = httpx.Client()

        assert issubclass(
            type(client), HttpClient
        ), "The provided client must implement the HttpClient protocol."

        if async_client is None:
            async_client = httpx.AsyncClient()

        if debug_logger is None:
            debug_logger = get_default_logger()

        assert issubclass(
            type(async_client), AsyncHttpClient
        ), "The provided async_client must implement the AsyncHttpClient protocol."

        if server_url is not None:
            if url_params is not None:
                server_url = utils.template_url(server_url, url_params)

        BaseSDK.__init__(
            self,
            SDKConfiguration(
                client=client,
                async_client=async_client,
                security=security,
                server_url=server_url,
                server_idx=server_idx,
                retry_config=retry_config,
                timeout_ms=timeout_ms,
                debug_logger=debug_logger,
            ),
        )

        hooks = SDKHooks()

        current_server_url, *_ = self.sdk_configuration.get_server_details()
        server_url, self.sdk_configuration.client = hooks.sdk_init(
            current_server_url, self.sdk_configuration.client
        )
        if current_server_url != server_url:
            self.sdk_configuration.server_url = server_url

        # pylint: disable=protected-access
        self.sdk_configuration.__dict__["_hooks"] = hooks

        self._init_sdks()

    def _init_sdks(self):
        self.sync_flow_settings = SyncFlowSettings(self.sdk_configuration)
        self.advanced_controls = AdvancedControls(self.sdk_configuration)
        self.connections = Connections(self.sdk_configuration)
        self.sync = Sync(self.sdk_configuration)
        self.integrations = Integrations(self.sdk_configuration)

    def __enter__(self):
        return self

    async def __aenter__(self):
        return self

    def __exit__(self, exc_type, exc_val, exc_tb):
        if self.sdk_configuration.client is not None:
            self.sdk_configuration.client.close()

    async def __aexit__(self, exc_type, exc_val, exc_tb):
        if self.sdk_configuration.async_client is not None:
            await self.sdk_configuration.async_client.aclose()
