"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .configurationoption import ConfigurationOption, ConfigurationOptionTypedDict
from codat_sync_for_commerce.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
import pydantic
from pydantic import model_serializer
from typing import List
from typing_extensions import Annotated, NotRequired, TypedDict


class TaxRateAmountTypedDict(TypedDict):
    selected_tax_rate_id: NotRequired[Nullable[str]]
    r"""Selected tax rate id from the list of tax rates on the accounting software."""
    tax_rate_options: NotRequired[Nullable[List[ConfigurationOptionTypedDict]]]
    r"""Array of tax rate options object."""


class TaxRateAmount(BaseModel):
    selected_tax_rate_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="selectedTaxRateId")
    ] = UNSET
    r"""Selected tax rate id from the list of tax rates on the accounting software."""

    tax_rate_options: Annotated[
        OptionalNullable[List[ConfigurationOption]],
        pydantic.Field(alias="taxRateOptions"),
    ] = UNSET
    r"""Array of tax rate options object."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["selectedTaxRateId", "taxRateOptions"]
        nullable_fields = ["selectedTaxRateId", "taxRateOptions"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
