"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .syncfrequency import SyncFrequency
from codat_sync_for_commerce.types import BaseModel
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class SyncScheduleTypedDict(TypedDict):
    frequency_options: NotRequired[List[SyncFrequency]]
    selected_frequency: NotRequired[SyncFrequency]
    r"""The frequency in which you want data to be synced."""
    start_date: NotRequired[str]
    r"""In Codat's data model, dates and times are represented using the <a class=\"external\" href=\"https://en.wikipedia.org/wiki/ISO_8601\" target=\"_blank\">ISO 8601 standard</a>. Date and time fields are formatted as strings; for example:

    ```
    2020-10-08T22:40:50Z
    2021-01-01T00:00:00
    ```



    When syncing data that contains `DateTime` fields from Codat, make sure you support the following cases when reading time information:

    - Coordinated Universal Time (UTC): `2021-11-15T06:00:00Z`
    - Unqualified local time: `2021-11-15T01:00:00`
    - UTC time offsets: `2021-11-15T01:00:00-05:00`

    > Time zones
    >
    > Not all dates from Codat will contain information about time zones.
    > Where it is not available from the underlying platform, Codat will return these as times local to the business whose data has been synced.
    """
    sync_hour: NotRequired[int]
    r"""The hour you want to trigger a sync."""
    time_zone: NotRequired[str]
    r"""The timezone for the company."""


class SyncSchedule(BaseModel):
    frequency_options: Annotated[
        Optional[List[SyncFrequency]], pydantic.Field(alias="frequencyOptions")
    ] = None

    selected_frequency: Annotated[
        Optional[SyncFrequency], pydantic.Field(alias="selectedFrequency")
    ] = None
    r"""The frequency in which you want data to be synced."""

    start_date: Annotated[Optional[str], pydantic.Field(alias="startDate")] = None
    r"""In Codat's data model, dates and times are represented using the <a class=\"external\" href=\"https://en.wikipedia.org/wiki/ISO_8601\" target=\"_blank\">ISO 8601 standard</a>. Date and time fields are formatted as strings; for example:

    ```
    2020-10-08T22:40:50Z
    2021-01-01T00:00:00
    ```



    When syncing data that contains `DateTime` fields from Codat, make sure you support the following cases when reading time information:

    - Coordinated Universal Time (UTC): `2021-11-15T06:00:00Z`
    - Unqualified local time: `2021-11-15T01:00:00`
    - UTC time offsets: `2021-11-15T01:00:00-05:00`

    > Time zones
    >
    > Not all dates from Codat will contain information about time zones.
    > Where it is not available from the underlying platform, Codat will return these as times local to the business whose data has been synced.
    """

    sync_hour: Annotated[Optional[int], pydantic.Field(alias="syncHour")] = None
    r"""The hour you want to trigger a sync."""

    time_zone: Annotated[Optional[str], pydantic.Field(alias="timeZone")] = None
    r"""The timezone for the company."""
