"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from codat_sync_for_commerce.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class SyncConnectionDeletedWebhookTypedDict(TypedDict):
    r"""A Sync for Commerce connection is deleted."""

    alert_id: NotRequired[str]
    r"""Unique identifier of the webhook event."""
    client_id: NotRequired[str]
    r"""Unique identifier for your client in Codat."""
    client_name: NotRequired[str]
    r"""Name of your client in Codat."""
    company_id: NotRequired[str]
    r"""Unique identifier for your SMB in Codat."""
    message: NotRequired[str]
    r"""A human-readable message about the webhook."""
    rule_id: NotRequired[str]
    r"""Unique identifier for the rule."""
    rule_type: NotRequired[str]
    r"""The type of rule."""


class SyncConnectionDeletedWebhook(BaseModel):
    r"""A Sync for Commerce connection is deleted."""

    alert_id: Annotated[Optional[str], pydantic.Field(alias="AlertId")] = None
    r"""Unique identifier of the webhook event."""

    client_id: Annotated[Optional[str], pydantic.Field(alias="ClientId")] = None
    r"""Unique identifier for your client in Codat."""

    client_name: Annotated[Optional[str], pydantic.Field(alias="ClientName")] = None
    r"""Name of your client in Codat."""

    company_id: Annotated[Optional[str], pydantic.Field(alias="CompanyId")] = None
    r"""Unique identifier for your SMB in Codat."""

    message: Annotated[Optional[str], pydantic.Field(alias="Message")] = None
    r"""A human-readable message about the webhook."""

    rule_id: Annotated[
        Optional[str],
        pydantic.Field(
            deprecated="warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible.",
            alias="RuleId",
        ),
    ] = None
    r"""Unique identifier for the rule."""

    rule_type: Annotated[Optional[str], pydantic.Field(alias="RuleType")] = None
    r"""The type of rule."""
