"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .accountconfiguration import AccountConfiguration, AccountConfigurationTypedDict
from .grouping import Grouping, GroupingTypedDict
from .invoicestatus import InvoiceStatus, InvoiceStatusTypedDict
from .newtaxrates import NewTaxRates, NewTaxRatesTypedDict
from .salescustomer import SalesCustomer, SalesCustomerTypedDict
from .taxrateamount import TaxRateAmount, TaxRateAmountTypedDict
from codat_sync_for_commerce.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
import pydantic
from pydantic import model_serializer
from typing import Dict, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class SalesConfigurationTypedDict(TypedDict):
    accounts: NotRequired[Nullable[Dict[str, AccountConfigurationTypedDict]]]
    grouping: NotRequired[GroupingTypedDict]
    invoice_status: NotRequired[InvoiceStatusTypedDict]
    new_tax_rates: NotRequired[NewTaxRatesTypedDict]
    sales_customer: NotRequired[SalesCustomerTypedDict]
    sync_sales: NotRequired[bool]
    r"""Boolean indicator for syncing sales."""
    tax_rates: NotRequired[Nullable[Dict[str, TaxRateAmountTypedDict]]]


class SalesConfiguration(BaseModel):
    accounts: OptionalNullable[Dict[str, AccountConfiguration]] = UNSET

    grouping: Optional[Grouping] = None

    invoice_status: Annotated[
        Optional[InvoiceStatus], pydantic.Field(alias="invoiceStatus")
    ] = None

    new_tax_rates: Annotated[
        Optional[NewTaxRates], pydantic.Field(alias="newTaxRates")
    ] = None

    sales_customer: Annotated[
        Optional[SalesCustomer], pydantic.Field(alias="salesCustomer")
    ] = None

    sync_sales: Annotated[Optional[bool], pydantic.Field(alias="syncSales")] = None
    r"""Boolean indicator for syncing sales."""

    tax_rates: Annotated[
        OptionalNullable[Dict[str, TaxRateAmount]], pydantic.Field(alias="taxRates")
    ] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "accounts",
            "grouping",
            "invoiceStatus",
            "newTaxRates",
            "salesCustomer",
            "syncSales",
            "taxRates",
        ]
        nullable_fields = ["accounts", "taxRates"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
