"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .configurationoption import ConfigurationOption, ConfigurationOptionTypedDict
from .taxratemapping import TaxRateMapping, TaxRateMappingTypedDict
from codat_sync_for_commerce.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
import pydantic
from pydantic import model_serializer
from typing import List
from typing_extensions import Annotated, NotRequired, TypedDict


class NewTaxRatesTypedDict(TypedDict):
    accounting_tax_rate_options: NotRequired[
        Nullable[List[ConfigurationOptionTypedDict]]
    ]
    r"""Array of accounting tax rate options."""
    commerce_tax_rate_options: NotRequired[Nullable[List[ConfigurationOptionTypedDict]]]
    r"""Array of tax component options."""
    default_zero_tax_rate_options: NotRequired[
        Nullable[List[ConfigurationOptionTypedDict]]
    ]
    r"""Default zero tax rate selected for sync."""
    selected_default_zero_tax_rate_id: NotRequired[Nullable[str]]
    r"""Default tax rate selected for sync."""
    tax_rate_mappings: NotRequired[Nullable[List[TaxRateMappingTypedDict]]]
    r"""Array of tax component to rate mappings."""


class NewTaxRates(BaseModel):
    accounting_tax_rate_options: Annotated[
        OptionalNullable[List[ConfigurationOption]],
        pydantic.Field(alias="accountingTaxRateOptions"),
    ] = UNSET
    r"""Array of accounting tax rate options."""

    commerce_tax_rate_options: Annotated[
        OptionalNullable[List[ConfigurationOption]],
        pydantic.Field(alias="commerceTaxRateOptions"),
    ] = UNSET
    r"""Array of tax component options."""

    default_zero_tax_rate_options: Annotated[
        OptionalNullable[List[ConfigurationOption]],
        pydantic.Field(alias="defaultZeroTaxRateOptions"),
    ] = UNSET
    r"""Default zero tax rate selected for sync."""

    selected_default_zero_tax_rate_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="selectedDefaultZeroTaxRateId")
    ] = UNSET
    r"""Default tax rate selected for sync."""

    tax_rate_mappings: Annotated[
        OptionalNullable[List[TaxRateMapping]], pydantic.Field(alias="taxRateMappings")
    ] = UNSET
    r"""Array of tax component to rate mappings."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "accountingTaxRateOptions",
            "commerceTaxRateOptions",
            "defaultZeroTaxRateOptions",
            "selectedDefaultZeroTaxRateId",
            "taxRateMappings",
        ]
        nullable_fields = [
            "accountingTaxRateOptions",
            "commerceTaxRateOptions",
            "defaultZeroTaxRateOptions",
            "selectedDefaultZeroTaxRateId",
            "taxRateMappings",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
