"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .datatypefeature import DataTypeFeature, DataTypeFeatureTypedDict
from .sourcetype import SourceType
from codat_sync_for_commerce.types import BaseModel
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class IntegrationTypedDict(TypedDict):
    r"""An integration that Codat supports"""

    enabled: bool
    r"""Whether this integration is enabled for your customers to use."""
    key: str
    r"""A unique 4-letter key to represent a platform in each integration. View [accounting](https://docs.codat.io/integrations/accounting/overview#platform-keys), [banking](https://docs.codat.io/integrations/banking/overview#platform-keys), and [commerce](https://docs.codat.io/integrations/commerce/overview#platform-keys) platform keys."""
    logo_url: str
    r"""Static url for integration's logo."""
    name: str
    r"""Name of integration."""
    data_provided_by: NotRequired[str]
    r"""The name of the data provider."""
    datatype_features: NotRequired[List[DataTypeFeatureTypedDict]]
    integration_id: NotRequired[str]
    r"""A Codat ID representing the integration."""
    is_beta: NotRequired[bool]
    r"""`True` if the integration is currently in beta release."""
    is_offline_connector: NotRequired[bool]
    r"""`True` if the integration is to an application installed and run locally on an SMBs computer."""
    source_id: NotRequired[str]
    r"""A source-specific ID used to distinguish between different sources originating from the same data connection. In general, a data connection is a single data source. However, for TrueLayer, `sourceId` is associated with a specific bank and has a many-to-one relationship with the `integrationId`."""
    source_type: NotRequired[SourceType]
    r"""The type of platform of the connection."""


class Integration(BaseModel):
    r"""An integration that Codat supports"""

    enabled: bool
    r"""Whether this integration is enabled for your customers to use."""

    key: str
    r"""A unique 4-letter key to represent a platform in each integration. View [accounting](https://docs.codat.io/integrations/accounting/overview#platform-keys), [banking](https://docs.codat.io/integrations/banking/overview#platform-keys), and [commerce](https://docs.codat.io/integrations/commerce/overview#platform-keys) platform keys."""

    logo_url: Annotated[str, pydantic.Field(alias="logoUrl")]
    r"""Static url for integration's logo."""

    name: str
    r"""Name of integration."""

    data_provided_by: Annotated[
        Optional[str], pydantic.Field(alias="dataProvidedBy")
    ] = None
    r"""The name of the data provider."""

    datatype_features: Annotated[
        Optional[List[DataTypeFeature]], pydantic.Field(alias="datatypeFeatures")
    ] = None

    integration_id: Annotated[Optional[str], pydantic.Field(alias="integrationId")] = (
        None
    )
    r"""A Codat ID representing the integration."""

    is_beta: Annotated[Optional[bool], pydantic.Field(alias="isBeta")] = None
    r"""`True` if the integration is currently in beta release."""

    is_offline_connector: Annotated[
        Optional[bool], pydantic.Field(alias="isOfflineConnector")
    ] = None
    r"""`True` if the integration is to an application installed and run locally on an SMBs computer."""

    source_id: Annotated[Optional[str], pydantic.Field(alias="sourceId")] = None
    r"""A source-specific ID used to distinguish between different sources originating from the same data connection. In general, a data connection is a single data source. However, for TrueLayer, `sourceId` is associated with a specific bank and has a many-to-one relationship with the `integrationId`."""

    source_type: Annotated[Optional[SourceType], pydantic.Field(alias="sourceType")] = (
        None
    )
    r"""The type of platform of the connection."""
