"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .commerceconfiguration import CommerceConfiguration, CommerceConfigurationTypedDict
from .syncschedule import SyncSchedule, SyncScheduleTypedDict
from codat_sync_for_commerce.types import BaseModel
import pydantic
from typing import Any, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ConfigurationTypedDict(TypedDict):
    accounting_software_company_name: NotRequired[str]
    r"""The company name defined in the accounting software."""
    company_id: NotRequired[Any]
    r"""Unique identifier for a company."""
    configuration: NotRequired[CommerceConfigurationTypedDict]
    configured: NotRequired[bool]
    r"""True if Sync for Commerce has been configured for the company."""
    enable: NotRequired[bool]
    r"""True if Sync for Commerce is enabled for the company."""
    schedule: NotRequired[SyncScheduleTypedDict]


class Configuration(BaseModel):
    accounting_software_company_name: Annotated[
        Optional[str], pydantic.Field(alias="accountingSoftwareCompanyName")
    ] = None
    r"""The company name defined in the accounting software."""

    company_id: Annotated[Optional[Any], pydantic.Field(alias="companyId")] = None
    r"""Unique identifier for a company."""

    configuration: Optional[CommerceConfiguration] = None

    configured: Optional[bool] = None
    r"""True if Sync for Commerce has been configured for the company."""

    enable: Optional[bool] = None
    r"""True if Sync for Commerce is enabled for the company."""

    schedule: Optional[SyncSchedule] = None
