"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .companyreference import CompanyReference, CompanyReferenceTypedDict
from .connection import Connection, ConnectionTypedDict
from codat_sync_for_commerce.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
import pydantic
from pydantic import model_serializer
from typing import Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class CompanyTypedDict(TypedDict):
    r"""In Codat, a company represents a business sharing access to their data. Each company can have multiple [connections](https://docs.codat.io/sync-for-sync-for-commerce-api#/schemas/Connection) to different data sources such as one connection to [Xero](https://docs.codat.io/integrations/accounting/xero/accounting-xero) for accounting data, two connections to [Plaid](https://docs.codat.io/integrations/banking/plaid/banking-plaid) for two bank accounts and a connection to [Zettle](https://docs.codat.io/integrations/commerce/zettle/commerce-zettle) for POS data.

    Typically each company is one of your customers.

    When you create a company, you can specify a `name` and we will automatically generate a unique `id` for the company. You can also add a `description` to store any additional information about the company.
    """

    id: str
    r"""Unique identifier for your SMB in Codat."""
    name: str
    r"""The name of the company"""
    redirect: str
    r"""The `redirect` [Link URL](https://docs.codat.io/auth-flow/authorize-hosted-link) enabling the customer to start their auth flow journey for the company."""
    created: NotRequired[str]
    r"""In Codat's data model, dates and times are represented using the <a class=\"external\" href=\"https://en.wikipedia.org/wiki/ISO_8601\" target=\"_blank\">ISO 8601 standard</a>. Date and time fields are formatted as strings; for example:

    ```
    2020-10-08T22:40:50Z
    2021-01-01T00:00:00
    ```



    When syncing data that contains `DateTime` fields from Codat, make sure you support the following cases when reading time information:

    - Coordinated Universal Time (UTC): `2021-11-15T06:00:00Z`
    - Unqualified local time: `2021-11-15T01:00:00`
    - UTC time offsets: `2021-11-15T01:00:00-05:00`

    > Time zones
    >
    > Not all dates from Codat will contain information about time zones.
    > Where it is not available from the underlying platform, Codat will return these as times local to the business whose data has been synced.
    """
    created_by_user_name: NotRequired[Nullable[str]]
    r"""Name of user that created the company in Codat."""
    data_connections: NotRequired[List[ConnectionTypedDict]]
    description: NotRequired[str]
    r"""Additional information about the company. This can be used to store foreign IDs, references, etc."""
    last_sync: NotRequired[str]
    r"""In Codat's data model, dates and times are represented using the <a class=\"external\" href=\"https://en.wikipedia.org/wiki/ISO_8601\" target=\"_blank\">ISO 8601 standard</a>. Date and time fields are formatted as strings; for example:

    ```
    2020-10-08T22:40:50Z
    2021-01-01T00:00:00
    ```



    When syncing data that contains `DateTime` fields from Codat, make sure you support the following cases when reading time information:

    - Coordinated Universal Time (UTC): `2021-11-15T06:00:00Z`
    - Unqualified local time: `2021-11-15T01:00:00`
    - UTC time offsets: `2021-11-15T01:00:00-05:00`

    > Time zones
    >
    > Not all dates from Codat will contain information about time zones.
    > Where it is not available from the underlying platform, Codat will return these as times local to the business whose data has been synced.
    """
    products: NotRequired[List[str]]
    r"""An array of products that are currently enabled for the company."""
    reference_parent_company: NotRequired[CompanyReferenceTypedDict]
    reference_subsidiary_companies: NotRequired[List[CompanyReferenceTypedDict]]
    r"""A list of subsidiary companies owned or controlled by this entity. Empty if the company has no children."""
    tags: NotRequired[Dict[str, str]]
    r"""A collection of user-defined key-value pairs that store custom metadata against the company."""


class Company(BaseModel):
    r"""In Codat, a company represents a business sharing access to their data. Each company can have multiple [connections](https://docs.codat.io/sync-for-sync-for-commerce-api#/schemas/Connection) to different data sources such as one connection to [Xero](https://docs.codat.io/integrations/accounting/xero/accounting-xero) for accounting data, two connections to [Plaid](https://docs.codat.io/integrations/banking/plaid/banking-plaid) for two bank accounts and a connection to [Zettle](https://docs.codat.io/integrations/commerce/zettle/commerce-zettle) for POS data.

    Typically each company is one of your customers.

    When you create a company, you can specify a `name` and we will automatically generate a unique `id` for the company. You can also add a `description` to store any additional information about the company.
    """

    id: str
    r"""Unique identifier for your SMB in Codat."""

    name: str
    r"""The name of the company"""

    redirect: str
    r"""The `redirect` [Link URL](https://docs.codat.io/auth-flow/authorize-hosted-link) enabling the customer to start their auth flow journey for the company."""

    created: Optional[str] = None
    r"""In Codat's data model, dates and times are represented using the <a class=\"external\" href=\"https://en.wikipedia.org/wiki/ISO_8601\" target=\"_blank\">ISO 8601 standard</a>. Date and time fields are formatted as strings; for example:

    ```
    2020-10-08T22:40:50Z
    2021-01-01T00:00:00
    ```



    When syncing data that contains `DateTime` fields from Codat, make sure you support the following cases when reading time information:

    - Coordinated Universal Time (UTC): `2021-11-15T06:00:00Z`
    - Unqualified local time: `2021-11-15T01:00:00`
    - UTC time offsets: `2021-11-15T01:00:00-05:00`

    > Time zones
    >
    > Not all dates from Codat will contain information about time zones.
    > Where it is not available from the underlying platform, Codat will return these as times local to the business whose data has been synced.
    """

    created_by_user_name: Annotated[
        OptionalNullable[str], pydantic.Field(alias="createdByUserName")
    ] = UNSET
    r"""Name of user that created the company in Codat."""

    data_connections: Annotated[
        Optional[List[Connection]], pydantic.Field(alias="dataConnections")
    ] = None

    description: Optional[str] = None
    r"""Additional information about the company. This can be used to store foreign IDs, references, etc."""

    last_sync: Annotated[Optional[str], pydantic.Field(alias="lastSync")] = None
    r"""In Codat's data model, dates and times are represented using the <a class=\"external\" href=\"https://en.wikipedia.org/wiki/ISO_8601\" target=\"_blank\">ISO 8601 standard</a>. Date and time fields are formatted as strings; for example:

    ```
    2020-10-08T22:40:50Z
    2021-01-01T00:00:00
    ```



    When syncing data that contains `DateTime` fields from Codat, make sure you support the following cases when reading time information:

    - Coordinated Universal Time (UTC): `2021-11-15T06:00:00Z`
    - Unqualified local time: `2021-11-15T01:00:00`
    - UTC time offsets: `2021-11-15T01:00:00-05:00`

    > Time zones
    >
    > Not all dates from Codat will contain information about time zones.
    > Where it is not available from the underlying platform, Codat will return these as times local to the business whose data has been synced.
    """

    products: Optional[List[str]] = None
    r"""An array of products that are currently enabled for the company."""

    reference_parent_company: Annotated[
        Optional[CompanyReference], pydantic.Field(alias="referenceParentCompany")
    ] = None

    reference_subsidiary_companies: Annotated[
        Optional[List[CompanyReference]],
        pydantic.Field(alias="referenceSubsidiaryCompanies"),
    ] = None
    r"""A list of subsidiary companies owned or controlled by this entity. Empty if the company has no children."""

    tags: Optional[Dict[str, str]] = None
    r"""A collection of user-defined key-value pairs that store custom metadata against the company."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "created",
            "createdByUserName",
            "dataConnections",
            "description",
            "lastSync",
            "products",
            "referenceParentCompany",
            "referenceSubsidiaryCompanies",
            "tags",
        ]
        nullable_fields = ["createdByUserName"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
