"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .configurationmapsettings import (
    ConfigurationMapSettings,
    ConfigurationMapSettingsTypedDict,
)
from .feesconfiguration import FeesConfiguration, FeesConfigurationTypedDict
from .newpaymentsconfiguration import (
    NewPaymentsConfiguration,
    NewPaymentsConfigurationTypedDict,
)
from .paymentsconfiguration import PaymentsConfiguration, PaymentsConfigurationTypedDict
from .salesconfiguration import SalesConfiguration, SalesConfigurationTypedDict
from codat_sync_for_commerce.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class CommerceConfigurationTypedDict(TypedDict):
    country_code: NotRequired[str]
    r"""The country code outlining where the company is based."""
    fees: NotRequired[FeesConfigurationTypedDict]
    map_settings: NotRequired[ConfigurationMapSettingsTypedDict]
    new_payments: NotRequired[NewPaymentsConfigurationTypedDict]
    payments: NotRequired[PaymentsConfigurationTypedDict]
    sales: NotRequired[SalesConfigurationTypedDict]


class CommerceConfiguration(BaseModel):
    country_code: Annotated[Optional[str], pydantic.Field(alias="countryCode")] = None
    r"""The country code outlining where the company is based."""

    fees: Optional[FeesConfiguration] = None

    map_settings: Annotated[
        Optional[ConfigurationMapSettings], pydantic.Field(alias="mapSettings")
    ] = None

    new_payments: Annotated[
        Optional[NewPaymentsConfiguration], pydantic.Field(alias="newPayments")
    ] = None

    payments: Optional[PaymentsConfiguration] = None

    sales: Optional[SalesConfiguration] = None
