"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from codat_sync_for_commerce.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
import pydantic
from pydantic import model_serializer
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class AccountConfigurationOptionTypedDict(TypedDict):
    classification: NotRequired[Nullable[str]]
    r"""Classification of the type of G/L account."""
    id: NotRequired[str]
    r"""Identifier for the account, unique for the company."""
    name: NotRequired[Nullable[str]]
    r"""Name of the account."""
    nominal_code: NotRequired[Nullable[str]]
    r"""Reference given to each nominal account for a business. It ensures money is allocated to the correct account. This code isn't a unique identifier in the Codat system."""


class AccountConfigurationOption(BaseModel):
    classification: OptionalNullable[str] = UNSET
    r"""Classification of the type of G/L account."""

    id: Optional[str] = None
    r"""Identifier for the account, unique for the company."""

    name: OptionalNullable[str] = UNSET
    r"""Name of the account."""

    nominal_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="nominalCode")
    ] = UNSET
    r"""Reference given to each nominal account for a business. It ensures money is allocated to the correct account. This code isn't a unique identifier in the Codat system."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["classification", "id", "name", "nominalCode"]
        nullable_fields = ["classification", "name", "nominalCode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
