"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .accountconfigurationoption import (
    AccountConfigurationOption,
    AccountConfigurationOptionTypedDict,
)
from codat_sync_for_commerce.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class AccountConfigurationTypedDict(TypedDict):
    r"""G/L account object for configuration."""

    account_options: NotRequired[Nullable[List[AccountConfigurationOptionTypedDict]]]
    r"""Object containing account options."""
    description_text: NotRequired[Nullable[str]]
    r"""Descriptive text for sales configuration section."""
    label_text: NotRequired[Nullable[str]]
    r"""Label text for sales configuration section."""
    required: NotRequired[bool]
    r"""Required section to be configured for sync."""
    selected_account_id: NotRequired[Nullable[str]]
    r"""Selected account id from the list of available accounts."""


class AccountConfiguration(BaseModel):
    r"""G/L account object for configuration."""

    account_options: Annotated[
        OptionalNullable[List[AccountConfigurationOption]],
        pydantic.Field(alias="accountOptions"),
    ] = UNSET
    r"""Object containing account options."""

    description_text: Annotated[
        OptionalNullable[str], pydantic.Field(alias="descriptionText")
    ] = UNSET
    r"""Descriptive text for sales configuration section."""

    label_text: Annotated[OptionalNullable[str], pydantic.Field(alias="labelText")] = (
        UNSET
    )
    r"""Label text for sales configuration section."""

    required: Optional[bool] = None
    r"""Required section to be configured for sync."""

    selected_account_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="selectedAccountId")
    ] = UNSET
    r"""Selected account id from the list of available accounts."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "accountOptions",
            "descriptionText",
            "labelText",
            "required",
            "selectedAccountId",
        ]
        nullable_fields = [
            "accountOptions",
            "descriptionText",
            "labelText",
            "selectedAccountId",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
