"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from codat_sync_for_commerce.types import BaseModel
from codat_sync_for_commerce.utils import (
    FieldMetadata,
    PathParamMetadata,
    QueryParamMetadata,
)
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetSyncFlowURLRequestTypedDict(TypedDict):
    accounting_key: str
    r"""Accounting platform key"""
    commerce_key: str
    r"""Commerce platform key"""
    merchant_identifier: NotRequired[str]
    r"""Identifier for your merchant, can be the merchant name or Codat company id."""


class GetSyncFlowURLRequest(BaseModel):
    accounting_key: Annotated[
        str,
        pydantic.Field(alias="accountingKey"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Accounting platform key"""

    commerce_key: Annotated[
        str,
        pydantic.Field(alias="commerceKey"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Commerce platform key"""

    merchant_identifier: Annotated[
        Optional[str],
        pydantic.Field(alias="merchantIdentifier"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Identifier for your merchant, can be the merchant name or Codat company id."""
