#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['hue', 'hue.api', 'hue.cli']

package_data = \
{'': ['*']}

install_requires = \
['httpx ~=0.20.0', 'typer[all] ~=0.4.0', 'rich ~=10.12.0']

extras_require = \
{'dev': ['black', 'coverage', 'flake8', 'pre-commit', 'tox'],
 'doc': ['mkdocs ~=1.2.3', 'mkdocs-material ~=7.3.6', 'mkdocstrings ~=0.16.2'],
 'test': ['pytest ~=6.2.5',
          'pytest-asyncio',
          'pytest-mock',
          'pytest-cov',
          'Faker']}

entry_points = \
{'console_scripts': ['hue = hue.cli:app']}

setup(name='hue-api',
      version='0.4.6',
      description='Async API for controlling Hue Lights',
      author='Nirantak Raghav',
      author_email='hey@nirantak.com',
      url='https://github.com/nirantak/hue-api',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
      python_requires='~=3.8',
     )
