import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ListAccountsRequest, ListAccountsResponse } from "../models/models_0";
import { deserializeAws_restJson1ListAccountsCommand, serializeAws_restJson1ListAccountsCommand, } from "../protocols/Aws_restJson1";
var ListAccountsCommand = (function (_super) {
    __extends(ListAccountsCommand, _super);
    function ListAccountsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ListAccountsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "SSOClient";
        var commandName = "ListAccountsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ListAccountsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ListAccountsResponse.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ListAccountsCommand.prototype.serialize = function (input, context) {
        return serializeAws_restJson1ListAccountsCommand(input, context);
    };
    ListAccountsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restJson1ListAccountsCommand(output, context);
    };
    return ListAccountsCommand;
}($Command));
export { ListAccountsCommand };
