import { EndpointsInputConfig, EndpointsResolvedConfig, RegionInputConfig, RegionResolvedConfig } from "@aws-sdk/config-resolver";
import { HostHeaderInputConfig, HostHeaderResolvedConfig } from "@aws-sdk/middleware-host-header";
import { RetryInputConfig, RetryResolvedConfig } from "@aws-sdk/middleware-retry";
import { AwsAuthInputConfig, AwsAuthResolvedConfig } from "@aws-sdk/middleware-signing";
import { UserAgentInputConfig, UserAgentResolvedConfig } from "@aws-sdk/middleware-user-agent";
import { HttpHandler as __HttpHandler } from "@aws-sdk/protocol-http";
import { Client as __Client, DefaultsMode, SmithyConfiguration as __SmithyConfiguration, SmithyResolvedConfiguration as __SmithyResolvedConfiguration } from "@aws-sdk/smithy-client";
import { BodyLengthCalculator as __BodyLengthCalculator, Credentials as __Credentials, Decoder as __Decoder, Encoder as __Encoder, HashConstructor as __HashConstructor, HttpHandlerOptions as __HttpHandlerOptions, Logger as __Logger, Provider as __Provider, Provider, RegionInfoProvider, StreamCollector as __StreamCollector, UrlParser as __UrlParser, UserAgent as __UserAgent } from "@aws-sdk/types";
import { CancelRotateSecretCommandInput, CancelRotateSecretCommandOutput } from "./commands/CancelRotateSecretCommand";
import { CreateSecretCommandInput, CreateSecretCommandOutput } from "./commands/CreateSecretCommand";
import { DeleteResourcePolicyCommandInput, DeleteResourcePolicyCommandOutput } from "./commands/DeleteResourcePolicyCommand";
import { DeleteSecretCommandInput, DeleteSecretCommandOutput } from "./commands/DeleteSecretCommand";
import { DescribeSecretCommandInput, DescribeSecretCommandOutput } from "./commands/DescribeSecretCommand";
import { GetRandomPasswordCommandInput, GetRandomPasswordCommandOutput } from "./commands/GetRandomPasswordCommand";
import { GetResourcePolicyCommandInput, GetResourcePolicyCommandOutput } from "./commands/GetResourcePolicyCommand";
import { GetSecretValueCommandInput, GetSecretValueCommandOutput } from "./commands/GetSecretValueCommand";
import { ListSecretsCommandInput, ListSecretsCommandOutput } from "./commands/ListSecretsCommand";
import { ListSecretVersionIdsCommandInput, ListSecretVersionIdsCommandOutput } from "./commands/ListSecretVersionIdsCommand";
import { PutResourcePolicyCommandInput, PutResourcePolicyCommandOutput } from "./commands/PutResourcePolicyCommand";
import { PutSecretValueCommandInput, PutSecretValueCommandOutput } from "./commands/PutSecretValueCommand";
import { RemoveRegionsFromReplicationCommandInput, RemoveRegionsFromReplicationCommandOutput } from "./commands/RemoveRegionsFromReplicationCommand";
import { ReplicateSecretToRegionsCommandInput, ReplicateSecretToRegionsCommandOutput } from "./commands/ReplicateSecretToRegionsCommand";
import { RestoreSecretCommandInput, RestoreSecretCommandOutput } from "./commands/RestoreSecretCommand";
import { RotateSecretCommandInput, RotateSecretCommandOutput } from "./commands/RotateSecretCommand";
import { StopReplicationToReplicaCommandInput, StopReplicationToReplicaCommandOutput } from "./commands/StopReplicationToReplicaCommand";
import { TagResourceCommandInput, TagResourceCommandOutput } from "./commands/TagResourceCommand";
import { UntagResourceCommandInput, UntagResourceCommandOutput } from "./commands/UntagResourceCommand";
import { UpdateSecretCommandInput, UpdateSecretCommandOutput } from "./commands/UpdateSecretCommand";
import { UpdateSecretVersionStageCommandInput, UpdateSecretVersionStageCommandOutput } from "./commands/UpdateSecretVersionStageCommand";
import { ValidateResourcePolicyCommandInput, ValidateResourcePolicyCommandOutput } from "./commands/ValidateResourcePolicyCommand";
export declare type ServiceInputTypes = CancelRotateSecretCommandInput | CreateSecretCommandInput | DeleteResourcePolicyCommandInput | DeleteSecretCommandInput | DescribeSecretCommandInput | GetRandomPasswordCommandInput | GetResourcePolicyCommandInput | GetSecretValueCommandInput | ListSecretVersionIdsCommandInput | ListSecretsCommandInput | PutResourcePolicyCommandInput | PutSecretValueCommandInput | RemoveRegionsFromReplicationCommandInput | ReplicateSecretToRegionsCommandInput | RestoreSecretCommandInput | RotateSecretCommandInput | StopReplicationToReplicaCommandInput | TagResourceCommandInput | UntagResourceCommandInput | UpdateSecretCommandInput | UpdateSecretVersionStageCommandInput | ValidateResourcePolicyCommandInput;
export declare type ServiceOutputTypes = CancelRotateSecretCommandOutput | CreateSecretCommandOutput | DeleteResourcePolicyCommandOutput | DeleteSecretCommandOutput | DescribeSecretCommandOutput | GetRandomPasswordCommandOutput | GetResourcePolicyCommandOutput | GetSecretValueCommandOutput | ListSecretVersionIdsCommandOutput | ListSecretsCommandOutput | PutResourcePolicyCommandOutput | PutSecretValueCommandOutput | RemoveRegionsFromReplicationCommandOutput | ReplicateSecretToRegionsCommandOutput | RestoreSecretCommandOutput | RotateSecretCommandOutput | StopReplicationToReplicaCommandOutput | TagResourceCommandOutput | UntagResourceCommandOutput | UpdateSecretCommandOutput | UpdateSecretVersionStageCommandOutput | ValidateResourcePolicyCommandOutput;
export interface ClientDefaults extends Partial<__SmithyResolvedConfiguration<__HttpHandlerOptions>> {
    
    requestHandler?: __HttpHandler;
    
    sha256?: __HashConstructor;
    
    urlParser?: __UrlParser;
    
    bodyLengthChecker?: __BodyLengthCalculator;
    
    streamCollector?: __StreamCollector;
    
    base64Decoder?: __Decoder;
    
    base64Encoder?: __Encoder;
    
    utf8Decoder?: __Decoder;
    
    utf8Encoder?: __Encoder;
    
    runtime?: string;
    
    disableHostPrefix?: boolean;
    
    maxAttempts?: number | __Provider<number>;
    
    retryMode?: string | __Provider<string>;
    
    logger?: __Logger;
    
    useDualstackEndpoint?: boolean | __Provider<boolean>;
    
    useFipsEndpoint?: boolean | __Provider<boolean>;
    
    serviceId?: string;
    
    region?: string | __Provider<string>;
    
    credentialDefaultProvider?: (input: any) => __Provider<__Credentials>;
    
    regionInfoProvider?: RegionInfoProvider;
    
    defaultUserAgentProvider?: Provider<__UserAgent>;
    
    defaultsMode?: DefaultsMode | Provider<DefaultsMode>;
}
declare type SecretsManagerClientConfigType = Partial<__SmithyConfiguration<__HttpHandlerOptions>> & ClientDefaults & RegionInputConfig & EndpointsInputConfig & RetryInputConfig & HostHeaderInputConfig & AwsAuthInputConfig & UserAgentInputConfig;

export interface SecretsManagerClientConfig extends SecretsManagerClientConfigType {
}
declare type SecretsManagerClientResolvedConfigType = __SmithyResolvedConfiguration<__HttpHandlerOptions> & Required<ClientDefaults> & RegionResolvedConfig & EndpointsResolvedConfig & RetryResolvedConfig & HostHeaderResolvedConfig & AwsAuthResolvedConfig & UserAgentResolvedConfig;

export interface SecretsManagerClientResolvedConfig extends SecretsManagerClientResolvedConfigType {
}

export declare class SecretsManagerClient extends __Client<__HttpHandlerOptions, ServiceInputTypes, ServiceOutputTypes, SecretsManagerClientResolvedConfig> {
    
    readonly config: SecretsManagerClientResolvedConfig;
    constructor(configuration: SecretsManagerClientConfig);
    
    destroy(): void;
}
export {};
