"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTesting = void 0;
const path = require("path");
const lambda = require("@aws-cdk/aws-lambda");
const cdk = require("@aws-cdk/core");
const index_1 = require("./index");
class IntegTesting {
    constructor() {
        const app = new cdk.App();
        const env = {
            region: process.env.CDK_DEFAULT_REGION,
            account: process.env.CDK_DEFAULT_ACCOUNT,
        };
        const stackTest = new cdk.Stack(app, 'TestStackCreateLambda', { env });
        const fn = new lambda.DockerImageFunction(stackTest, 'TestLambda', {
            code: lambda.DockerImageCode.fromImageAsset(path.join(__dirname, '../lambda')),
            currentVersionOptions: {
                removalPolicy: cdk.RemovalPolicy.RETAIN,
            },
        });
        new index_1.LambdaAliasRetention(stackTest, 'TestLambdaAliasRetention', {
            fn,
            lambdaAlias: 'v2',
        });
        app.synth();
        this.stack = [stackTest];
    }
}
exports.IntegTesting = IntegTesting;
new IntegTesting();
//# sourceMappingURL=data:application/json;base64,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