"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaAliasRetention = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const iam = require("@aws-cdk/aws-iam");
const lambda = require("@aws-cdk/aws-lambda");
const logs = require("@aws-cdk/aws-logs");
const cdk = require("@aws-cdk/core");
const cr = require("@aws-cdk/custom-resources");
/**
 * @stability stable
 */
class LambdaAliasRetention extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        const onEvent = new lambda.Function(this, 'MyHandler', {
            runtime: lambda.Runtime.PYTHON_3_8,
            code: lambda.Code.fromAsset(path.join(__dirname, '../custom-resource-handler')),
            handler: 'lambda-alias-retention.on_event',
        });
        const myProvider = new cr.Provider(this, 'LambdaAliasProvider', {
            onEventHandler: onEvent,
            logRetention: logs.RetentionDays.ONE_DAY,
        });
        onEvent.addToRolePolicy(new iam.PolicyStatement({
            actions: ['lambda:CreateAlias'],
            resources: [`arn:aws:lambda:${cdk.Stack.of(this).region}:${cdk.Stack.of(this).account}:function:${props.fn.functionName}`],
        }));
        const outputs = new cdk.CustomResource(this, 'LambdaAlias', {
            serviceToken: myProvider.serviceToken,
            properties: {
                regionName: cdk.Stack.of(this).region,
                functionName: props.fn.functionName,
                version: props.fn.currentVersion.version,
                alias: props.lambdaAlias,
            },
        });
        onEvent.node.addDependency(props.fn);
        outputs.node.addDependency(props.fn);
    }
}
exports.LambdaAliasRetention = LambdaAliasRetention;
_a = JSII_RTTI_SYMBOL_1;
LambdaAliasRetention[_a] = { fqn: "cdk-lambda-alias-retention.LambdaAliasRetention", version: "1.0.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSw2QkFBNkI7QUFDN0Isd0NBQXdDO0FBQ3hDLDhDQUE4QztBQUM5QywwQ0FBMEM7QUFDMUMscUNBQXFDO0FBQ3JDLGdEQUFnRDs7OztBQU9oRCxNQUFhLG9CQUFxQixTQUFRLEdBQUcsQ0FBQyxTQUFTOzs7O0lBQ3JELFlBQVksS0FBb0IsRUFBRSxFQUFVLEVBQUUsS0FBZ0M7UUFDNUUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixNQUFNLE9BQU8sR0FBRyxJQUFJLE1BQU0sQ0FBQyxRQUFRLENBQUMsSUFBSSxFQUFFLFdBQVcsRUFBRTtZQUNyRCxPQUFPLEVBQUUsTUFBTSxDQUFDLE9BQU8sQ0FBQyxVQUFVO1lBQ2xDLElBQUksRUFBRSxNQUFNLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLFNBQVMsRUFBRSw0QkFBNEIsQ0FBQyxDQUFDO1lBQy9FLE9BQU8sRUFBRSxpQ0FBaUM7U0FDM0MsQ0FBQyxDQUFDO1FBRUgsTUFBTSxVQUFVLEdBQUcsSUFBSSxFQUFFLENBQUMsUUFBUSxDQUFDLElBQUksRUFBRSxxQkFBcUIsRUFBRTtZQUM5RCxjQUFjLEVBQUUsT0FBTztZQUN2QixZQUFZLEVBQUUsSUFBSSxDQUFDLGFBQWEsQ0FBQyxPQUFPO1NBQ3pDLENBQUMsQ0FBQztRQUVILE9BQU8sQ0FBQyxlQUFlLENBQUMsSUFBSSxHQUFHLENBQUMsZUFBZSxDQUFDO1lBQzlDLE9BQU8sRUFBRSxDQUFDLG9CQUFvQixDQUFDO1lBQy9CLFNBQVMsRUFBRSxDQUFDLGtCQUFrQixHQUFHLENBQUMsS0FBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxNQUFNLElBQUksR0FBRyxDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsT0FBTyxhQUFhLEtBQUssQ0FBQyxFQUFFLENBQUMsWUFBWSxFQUFFLENBQUM7U0FDM0gsQ0FBQyxDQUFDLENBQUM7UUFFSixNQUFNLE9BQU8sR0FBRyxJQUFJLEdBQUcsQ0FBQyxjQUFjLENBQUMsSUFBSSxFQUFFLGFBQWEsRUFBRTtZQUMxRCxZQUFZLEVBQUUsVUFBVSxDQUFDLFlBQVk7WUFDckMsVUFBVSxFQUFFO2dCQUNWLFVBQVUsRUFBRSxHQUFHLENBQUMsS0FBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxNQUFNO2dCQUNyQyxZQUFZLEVBQUUsS0FBSyxDQUFDLEVBQUUsQ0FBQyxZQUFZO2dCQUNuQyxPQUFPLEVBQUUsS0FBSyxDQUFDLEVBQUUsQ0FBQyxjQUFjLENBQUMsT0FBTztnQkFDeEMsS0FBSyxFQUFFLEtBQUssQ0FBQyxXQUFXO2FBQ3pCO1NBQ0YsQ0FBQyxDQUFDO1FBRUgsT0FBTyxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsS0FBSyxDQUFDLEVBQUUsQ0FBQyxDQUFDO1FBQ3JDLE9BQU8sQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUMsQ0FBQztJQUN2QyxDQUFDOztBQWhDSCxvREFpQ0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBwYXRoIGZyb20gJ3BhdGgnO1xuaW1wb3J0ICogYXMgaWFtIGZyb20gJ0Bhd3MtY2RrL2F3cy1pYW0nO1xuaW1wb3J0ICogYXMgbGFtYmRhIGZyb20gJ0Bhd3MtY2RrL2F3cy1sYW1iZGEnO1xuaW1wb3J0ICogYXMgbG9ncyBmcm9tICdAYXdzLWNkay9hd3MtbG9ncyc7XG5pbXBvcnQgKiBhcyBjZGsgZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgKiBhcyBjciBmcm9tICdAYXdzLWNkay9jdXN0b20tcmVzb3VyY2VzJztcblxuZXhwb3J0IGludGVyZmFjZSBMYW1iZGFBbGlhc1JldGVudGlvblByb3BzIHtcbiAgcmVhZG9ubHkgZm46IGxhbWJkYS5GdW5jdGlvbjtcbiAgcmVhZG9ubHkgbGFtYmRhQWxpYXM6IHN0cmluZztcbn1cblxuZXhwb3J0IGNsYXNzIExhbWJkYUFsaWFzUmV0ZW50aW9uIGV4dGVuZHMgY2RrLkNvbnN0cnVjdCB7XG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBjZGsuQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogTGFtYmRhQWxpYXNSZXRlbnRpb25Qcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICBjb25zdCBvbkV2ZW50ID0gbmV3IGxhbWJkYS5GdW5jdGlvbih0aGlzLCAnTXlIYW5kbGVyJywge1xuICAgICAgcnVudGltZTogbGFtYmRhLlJ1bnRpbWUuUFlUSE9OXzNfOCxcbiAgICAgIGNvZGU6IGxhbWJkYS5Db2RlLmZyb21Bc3NldChwYXRoLmpvaW4oX19kaXJuYW1lLCAnLi4vY3VzdG9tLXJlc291cmNlLWhhbmRsZXInKSksXG4gICAgICBoYW5kbGVyOiAnbGFtYmRhLWFsaWFzLXJldGVudGlvbi5vbl9ldmVudCcsXG4gICAgfSk7XG5cbiAgICBjb25zdCBteVByb3ZpZGVyID0gbmV3IGNyLlByb3ZpZGVyKHRoaXMsICdMYW1iZGFBbGlhc1Byb3ZpZGVyJywge1xuICAgICAgb25FdmVudEhhbmRsZXI6IG9uRXZlbnQsXG4gICAgICBsb2dSZXRlbnRpb246IGxvZ3MuUmV0ZW50aW9uRGF5cy5PTkVfREFZLFxuICAgIH0pO1xuXG4gICAgb25FdmVudC5hZGRUb1JvbGVQb2xpY3kobmV3IGlhbS5Qb2xpY3lTdGF0ZW1lbnQoe1xuICAgICAgYWN0aW9uczogWydsYW1iZGE6Q3JlYXRlQWxpYXMnXSxcbiAgICAgIHJlc291cmNlczogW2Bhcm46YXdzOmxhbWJkYToke2Nkay5TdGFjay5vZih0aGlzKS5yZWdpb259OiR7Y2RrLlN0YWNrLm9mKHRoaXMpLmFjY291bnR9OmZ1bmN0aW9uOiR7cHJvcHMuZm4uZnVuY3Rpb25OYW1lfWBdLFxuICAgIH0pKTtcblxuICAgIGNvbnN0IG91dHB1dHMgPSBuZXcgY2RrLkN1c3RvbVJlc291cmNlKHRoaXMsICdMYW1iZGFBbGlhcycsIHtcbiAgICAgIHNlcnZpY2VUb2tlbjogbXlQcm92aWRlci5zZXJ2aWNlVG9rZW4sXG4gICAgICBwcm9wZXJ0aWVzOiB7XG4gICAgICAgIHJlZ2lvbk5hbWU6IGNkay5TdGFjay5vZih0aGlzKS5yZWdpb24sXG4gICAgICAgIGZ1bmN0aW9uTmFtZTogcHJvcHMuZm4uZnVuY3Rpb25OYW1lLFxuICAgICAgICB2ZXJzaW9uOiBwcm9wcy5mbi5jdXJyZW50VmVyc2lvbi52ZXJzaW9uLFxuICAgICAgICBhbGlhczogcHJvcHMubGFtYmRhQWxpYXMsXG4gICAgICB9LFxuICAgIH0pO1xuXG4gICAgb25FdmVudC5ub2RlLmFkZERlcGVuZGVuY3kocHJvcHMuZm4pO1xuICAgIG91dHB1dHMubm9kZS5hZGREZXBlbmRlbmN5KHByb3BzLmZuKTtcbiAgfVxufSJdfQ==