#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['sklearndf',
 'sklearndf.classification',
 'sklearndf.classification.extra',
 'sklearndf.pipeline',
 'sklearndf.regression',
 'sklearndf.regression.extra',
 'sklearndf.transformation',
 'sklearndf.transformation.extra']

package_data = \
{'': ['*']}

package_dir = \
{'': 'src'}

install_requires = \
['boruta >= 0.3',
 'lightgbm >= 3.0',
 'scikit-learn >=0.21,<0.24',
 'tableone >= 0.7',
 'pandas >= 0.24,<1.3',
 'numpy  >= 1.16,<1.20',
 'joblib >= 0.13,<1.0',
 'scipy  >= 1.2,<1.6',
 'typing_inspect >= 0.4',
 'pyyaml >= 5.0',
 'gamma-pytools >= 1.0.1',
 'packaging >= 20']

extras_require = \
{'docs': ['sphinx == 3.2.*',
          'sphinx-autodoc-typehints == 1.11.*',
          'pydata-sphinx-theme == 0.4.*',
          'nbsphinx == 0.7.*',
          'jupyter >= 1.0',
          'docutils',
          'xlrd == 1.2.*',
          'm2r == 0.2.*'],
 'testing': ['pytest >= 5.2.*',
             'pytest-cov == 2.8.*',
             'flake8 == 3.8.*',
             'flake8-comprehensions == 3.2.*',
             'isort == 5.5.*']}

setup(name='sklearndf',
      version='1.0.1',
      description='DataFrame support and feature traceability for scikit-learn.',
      author='Boston Consulting Group (BCG)',
      author_email=None,
      url='https://github.com/BCG-Gamma/sklearndf',
      packages=packages,
      package_data=package_data,
      package_dir=package_dir,
      install_requires=install_requires,
      extras_require=extras_require,
      python_requires='>=3.6,<4',
     )
