# Autogenerated file. Do not edit.
from jacdac.bus import Bus, SensorClient
from .constants import *
from typing import Optional


class SensorAggregatorClient(SensorClient):
    """
    Aggregate data from multiple sensors into a single stream
     * (often used as input to machine learning models on the same device, see model runner service).
    Implements a client for the `Sensor Aggregator <https://microsoft.github.io/jacdac-docs/services/sensoraggregator>`_ service.
    """

    def __init__(self, bus: Bus, role: str) -> None:
        super().__init__(bus, JD_SERVICE_CLASS_SENSOR_AGGREGATOR, JD_SENSOR_AGGREGATOR_PACK_FORMATS, role)
    

    @property
    def num_samples(self) -> Optional[int]:
        """
        Number of input samples collected so far., 
        """
        return self.register(JD_SENSOR_AGGREGATOR_REG_NUM_SAMPLES).value()

    @property
    def sample_size(self) -> Optional[int]:
        """
        Size of a single sample., _: B
        """
        return self.register(JD_SENSOR_AGGREGATOR_REG_SAMPLE_SIZE).value()

    @property
    def streaming_samples(self) -> Optional[int]:
        """
        When set to `N`, will stream `N` samples as `current_sample` reading., _: #
        """
        return self.register(JD_SENSOR_AGGREGATOR_REG_STREAMING_SAMPLES).value()

    @streaming_samples.setter
    def streaming_samples(self, value: int) -> None:
        self.register(JD_SENSOR_AGGREGATOR_REG_STREAMING_SAMPLES).set_values(value)


    @property
    def current_sample(self) -> Optional[bytes]:
        """
        Last collected sample., 
        """
        self.refresh_reading()
        return self.register(JD_SENSOR_AGGREGATOR_REG_CURRENT_SAMPLE).value()

    
