# Autogenerated file. Do not edit.
from jacdac.bus import Bus, Client
from .constants import *
from typing import Optional


class DmxClient(Client):
    """
    A service that can send DMX512-A packets with limited size. This service is designed to allow tinkering with a few DMX devices, but only allows 235 channels. More about DMX at https://en.wikipedia.org/wiki/DMX512.
    Implements a client for the `DMX <https://microsoft.github.io/jacdac-docs/services/dmx>`_ service.
    """

    def __init__(self, bus: Bus, role: str) -> None:
        super().__init__(bus, JD_SERVICE_CLASS_DMX, JD_DMX_PACK_FORMATS, role)
    

    @property
    def enabled(self) -> Optional[bool]:
        """
        Determines if the DMX bridge is active, 
        """
        return self.register(JD_DMX_REG_ENABLED).bool_value()

    @enabled.setter
    def enabled(self, value: bool) -> None:
        self.register(JD_DMX_REG_ENABLED).set_values(value)



    def send(self, channels: bytes) -> None:
        """
        Send a DMX packet, up to 236bytes long, including the start code.
        """
        self.send_cmd_packed(JD_DMX_CMD_SEND, channels)
    
