"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserPoolIdentityProviderBase = exports.ProviderAttribute = void 0;
const core_1 = require("@aws-cdk/core");
const attr_names_1 = require("../private/attr-names");
/**
 * An attribute available from a third party identity provider.
 */
class ProviderAttribute {
    constructor(attributeName) {
        this.attributeName = attributeName;
    }
    /**
     * Use this to specify an attribute from the identity provider that is not pre-defined in the CDK.
     * @param attributeName the attribute value string as recognized by the provider
     */
    static other(attributeName) {
        return new ProviderAttribute(attributeName);
    }
}
exports.ProviderAttribute = ProviderAttribute;
/** The user id attribute provided by Amazon */
ProviderAttribute.AMAZON_USER_ID = new ProviderAttribute('user_id');
/** The email attribute provided by Amazon */
ProviderAttribute.AMAZON_EMAIL = new ProviderAttribute('email');
/** The name attribute provided by Amazon */
ProviderAttribute.AMAZON_NAME = new ProviderAttribute('name');
/** The postal code attribute provided by Amazon */
ProviderAttribute.AMAZON_POSTAL_CODE = new ProviderAttribute('postal_code');
/** The user id attribute provided by Facebook */
ProviderAttribute.FACEBOOK_ID = new ProviderAttribute('id');
/** The birthday attribute provided by Facebook */
ProviderAttribute.FACEBOOK_BIRTHDAY = new ProviderAttribute('birthday');
/** The email attribute provided by Facebook */
ProviderAttribute.FACEBOOK_EMAIL = new ProviderAttribute('email');
/** The name attribute provided by Facebook */
ProviderAttribute.FACEBOOK_NAME = new ProviderAttribute('name');
/** The first name attribute provided by Facebook */
ProviderAttribute.FACEBOOK_FIRST_NAME = new ProviderAttribute('first_name');
/** The last name attribute provided by Facebook */
ProviderAttribute.FACEBOOK_LAST_NAME = new ProviderAttribute('last_name');
/** The middle name attribute provided by Facebook */
ProviderAttribute.FACEBOOK_MIDDLE_NAME = new ProviderAttribute('middle_name');
/** The gender attribute provided by Facebook */
ProviderAttribute.FACEBOOK_GENDER = new ProviderAttribute('gender');
/** The locale attribute provided by Facebook */
ProviderAttribute.FACEBOOK_LOCALE = new ProviderAttribute('locale');
/**
 * Options to integrate with the various social identity providers.
 */
class UserPoolIdentityProviderBase extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        props.userPool.registerIdentityProvider(this);
    }
    configureAttributeMapping() {
        if (!this.props.attributeMapping) {
            return undefined;
        }
        let mapping = {};
        mapping = Object.entries(this.props.attributeMapping)
            .filter(([k, _]) => k !== 'custom') // 'custom' handled later separately
            .reduce((agg, [k, v]) => {
            return { ...agg, [attr_names_1.StandardAttributeNames[k]]: v.attributeName };
        }, mapping);
        if (this.props.attributeMapping.custom) {
            mapping = Object.entries(this.props.attributeMapping.custom).reduce((agg, [k, v]) => {
                return { ...agg, [k]: v.attributeName };
            }, mapping);
        }
        if (Object.keys(mapping).length === 0) {
            return undefined;
        }
        return mapping;
    }
}
exports.UserPoolIdentityProviderBase = UserPoolIdentityProviderBase;
//# sourceMappingURL=data:application/json;base64,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