# Web Extension Helper

[Web Extension Helper](https://www.appsolves.dev/python-packages/web-extension-helper) is a command-line tool that simplifies the process of building web extensions. It provides a convenient interface to streamline the development and packaging of your web extensions.

## Features

- Easily scaffold a new web extension project.
- Automate common tasks like bundling and minification.
- Simplify the process of building and publishing your web extension.

## Installation

Web Extension Helper can be installed via pip:

```shell
pip install web-ext-helper

# or

python -m pip install web-ext-helper
```

## Usage

To use Web Extension Helper, run the web-ext-helper command followed by the desired action. Here are some examples:

```shell
* Build the web extension
web-ext-helper build

* Sign the web extension
web-ext-helper sign

* Publish the web extension
web-ext-helper publish

* Create a new manifest.json file
web-ext-helper manifest --create

* View the current manifest.json file
web-ext-helper manifest

* View the help menu
web-ext-helper --help
```

## Documentation

For more information, please visit the [documentation](https://www.appsolves.dev/python-packages/web-extension-helper/documentation).

## License
This project is licensed under the terms of the [GNU GPL v3.0 license](https://www.appsolves.dev/python-packages/web-extension-helper/license).

# Contributing

Contributions are welcome! If you encounter any issues or have suggestions for improvements, please create an issue or submit a pull request.

# Credits

This project was created, developed and is maintained by [AppSolves](https://www.appsolves.dev/).

# Support

If you need any assistance or have any questions, feel free to contact me at [appsolves@gmail.com](mailto:appsolves@gmail.com).