# 🧩 projext: Project-to-Text Mapper

A versatile CLI tool that scans your project directories and generates a comprehensive "map" of your codebase.

---

<details open>
<summary><strong>English README</strong> (Click to expand)</summary>

`projext` is a versatile CLI tool that scans your project directories and generates a comprehensive "map" of your codebase in various formats. It's designed to help you quickly understand project structures, analyze code components, and create context for Large Language Models (LLMs).

### Features

-   **Dual Output Modes**: Generate a map with the full content of files (`full` mode) or a structured summary of Python files using AST (`ast` mode).
-   **Directory Tree Generation**: Output a classic directory tree structure, similar to the `tree` command.
-   **Flexible Configuration**: Fine-tune what to include/exclude with options for file extensions, size limits, exclusion patterns, and per-file mode overrides.
-   **Multiple Formats**: Output the project map as Markdown for human readability or JSON for machine processing (e.g., RAG pipelines).
-   **AST Analysis**: In `ast` mode, `projext` extracts key information from Python files, including classes, functions (with type hints and docstrings), and imports.

### Installation

```bash
pip install projext
```

### Usage

`projext` has two main commands: `map` and `tree`.

#### `projext map <path> [options]`

Scans a directory and generates a detailed map of file contents.

**Arguments**
-   **`<path>`** (Required): The root directory of the project you want to scan.

**Options**

| Option            | Description                                                                                                       | Default                  |
| ----------------- | ----------------------------------------------------------------------------------------------------------------- | ------------------------ |
| `--ext`           | A comma-separated list of file extensions to include in the scan.                                                 | `.py,.json,.md`          |
| `--out`           | The name of the output file.                                                                                      | `project_tree.md`        |
| `--format`        | The output format. Can be `md` (Markdown) or `json`.                                                              | `md`                     |
| `--max-file-size` | The maximum size for a single file to be included. (e.g., `1MB`, `500K`).                                          | `1MB`                    |
| `--mode`          | The default processing mode: `full` (file content) or `ast` (Python code summary).                                | `full`                   |
| `--full`          | A file or directory path to force `full` mode on, overriding the default. Can be used multiple times.               | N/A                      |
| `--ast`           | A file or directory path to force `ast` mode on for Python files, overriding the default. Can be used multiple times. | N/A                      |
| `--exclude`       | A glob pattern to exclude files or directories. Can be used multiple times.                                       | N/A                      |

#### `projext tree <path> [options]`

Generates a classic directory tree structure.

**Arguments**
-   **`<path>`** (Required): The root directory to create a tree from.

**Options**

| Option      | Description                                                                   | Default            |
| ----------- | ----------------------------------------------------------------------------- | ------------------ |
| `--out`     | The name of the output file.                                                  | `project_tree.txt` |
| `--exclude` | A glob pattern to exclude files or directories. Can be used multiple times.   | N/A                |


### Use Cases & Examples

#### 1. Basic Project Overview (AST Mode)

Generate a structural summary of a Python project. This is useful for quickly understanding the architecture.

```bash
projext map ./my-python-app --mode ast --out ast_summary.md
```

#### 2. Full Content Map

Create a complete map of a project with the full content of all specified files.

```bash
projext map ./my-project --ext .py,.md --out overview.md
```

#### 3. Directory Tree

Generate a simple, clean directory tree, excluding `node_modules` and `.git` by default.

```bash
projext tree . --out tree.txt
```

#### 4. Hybrid Mode for Mixed Analysis

Use `full` mode as the default, but specifically request an AST summary for a complex part of the application.

```bash
projext map ./my-project --mode full --ast ./my-project/core/
```

#### 5. Excluding Files and Directories

Generate a map while excluding test files and temporary directories.

```bash
projext map . --exclude "tests/*" --exclude "temp/"
```

### License

This project is licensed under the MIT License.

</details>

<br>

<details>
<summary><strong>日本語 README</strong> (クリックして展開)</summary>

`projext` は、プロジェクトディレクトリをスキャンし、コードベースの包括的な「マップ」を様々な形式で生成する、多機能なCLIツールです。プロジェクト構造の迅速な理解、コードコンポーネントの分析、そして大規模言語モデル（LLM）向けのコンテキスト作成を支援します。

### ✨ 主な機能

-   **デュアル出力モード**: ファイルの全コンテンツを含むマップ（`full`モード）または、Pythonファイルの構造化サマリ（`ast`モード）を生成します。
-   **ディレクトリツリー生成**: `tree`コマンドに似た、クラシックなディレクトリツリー構造を出力します。
-   **柔軟な設定**: ファイル拡張子、サイズ上限、除外パターン、ファイルごとのモード上書きなど、スキャン対象を細かく調整できます。
-   **複数フォーマット対応**: 人間が読みやすいMarkdown形式、または機械処理（RAGパイプラインなど）に適したJSON形式でマップを出力します。
-   **AST解析**: `ast`モードでは、クラス、関数（型ヒントやdocstringを含む）、インポート文など、Pythonファイルの重要な情報を抽出します。

### 📦 インストール

```bash
pip install projext
```

### 使い方

`projext` には `map` と `tree` の2つの主要なコマンドがあります。

#### `projext map <path> [options]`

ディレクトリをスキャンし、ファイルコンテンツの詳細なマップを生成します。

**引数**
-   **`<path>`** (必須): スキャンしたいプロジェクトのルートディレクトリ。

**オプション**

| オプション        | 説明                                                                                                 | デフォルト             |
| ----------------- | ---------------------------------------------------------------------------------------------------- | ---------------------- |
| `--ext`           | スキャンに含めるファイル拡張子をカンマ区切りで指定します。                                           | `.py,.json,.md`        |
| `--out`           | 出力ファイル名。                                                                                     | `project_tree.md`      |
| `--format`        | 出力フォーマット。`md` (Markdown) または `json` を指定できます。                                     | `md`                   |
| `--max-file-size` | スキャンに含める単一ファイルの最大サイズ（例: `1MB`, `500K`）。                                      | `1MB`                  |
| `--mode`          | デフォルトの処理モード: `full` (ファイル全体) または `ast` (Pythonコードの要約)。                      | `full`                 |
| `--full`          | デフォルトモードを上書きし、`full`モードを強制するファイル/ディレクトリ。複数回指定可能。            | N/A                    |
| `--ast`           | デフォルトモードを上書きし、Pythonファイルに`ast`モードを強制するファイル/ディレクトリ。複数回指定可能。 | N/A                    |
| `--exclude`       | 除外するファイルやディレクトリのglobパターン。複数回指定可能。                                       | N/A                    |

#### `projext tree <path> [options]`

クラシックなディレクトリツリー構造を生成します。

**引数**
-   **`<path>`** (必須): ツリーを生成するルートディレクトリ。

**オプション**

| オプション      | 説明                                                                | デフォルト           |
| ----------- | ------------------------------------------------------------------- | ------------------ |
| `--out`     | 出力ファイル名。                                                    | `project_tree.txt` |
| `--exclude` | 除外するファイルやディレクトリのglobパターン。複数回指定可能。      | N/A                |


### ユースケースと実行例

#### 1. 基本的なプロジェクト概要（ASTモード）

Pythonプロジェクトの構造的なサマリを生成します。アーキテクチャを素早く理解するのに役立ちます。

```bash
projext map ./my-python-app --mode ast --out ast_summary.md
```

#### 2. フルコンテンツ・マップ

指定されたすべてのファイルの全コンテンツを含む完全なマップを作成します。

```bash
projext map ./my-project --ext .py,.md --out overview.md
```

#### 3. ディレクトリツリー

`node_modules` や `.git` などをデフォルトで除外した、シンプルでクリーンなディレクトリツリーを生成します。

```bash
projext tree . --out tree.txt
```

#### 4. ハイブリッドモードでの複合分析

デフォルトは `full` モードを使いつつ、アプリケーションの複雑な部分だけASTサマリをリクエストします。

```bash
projext map ./my-project --mode full --ast ./my-project/core/
```

#### 5. ファイルとディレクトリの除外

テストファイルや一時ディレクトリを除外してマップを生成します。

```bash
projext map . --exclude "tests/*" --exclude "temp/"
```

### ライセンス

このプロジェクトはMITライセンスの下で公開されています。

</details>
