# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *
import pulumi_kubernetes

__all__ = ['CoreDNSArgs', 'CoreDNS']

@pulumi.input_type
class CoreDNSArgs:
    def __init__(__self__, *,
                 affinity: Optional[pulumi.Input['pulumi_kubernetes.core.v1.AffinityArgs']] = None,
                 autoscaler: Optional[pulumi.Input['CoreDNSAutoscalerArgs']] = None,
                 autoscaling: Optional[pulumi.Input['pulumi_kubernetes.autoscaling.v2beta2.HorizontalPodAutoscalerSpecArgs']] = None,
                 deployment: Optional[pulumi.Input['CoreDNSDeploymentArgs']] = None,
                 extra_secrets: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_kubernetes.core.v1.VolumeMountArgs']]]] = None,
                 extra_volume_mounts: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_kubernetes.core.v1.VolumeMountArgs']]]] = None,
                 extra_volumes: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_kubernetes.core.v1.VolumeArgs']]]] = None,
                 helm_options: Optional[pulumi.Input['ReleaseArgs']] = None,
                 hpa: Optional[pulumi.Input['CoreDNSHPAArgs']] = None,
                 image: Optional[pulumi.Input['CoreDNSImageArgs']] = None,
                 is_cluster_service: Optional[pulumi.Input[bool]] = None,
                 liveness_probe: Optional[pulumi.Input['pulumi_kubernetes.core.v1.ProbeArgs']] = None,
                 node_selector: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 pod_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 pod_disruption_budget: Optional[pulumi.Input['pulumi_kubernetes.policy.v1.PodDisruptionBudgetSpecArgs']] = None,
                 pre_stop_sleep: Optional[pulumi.Input[int]] = None,
                 priority_class_name: Optional[pulumi.Input[str]] = None,
                 prometheus: Optional[pulumi.Input['CoreDNSPrometheusArgs']] = None,
                 rbac: Optional[pulumi.Input['CoreDNSRBACArgs']] = None,
                 readiness_probe: Optional[pulumi.Input['pulumi_kubernetes.core.v1.ProbeArgs']] = None,
                 replica_count: Optional[pulumi.Input[int]] = None,
                 resources: Optional[pulumi.Input['pulumi_kubernetes.core.v1.ResourceRequirementsArgs']] = None,
                 rolling_update: Optional[pulumi.Input['pulumi_kubernetes.apps.v1.RollingUpdateDeploymentArgs']] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input['CoreDNSServerArgs']]]] = None,
                 service: Optional[pulumi.Input['CoreDNSServiceArgs']] = None,
                 service_account: Optional[pulumi.Input['CoreDNSServiceAccountArgs']] = None,
                 service_type: Optional[pulumi.Input[str]] = None,
                 termination_grace_period_seconds: Optional[pulumi.Input[int]] = None,
                 tolerations: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_kubernetes.core.v1.TolerationArgs']]]] = None,
                 zone_files: Optional[pulumi.Input[Sequence[pulumi.Input['CoreDNSZoneFileArgs']]]] = None):
        """
        The set of arguments for constructing a CoreDNS resource.
        :param pulumi.Input['pulumi_kubernetes.core.v1.AffinityArgs'] affinity: Affinity settings for pod assignment.
        :param pulumi.Input['CoreDNSAutoscalerArgs'] autoscaler: Configue a cluster-proportional-autoscaler for coredns. See https://github.com/kubernetes-incubator/cluster-proportional-autoscaler.
        :param pulumi.Input['pulumi_kubernetes.autoscaling.v2beta2.HorizontalPodAutoscalerSpecArgs'] autoscaling: Create HorizontalPodAutoscaler object.
        :param pulumi.Input['CoreDNSDeploymentArgs'] deployment: Configure the CoreDNS Deployment.
        :param pulumi.Input[Sequence[pulumi.Input['pulumi_kubernetes.core.v1.VolumeMountArgs']]] extra_secrets: Optional array of secrets to mount inside coredns container. Possible usecase: need for secure connection with etcd backend. Optional array of mount points for extraVolumes.
        :param pulumi.Input[Sequence[pulumi.Input['pulumi_kubernetes.core.v1.VolumeMountArgs']]] extra_volume_mounts: Optional array of mount points for extraVolumes.
        :param pulumi.Input[Sequence[pulumi.Input['pulumi_kubernetes.core.v1.VolumeArgs']]] extra_volumes: Optional array of extra volumes to create.
        :param pulumi.Input['ReleaseArgs'] helm_options: HelmOptions is an escape hatch that lets the end user control any aspect of the Helm deployment. This exposes the entirety of the underlying Helm Release component args.
        :param pulumi.Input['CoreDNSHPAArgs'] hpa: Alternative configuration for HPA deployment if wanted.
        :param pulumi.Input['CoreDNSImageArgs'] image: The image to pull.
        :param pulumi.Input[bool] is_cluster_service: Specifies whether chart should be deployed as cluster-service or normal k8s app.
        :param pulumi.Input['pulumi_kubernetes.core.v1.ProbeArgs'] liveness_probe: Configure the liveness probe. To use the livenessProbe, the health plugin needs to be enabled in CoreDNS' server config.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] node_selector: Node labels for pod assignment.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] pod_annotations: Optional Pod only Annotations.
        :param pulumi.Input['pulumi_kubernetes.policy.v1.PodDisruptionBudgetSpecArgs'] pod_disruption_budget: Optional PodDisruptionBudget.
        :param pulumi.Input[int] pre_stop_sleep: Under heavy load it takes more that standard time to remove Pod endpoint from a cluster. This will delay termination of our pod by `preStopSleep`. To make sure kube-proxy has enough time to catch up.
        :param pulumi.Input[str] priority_class_name: Optional priority class to be used for the coredns pods. Used for autoscaler if autoscaler.priorityClassName not set.
        :param pulumi.Input['CoreDNSPrometheusArgs'] prometheus: Configure Prometheus installation.
        :param pulumi.Input['CoreDNSRBACArgs'] rbac: Configure CoreDNS RBAC resources.
        :param pulumi.Input['pulumi_kubernetes.core.v1.ProbeArgs'] readiness_probe: Configure the readiness probe. To use the readinessProbe, the health plugin needs to be enabled in CoreDNS' server config.
        :param pulumi.Input[int] replica_count: Number of replicas.
        :param pulumi.Input['pulumi_kubernetes.core.v1.ResourceRequirementsArgs'] resources: Container resource limits.
        :param pulumi.Input[Sequence[pulumi.Input['CoreDNSServerArgs']]] servers: Configuration for CoreDNS and plugins. Default zone is what Kubernetes recommends: https://kubernetes.io/docs/tasks/administer-cluster/dns-custom-nameservers/#coredns-configmap-options
        :param pulumi.Input['CoreDNSServiceArgs'] service: Configure CoreDNS Service parameters.
        :param pulumi.Input['CoreDNSServiceAccountArgs'] service_account: Configure CoreDNS Service Account.
        :param pulumi.Input[str] service_type: Kubernetes Service type.
        :param pulumi.Input[int] termination_grace_period_seconds: Optional duration in seconds the pod needs to terminate gracefully.
        :param pulumi.Input[Sequence[pulumi.Input['pulumi_kubernetes.core.v1.TolerationArgs']]] tolerations: Tolerations for pod assignment.
        :param pulumi.Input[Sequence[pulumi.Input['CoreDNSZoneFileArgs']]] zone_files: Configure custom Zone files.
        """
        if affinity is not None:
            pulumi.set(__self__, "affinity", affinity)
        if autoscaler is not None:
            pulumi.set(__self__, "autoscaler", autoscaler)
        if autoscaling is not None:
            pulumi.set(__self__, "autoscaling", autoscaling)
        if deployment is not None:
            pulumi.set(__self__, "deployment", deployment)
        if extra_secrets is not None:
            pulumi.set(__self__, "extra_secrets", extra_secrets)
        if extra_volume_mounts is not None:
            pulumi.set(__self__, "extra_volume_mounts", extra_volume_mounts)
        if extra_volumes is not None:
            pulumi.set(__self__, "extra_volumes", extra_volumes)
        if helm_options is not None:
            pulumi.set(__self__, "helm_options", helm_options)
        if hpa is not None:
            pulumi.set(__self__, "hpa", hpa)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if is_cluster_service is not None:
            pulumi.set(__self__, "is_cluster_service", is_cluster_service)
        if liveness_probe is not None:
            pulumi.set(__self__, "liveness_probe", liveness_probe)
        if node_selector is not None:
            pulumi.set(__self__, "node_selector", node_selector)
        if pod_annotations is not None:
            pulumi.set(__self__, "pod_annotations", pod_annotations)
        if pod_disruption_budget is not None:
            pulumi.set(__self__, "pod_disruption_budget", pod_disruption_budget)
        if pre_stop_sleep is not None:
            pulumi.set(__self__, "pre_stop_sleep", pre_stop_sleep)
        if priority_class_name is not None:
            pulumi.set(__self__, "priority_class_name", priority_class_name)
        if prometheus is not None:
            pulumi.set(__self__, "prometheus", prometheus)
        if rbac is not None:
            pulumi.set(__self__, "rbac", rbac)
        if readiness_probe is not None:
            pulumi.set(__self__, "readiness_probe", readiness_probe)
        if replica_count is not None:
            pulumi.set(__self__, "replica_count", replica_count)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if rolling_update is not None:
            pulumi.set(__self__, "rolling_update", rolling_update)
        if servers is not None:
            pulumi.set(__self__, "servers", servers)
        if service is not None:
            pulumi.set(__self__, "service", service)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if service_type is not None:
            pulumi.set(__self__, "service_type", service_type)
        if termination_grace_period_seconds is not None:
            pulumi.set(__self__, "termination_grace_period_seconds", termination_grace_period_seconds)
        if tolerations is not None:
            pulumi.set(__self__, "tolerations", tolerations)
        if zone_files is not None:
            pulumi.set(__self__, "zone_files", zone_files)

    @property
    @pulumi.getter
    def affinity(self) -> Optional[pulumi.Input['pulumi_kubernetes.core.v1.AffinityArgs']]:
        """
        Affinity settings for pod assignment.
        """
        return pulumi.get(self, "affinity")

    @affinity.setter
    def affinity(self, value: Optional[pulumi.Input['pulumi_kubernetes.core.v1.AffinityArgs']]):
        pulumi.set(self, "affinity", value)

    @property
    @pulumi.getter
    def autoscaler(self) -> Optional[pulumi.Input['CoreDNSAutoscalerArgs']]:
        """
        Configue a cluster-proportional-autoscaler for coredns. See https://github.com/kubernetes-incubator/cluster-proportional-autoscaler.
        """
        return pulumi.get(self, "autoscaler")

    @autoscaler.setter
    def autoscaler(self, value: Optional[pulumi.Input['CoreDNSAutoscalerArgs']]):
        pulumi.set(self, "autoscaler", value)

    @property
    @pulumi.getter
    def autoscaling(self) -> Optional[pulumi.Input['pulumi_kubernetes.autoscaling.v2beta2.HorizontalPodAutoscalerSpecArgs']]:
        """
        Create HorizontalPodAutoscaler object.
        """
        return pulumi.get(self, "autoscaling")

    @autoscaling.setter
    def autoscaling(self, value: Optional[pulumi.Input['pulumi_kubernetes.autoscaling.v2beta2.HorizontalPodAutoscalerSpecArgs']]):
        pulumi.set(self, "autoscaling", value)

    @property
    @pulumi.getter
    def deployment(self) -> Optional[pulumi.Input['CoreDNSDeploymentArgs']]:
        """
        Configure the CoreDNS Deployment.
        """
        return pulumi.get(self, "deployment")

    @deployment.setter
    def deployment(self, value: Optional[pulumi.Input['CoreDNSDeploymentArgs']]):
        pulumi.set(self, "deployment", value)

    @property
    @pulumi.getter(name="extraSecrets")
    def extra_secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_kubernetes.core.v1.VolumeMountArgs']]]]:
        """
        Optional array of secrets to mount inside coredns container. Possible usecase: need for secure connection with etcd backend. Optional array of mount points for extraVolumes.
        """
        return pulumi.get(self, "extra_secrets")

    @extra_secrets.setter
    def extra_secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_kubernetes.core.v1.VolumeMountArgs']]]]):
        pulumi.set(self, "extra_secrets", value)

    @property
    @pulumi.getter(name="extraVolumeMounts")
    def extra_volume_mounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_kubernetes.core.v1.VolumeMountArgs']]]]:
        """
        Optional array of mount points for extraVolumes.
        """
        return pulumi.get(self, "extra_volume_mounts")

    @extra_volume_mounts.setter
    def extra_volume_mounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_kubernetes.core.v1.VolumeMountArgs']]]]):
        pulumi.set(self, "extra_volume_mounts", value)

    @property
    @pulumi.getter(name="extraVolumes")
    def extra_volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_kubernetes.core.v1.VolumeArgs']]]]:
        """
        Optional array of extra volumes to create.
        """
        return pulumi.get(self, "extra_volumes")

    @extra_volumes.setter
    def extra_volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_kubernetes.core.v1.VolumeArgs']]]]):
        pulumi.set(self, "extra_volumes", value)

    @property
    @pulumi.getter(name="helmOptions")
    def helm_options(self) -> Optional[pulumi.Input['ReleaseArgs']]:
        """
        HelmOptions is an escape hatch that lets the end user control any aspect of the Helm deployment. This exposes the entirety of the underlying Helm Release component args.
        """
        return pulumi.get(self, "helm_options")

    @helm_options.setter
    def helm_options(self, value: Optional[pulumi.Input['ReleaseArgs']]):
        pulumi.set(self, "helm_options", value)

    @property
    @pulumi.getter
    def hpa(self) -> Optional[pulumi.Input['CoreDNSHPAArgs']]:
        """
        Alternative configuration for HPA deployment if wanted.
        """
        return pulumi.get(self, "hpa")

    @hpa.setter
    def hpa(self, value: Optional[pulumi.Input['CoreDNSHPAArgs']]):
        pulumi.set(self, "hpa", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input['CoreDNSImageArgs']]:
        """
        The image to pull.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input['CoreDNSImageArgs']]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter(name="isClusterService")
    def is_cluster_service(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether chart should be deployed as cluster-service or normal k8s app.
        """
        return pulumi.get(self, "is_cluster_service")

    @is_cluster_service.setter
    def is_cluster_service(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_cluster_service", value)

    @property
    @pulumi.getter(name="livenessProbe")
    def liveness_probe(self) -> Optional[pulumi.Input['pulumi_kubernetes.core.v1.ProbeArgs']]:
        """
        Configure the liveness probe. To use the livenessProbe, the health plugin needs to be enabled in CoreDNS' server config.
        """
        return pulumi.get(self, "liveness_probe")

    @liveness_probe.setter
    def liveness_probe(self, value: Optional[pulumi.Input['pulumi_kubernetes.core.v1.ProbeArgs']]):
        pulumi.set(self, "liveness_probe", value)

    @property
    @pulumi.getter(name="nodeSelector")
    def node_selector(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Node labels for pod assignment.
        """
        return pulumi.get(self, "node_selector")

    @node_selector.setter
    def node_selector(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "node_selector", value)

    @property
    @pulumi.getter(name="podAnnotations")
    def pod_annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional Pod only Annotations.
        """
        return pulumi.get(self, "pod_annotations")

    @pod_annotations.setter
    def pod_annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "pod_annotations", value)

    @property
    @pulumi.getter(name="podDisruptionBudget")
    def pod_disruption_budget(self) -> Optional[pulumi.Input['pulumi_kubernetes.policy.v1.PodDisruptionBudgetSpecArgs']]:
        """
        Optional PodDisruptionBudget.
        """
        return pulumi.get(self, "pod_disruption_budget")

    @pod_disruption_budget.setter
    def pod_disruption_budget(self, value: Optional[pulumi.Input['pulumi_kubernetes.policy.v1.PodDisruptionBudgetSpecArgs']]):
        pulumi.set(self, "pod_disruption_budget", value)

    @property
    @pulumi.getter(name="preStopSleep")
    def pre_stop_sleep(self) -> Optional[pulumi.Input[int]]:
        """
        Under heavy load it takes more that standard time to remove Pod endpoint from a cluster. This will delay termination of our pod by `preStopSleep`. To make sure kube-proxy has enough time to catch up.
        """
        return pulumi.get(self, "pre_stop_sleep")

    @pre_stop_sleep.setter
    def pre_stop_sleep(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "pre_stop_sleep", value)

    @property
    @pulumi.getter(name="priorityClassName")
    def priority_class_name(self) -> Optional[pulumi.Input[str]]:
        """
        Optional priority class to be used for the coredns pods. Used for autoscaler if autoscaler.priorityClassName not set.
        """
        return pulumi.get(self, "priority_class_name")

    @priority_class_name.setter
    def priority_class_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "priority_class_name", value)

    @property
    @pulumi.getter
    def prometheus(self) -> Optional[pulumi.Input['CoreDNSPrometheusArgs']]:
        """
        Configure Prometheus installation.
        """
        return pulumi.get(self, "prometheus")

    @prometheus.setter
    def prometheus(self, value: Optional[pulumi.Input['CoreDNSPrometheusArgs']]):
        pulumi.set(self, "prometheus", value)

    @property
    @pulumi.getter
    def rbac(self) -> Optional[pulumi.Input['CoreDNSRBACArgs']]:
        """
        Configure CoreDNS RBAC resources.
        """
        return pulumi.get(self, "rbac")

    @rbac.setter
    def rbac(self, value: Optional[pulumi.Input['CoreDNSRBACArgs']]):
        pulumi.set(self, "rbac", value)

    @property
    @pulumi.getter(name="readinessProbe")
    def readiness_probe(self) -> Optional[pulumi.Input['pulumi_kubernetes.core.v1.ProbeArgs']]:
        """
        Configure the readiness probe. To use the readinessProbe, the health plugin needs to be enabled in CoreDNS' server config.
        """
        return pulumi.get(self, "readiness_probe")

    @readiness_probe.setter
    def readiness_probe(self, value: Optional[pulumi.Input['pulumi_kubernetes.core.v1.ProbeArgs']]):
        pulumi.set(self, "readiness_probe", value)

    @property
    @pulumi.getter(name="replicaCount")
    def replica_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of replicas.
        """
        return pulumi.get(self, "replica_count")

    @replica_count.setter
    def replica_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "replica_count", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input['pulumi_kubernetes.core.v1.ResourceRequirementsArgs']]:
        """
        Container resource limits.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input['pulumi_kubernetes.core.v1.ResourceRequirementsArgs']]):
        pulumi.set(self, "resources", value)

    @property
    @pulumi.getter(name="rollingUpdate")
    def rolling_update(self) -> Optional[pulumi.Input['pulumi_kubernetes.apps.v1.RollingUpdateDeploymentArgs']]:
        return pulumi.get(self, "rolling_update")

    @rolling_update.setter
    def rolling_update(self, value: Optional[pulumi.Input['pulumi_kubernetes.apps.v1.RollingUpdateDeploymentArgs']]):
        pulumi.set(self, "rolling_update", value)

    @property
    @pulumi.getter
    def servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CoreDNSServerArgs']]]]:
        """
        Configuration for CoreDNS and plugins. Default zone is what Kubernetes recommends: https://kubernetes.io/docs/tasks/administer-cluster/dns-custom-nameservers/#coredns-configmap-options
        """
        return pulumi.get(self, "servers")

    @servers.setter
    def servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CoreDNSServerArgs']]]]):
        pulumi.set(self, "servers", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input['CoreDNSServiceArgs']]:
        """
        Configure CoreDNS Service parameters.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input['CoreDNSServiceArgs']]):
        pulumi.set(self, "service", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input['CoreDNSServiceAccountArgs']]:
        """
        Configure CoreDNS Service Account.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input['CoreDNSServiceAccountArgs']]):
        pulumi.set(self, "service_account", value)

    @property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> Optional[pulumi.Input[str]]:
        """
        Kubernetes Service type.
        """
        return pulumi.get(self, "service_type")

    @service_type.setter
    def service_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_type", value)

    @property
    @pulumi.getter(name="terminationGracePeriodSeconds")
    def termination_grace_period_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Optional duration in seconds the pod needs to terminate gracefully.
        """
        return pulumi.get(self, "termination_grace_period_seconds")

    @termination_grace_period_seconds.setter
    def termination_grace_period_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "termination_grace_period_seconds", value)

    @property
    @pulumi.getter
    def tolerations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_kubernetes.core.v1.TolerationArgs']]]]:
        """
        Tolerations for pod assignment.
        """
        return pulumi.get(self, "tolerations")

    @tolerations.setter
    def tolerations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_kubernetes.core.v1.TolerationArgs']]]]):
        pulumi.set(self, "tolerations", value)

    @property
    @pulumi.getter(name="zoneFiles")
    def zone_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CoreDNSZoneFileArgs']]]]:
        """
        Configure custom Zone files.
        """
        return pulumi.get(self, "zone_files")

    @zone_files.setter
    def zone_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CoreDNSZoneFileArgs']]]]):
        pulumi.set(self, "zone_files", value)


class CoreDNS(pulumi.ComponentResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 affinity: Optional[pulumi.Input[pulumi.InputType['pulumi_kubernetes.core.v1.AffinityArgs']]] = None,
                 autoscaler: Optional[pulumi.Input[Union['CoreDNSAutoscalerArgs', 'CoreDNSAutoscalerArgsDict']]] = None,
                 autoscaling: Optional[pulumi.Input[pulumi.InputType['pulumi_kubernetes.autoscaling.v2beta2.HorizontalPodAutoscalerSpecArgs']]] = None,
                 deployment: Optional[pulumi.Input[Union['CoreDNSDeploymentArgs', 'CoreDNSDeploymentArgsDict']]] = None,
                 extra_secrets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['pulumi_kubernetes.core.v1.VolumeMountArgs']]]]] = None,
                 extra_volume_mounts: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['pulumi_kubernetes.core.v1.VolumeMountArgs']]]]] = None,
                 extra_volumes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['pulumi_kubernetes.core.v1.VolumeArgs']]]]] = None,
                 helm_options: Optional[pulumi.Input[Union['ReleaseArgs', 'ReleaseArgsDict']]] = None,
                 hpa: Optional[pulumi.Input[Union['CoreDNSHPAArgs', 'CoreDNSHPAArgsDict']]] = None,
                 image: Optional[pulumi.Input[Union['CoreDNSImageArgs', 'CoreDNSImageArgsDict']]] = None,
                 is_cluster_service: Optional[pulumi.Input[bool]] = None,
                 liveness_probe: Optional[pulumi.Input[pulumi.InputType['pulumi_kubernetes.core.v1.ProbeArgs']]] = None,
                 node_selector: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 pod_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 pod_disruption_budget: Optional[pulumi.Input[pulumi.InputType['pulumi_kubernetes.policy.v1.PodDisruptionBudgetSpecArgs']]] = None,
                 pre_stop_sleep: Optional[pulumi.Input[int]] = None,
                 priority_class_name: Optional[pulumi.Input[str]] = None,
                 prometheus: Optional[pulumi.Input[Union['CoreDNSPrometheusArgs', 'CoreDNSPrometheusArgsDict']]] = None,
                 rbac: Optional[pulumi.Input[Union['CoreDNSRBACArgs', 'CoreDNSRBACArgsDict']]] = None,
                 readiness_probe: Optional[pulumi.Input[pulumi.InputType['pulumi_kubernetes.core.v1.ProbeArgs']]] = None,
                 replica_count: Optional[pulumi.Input[int]] = None,
                 resources: Optional[pulumi.Input[pulumi.InputType['pulumi_kubernetes.core.v1.ResourceRequirementsArgs']]] = None,
                 rolling_update: Optional[pulumi.Input[pulumi.InputType['pulumi_kubernetes.apps.v1.RollingUpdateDeploymentArgs']]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CoreDNSServerArgs', 'CoreDNSServerArgsDict']]]]] = None,
                 service: Optional[pulumi.Input[Union['CoreDNSServiceArgs', 'CoreDNSServiceArgsDict']]] = None,
                 service_account: Optional[pulumi.Input[Union['CoreDNSServiceAccountArgs', 'CoreDNSServiceAccountArgsDict']]] = None,
                 service_type: Optional[pulumi.Input[str]] = None,
                 termination_grace_period_seconds: Optional[pulumi.Input[int]] = None,
                 tolerations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['pulumi_kubernetes.core.v1.TolerationArgs']]]]] = None,
                 zone_files: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CoreDNSZoneFileArgs', 'CoreDNSZoneFileArgsDict']]]]] = None,
                 __props__=None):
        """
        Enable fast and flexible in-cluster DNS.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['pulumi_kubernetes.core.v1.AffinityArgs']] affinity: Affinity settings for pod assignment.
        :param pulumi.Input[Union['CoreDNSAutoscalerArgs', 'CoreDNSAutoscalerArgsDict']] autoscaler: Configue a cluster-proportional-autoscaler for coredns. See https://github.com/kubernetes-incubator/cluster-proportional-autoscaler.
        :param pulumi.Input[pulumi.InputType['pulumi_kubernetes.autoscaling.v2beta2.HorizontalPodAutoscalerSpecArgs']] autoscaling: Create HorizontalPodAutoscaler object.
        :param pulumi.Input[Union['CoreDNSDeploymentArgs', 'CoreDNSDeploymentArgsDict']] deployment: Configure the CoreDNS Deployment.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['pulumi_kubernetes.core.v1.VolumeMountArgs']]]] extra_secrets: Optional array of secrets to mount inside coredns container. Possible usecase: need for secure connection with etcd backend. Optional array of mount points for extraVolumes.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['pulumi_kubernetes.core.v1.VolumeMountArgs']]]] extra_volume_mounts: Optional array of mount points for extraVolumes.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['pulumi_kubernetes.core.v1.VolumeArgs']]]] extra_volumes: Optional array of extra volumes to create.
        :param pulumi.Input[Union['ReleaseArgs', 'ReleaseArgsDict']] helm_options: HelmOptions is an escape hatch that lets the end user control any aspect of the Helm deployment. This exposes the entirety of the underlying Helm Release component args.
        :param pulumi.Input[Union['CoreDNSHPAArgs', 'CoreDNSHPAArgsDict']] hpa: Alternative configuration for HPA deployment if wanted.
        :param pulumi.Input[Union['CoreDNSImageArgs', 'CoreDNSImageArgsDict']] image: The image to pull.
        :param pulumi.Input[bool] is_cluster_service: Specifies whether chart should be deployed as cluster-service or normal k8s app.
        :param pulumi.Input[pulumi.InputType['pulumi_kubernetes.core.v1.ProbeArgs']] liveness_probe: Configure the liveness probe. To use the livenessProbe, the health plugin needs to be enabled in CoreDNS' server config.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] node_selector: Node labels for pod assignment.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] pod_annotations: Optional Pod only Annotations.
        :param pulumi.Input[pulumi.InputType['pulumi_kubernetes.policy.v1.PodDisruptionBudgetSpecArgs']] pod_disruption_budget: Optional PodDisruptionBudget.
        :param pulumi.Input[int] pre_stop_sleep: Under heavy load it takes more that standard time to remove Pod endpoint from a cluster. This will delay termination of our pod by `preStopSleep`. To make sure kube-proxy has enough time to catch up.
        :param pulumi.Input[str] priority_class_name: Optional priority class to be used for the coredns pods. Used for autoscaler if autoscaler.priorityClassName not set.
        :param pulumi.Input[Union['CoreDNSPrometheusArgs', 'CoreDNSPrometheusArgsDict']] prometheus: Configure Prometheus installation.
        :param pulumi.Input[Union['CoreDNSRBACArgs', 'CoreDNSRBACArgsDict']] rbac: Configure CoreDNS RBAC resources.
        :param pulumi.Input[pulumi.InputType['pulumi_kubernetes.core.v1.ProbeArgs']] readiness_probe: Configure the readiness probe. To use the readinessProbe, the health plugin needs to be enabled in CoreDNS' server config.
        :param pulumi.Input[int] replica_count: Number of replicas.
        :param pulumi.Input[pulumi.InputType['pulumi_kubernetes.core.v1.ResourceRequirementsArgs']] resources: Container resource limits.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CoreDNSServerArgs', 'CoreDNSServerArgsDict']]]] servers: Configuration for CoreDNS and plugins. Default zone is what Kubernetes recommends: https://kubernetes.io/docs/tasks/administer-cluster/dns-custom-nameservers/#coredns-configmap-options
        :param pulumi.Input[Union['CoreDNSServiceArgs', 'CoreDNSServiceArgsDict']] service: Configure CoreDNS Service parameters.
        :param pulumi.Input[Union['CoreDNSServiceAccountArgs', 'CoreDNSServiceAccountArgsDict']] service_account: Configure CoreDNS Service Account.
        :param pulumi.Input[str] service_type: Kubernetes Service type.
        :param pulumi.Input[int] termination_grace_period_seconds: Optional duration in seconds the pod needs to terminate gracefully.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['pulumi_kubernetes.core.v1.TolerationArgs']]]] tolerations: Tolerations for pod assignment.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CoreDNSZoneFileArgs', 'CoreDNSZoneFileArgsDict']]]] zone_files: Configure custom Zone files.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[CoreDNSArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Enable fast and flexible in-cluster DNS.

        :param str resource_name: The name of the resource.
        :param CoreDNSArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CoreDNSArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 affinity: Optional[pulumi.Input[pulumi.InputType['pulumi_kubernetes.core.v1.AffinityArgs']]] = None,
                 autoscaler: Optional[pulumi.Input[Union['CoreDNSAutoscalerArgs', 'CoreDNSAutoscalerArgsDict']]] = None,
                 autoscaling: Optional[pulumi.Input[pulumi.InputType['pulumi_kubernetes.autoscaling.v2beta2.HorizontalPodAutoscalerSpecArgs']]] = None,
                 deployment: Optional[pulumi.Input[Union['CoreDNSDeploymentArgs', 'CoreDNSDeploymentArgsDict']]] = None,
                 extra_secrets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['pulumi_kubernetes.core.v1.VolumeMountArgs']]]]] = None,
                 extra_volume_mounts: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['pulumi_kubernetes.core.v1.VolumeMountArgs']]]]] = None,
                 extra_volumes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['pulumi_kubernetes.core.v1.VolumeArgs']]]]] = None,
                 helm_options: Optional[pulumi.Input[Union['ReleaseArgs', 'ReleaseArgsDict']]] = None,
                 hpa: Optional[pulumi.Input[Union['CoreDNSHPAArgs', 'CoreDNSHPAArgsDict']]] = None,
                 image: Optional[pulumi.Input[Union['CoreDNSImageArgs', 'CoreDNSImageArgsDict']]] = None,
                 is_cluster_service: Optional[pulumi.Input[bool]] = None,
                 liveness_probe: Optional[pulumi.Input[pulumi.InputType['pulumi_kubernetes.core.v1.ProbeArgs']]] = None,
                 node_selector: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 pod_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 pod_disruption_budget: Optional[pulumi.Input[pulumi.InputType['pulumi_kubernetes.policy.v1.PodDisruptionBudgetSpecArgs']]] = None,
                 pre_stop_sleep: Optional[pulumi.Input[int]] = None,
                 priority_class_name: Optional[pulumi.Input[str]] = None,
                 prometheus: Optional[pulumi.Input[Union['CoreDNSPrometheusArgs', 'CoreDNSPrometheusArgsDict']]] = None,
                 rbac: Optional[pulumi.Input[Union['CoreDNSRBACArgs', 'CoreDNSRBACArgsDict']]] = None,
                 readiness_probe: Optional[pulumi.Input[pulumi.InputType['pulumi_kubernetes.core.v1.ProbeArgs']]] = None,
                 replica_count: Optional[pulumi.Input[int]] = None,
                 resources: Optional[pulumi.Input[pulumi.InputType['pulumi_kubernetes.core.v1.ResourceRequirementsArgs']]] = None,
                 rolling_update: Optional[pulumi.Input[pulumi.InputType['pulumi_kubernetes.apps.v1.RollingUpdateDeploymentArgs']]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CoreDNSServerArgs', 'CoreDNSServerArgsDict']]]]] = None,
                 service: Optional[pulumi.Input[Union['CoreDNSServiceArgs', 'CoreDNSServiceArgsDict']]] = None,
                 service_account: Optional[pulumi.Input[Union['CoreDNSServiceAccountArgs', 'CoreDNSServiceAccountArgsDict']]] = None,
                 service_type: Optional[pulumi.Input[str]] = None,
                 termination_grace_period_seconds: Optional[pulumi.Input[int]] = None,
                 tolerations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['pulumi_kubernetes.core.v1.TolerationArgs']]]]] = None,
                 zone_files: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CoreDNSZoneFileArgs', 'CoreDNSZoneFileArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is not None:
            raise ValueError('ComponentResource classes do not support opts.id')
        else:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CoreDNSArgs.__new__(CoreDNSArgs)

            __props__.__dict__["affinity"] = affinity
            __props__.__dict__["autoscaler"] = autoscaler
            __props__.__dict__["autoscaling"] = autoscaling
            __props__.__dict__["deployment"] = deployment
            __props__.__dict__["extra_secrets"] = extra_secrets
            __props__.__dict__["extra_volume_mounts"] = extra_volume_mounts
            __props__.__dict__["extra_volumes"] = extra_volumes
            __props__.__dict__["helm_options"] = helm_options
            __props__.__dict__["hpa"] = hpa
            __props__.__dict__["image"] = image
            __props__.__dict__["is_cluster_service"] = is_cluster_service
            __props__.__dict__["liveness_probe"] = liveness_probe
            __props__.__dict__["node_selector"] = node_selector
            __props__.__dict__["pod_annotations"] = pod_annotations
            __props__.__dict__["pod_disruption_budget"] = pod_disruption_budget
            __props__.__dict__["pre_stop_sleep"] = pre_stop_sleep
            __props__.__dict__["priority_class_name"] = priority_class_name
            __props__.__dict__["prometheus"] = prometheus
            __props__.__dict__["rbac"] = rbac
            __props__.__dict__["readiness_probe"] = readiness_probe
            __props__.__dict__["replica_count"] = replica_count
            __props__.__dict__["resources"] = resources
            __props__.__dict__["rolling_update"] = rolling_update
            __props__.__dict__["servers"] = servers
            __props__.__dict__["service"] = service
            __props__.__dict__["service_account"] = service_account
            __props__.__dict__["service_type"] = service_type
            __props__.__dict__["termination_grace_period_seconds"] = termination_grace_period_seconds
            __props__.__dict__["tolerations"] = tolerations
            __props__.__dict__["zone_files"] = zone_files
            __props__.__dict__["status"] = None
        super(CoreDNS, __self__).__init__(
            'kubernetes-coredns:index:CoreDNS',
            resource_name,
            __props__,
            opts,
            remote=True)

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output['outputs.ReleaseStatus']:
        """
        Detailed information about the status of the underlying Helm deployment.
        """
        return pulumi.get(self, "status")

