"""
    VRChat API Documentation


    The version of the OpenAPI document: 1.4.1
    Contact: me@ruby.js.org
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from vrchatapi.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)
from ..model_utils import OpenApiModel
from vrchatapi.exceptions import ApiAttributeError


def lazy_import():
    from vrchatapi.model.api_event_config import APIEventConfig
    from vrchatapi.model.avatar_id import AvatarID
    from vrchatapi.model.deployment_group import DeploymentGroup
    from vrchatapi.model.download_url_list import DownloadURLList
    from vrchatapi.model.dynamic_world_row import DynamicWorldRow
    from vrchatapi.model.public_announcement import PublicAnnouncement
    from vrchatapi.model.world_id import WorldID
    globals()['APIEventConfig'] = APIEventConfig
    globals()['AvatarID'] = AvatarID
    globals()['DeploymentGroup'] = DeploymentGroup
    globals()['DownloadURLList'] = DownloadURLList
    globals()['DynamicWorldRow'] = DynamicWorldRow
    globals()['PublicAnnouncement'] = PublicAnnouncement
    globals()['WorldID'] = WorldID


class APIConfig(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
        ('address',): {
            'min_length': 1,
        },
        ('announcements',): {
            'min_items': 1,
        },
        ('api_key',): {
            'min_length': 1,
        },
        ('app_name',): {
            'min_length': 1,
        },
        ('build_version_tag',): {
            'min_length': 1,
        },
        ('client_api_key',): {
            'min_length': 1,
        },
        ('contact_email',): {
            'min_length': 1,
        },
        ('copyright_email',): {
            'min_length': 1,
        },
        ('current_tos_version',): {
            'inclusive_minimum': 0,
        },
        ('dev_app_version_standalone',): {
            'min_length': 1,
        },
        ('dev_download_link_windows',): {
            'min_length': 1,
        },
        ('dev_sdk_url',): {
            'min_length': 1,
        },
        ('dev_sdk_version',): {
            'min_length': 1,
        },
        ('dev_server_version_standalone',): {
            'min_length': 1,
        },
        ('download_link_windows',): {
            'min_length': 1,
        },
        ('dynamic_world_rows',): {
            'min_items': 1,
        },
        ('gear_demo_room_id',): {
            'min_length': 1,
        },
        ('homepage_redirect_target',): {
            'min_length': 1,
        },
        ('jobs_email',): {
            'min_length': 1,
        },
        ('message_of_the_day',): {
            'min_length': 1,
        },
        ('moderation_email',): {
            'min_length': 1,
        },
        ('not_allowed_to_select_avatar_in_private_world_message',): {
            'min_length': 1,
        },
        ('plugin',): {
            'min_length': 1,
        },
        ('release_app_version_standalone',): {
            'min_length': 1,
        },
        ('release_sdk_url',): {
            'min_length': 1,
        },
        ('release_sdk_version',): {
            'min_length': 1,
        },
        ('release_server_version_standalone',): {
            'min_length': 1,
        },
        ('sdk_developer_faq_url',): {
            'min_length': 1,
        },
        ('sdk_discord_url',): {
            'min_length': 1,
        },
        ('sdk_not_allowed_to_publish_message',): {
            'min_length': 1,
        },
        ('sdk_unity_version',): {
            'min_length': 1,
        },
        ('server_name',): {
            'min_length': 1,
        },
        ('support_email',): {
            'min_length': 1,
        },
        ('vive_windows_url',): {
            'min_length': 1,
        },
        ('youtubedl_hash',): {
            'min_length': 1,
        },
        ('youtubedl_version',): {
            'min_length': 1,
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'voice_enable_degradation': (bool,),  # noqa: E501
            'voice_enable_receiver_limiting': (bool,),  # noqa: E501
            'address': (str,),  # noqa: E501
            'announcements': ([PublicAnnouncement],),  # noqa: E501
            'api_key': (str,),  # noqa: E501
            'app_name': (str,),  # noqa: E501
            'build_version_tag': (str,),  # noqa: E501
            'client_api_key': (str,),  # noqa: E501
            'client_bps_ceiling': (int,),  # noqa: E501
            'client_disconnect_timeout': (int,),  # noqa: E501
            'client_reserved_player_bps': (int,),  # noqa: E501
            'client_sent_count_allowance': (int,),  # noqa: E501
            'contact_email': (str,),  # noqa: E501
            'copyright_email': (str,),  # noqa: E501
            'current_tos_version': (int,),  # noqa: E501
            'default_avatar': (AvatarID,),  # noqa: E501
            'deployment_group': (DeploymentGroup,),  # noqa: E501
            'dev_app_version_standalone': (str,),  # noqa: E501
            'dev_download_link_windows': (str,),  # noqa: E501
            'dev_sdk_url': (str,),  # noqa: E501
            'dev_sdk_version': (str,),  # noqa: E501
            'dev_server_version_standalone': (str,),  # noqa: E501
            'dis_countdown': (datetime,),  # noqa: E501
            'disable_avatar_copying': (bool,),  # noqa: E501
            'disable_avatar_gating': (bool,),  # noqa: E501
            'disable_community_labs': (bool,),  # noqa: E501
            'disable_community_labs_promotion': (bool,),  # noqa: E501
            'disable_email': (bool,),  # noqa: E501
            'disable_event_stream': (bool,),  # noqa: E501
            'disable_feedback_gating': (bool,),  # noqa: E501
            'disable_frontend_builds': (bool,),  # noqa: E501
            'disable_hello': (bool,),  # noqa: E501
            'disable_oculus_subs': (bool,),  # noqa: E501
            'disable_registration': (bool,),  # noqa: E501
            'disable_steam_networking': (bool,),  # noqa: E501
            'disable_two_factor_auth': (bool,),  # noqa: E501
            'disable_udon': (bool,),  # noqa: E501
            'disable_upgrade_account': (bool,),  # noqa: E501
            'download_link_windows': (str,),  # noqa: E501
            'download_urls': (DownloadURLList,),  # noqa: E501
            'dynamic_world_rows': ([DynamicWorldRow],),  # noqa: E501
            'events': (APIEventConfig,),  # noqa: E501
            'gear_demo_room_id': (str,),  # noqa: E501
            'home_world_id': (WorldID,),  # noqa: E501
            'homepage_redirect_target': (str,),  # noqa: E501
            'hub_world_id': (WorldID,),  # noqa: E501
            'jobs_email': (str,),  # noqa: E501
            'message_of_the_day': (str,),  # noqa: E501
            'moderation_email': (str,),  # noqa: E501
            'moderation_query_period': (int,),  # noqa: E501
            'not_allowed_to_select_avatar_in_private_world_message': (str,),  # noqa: E501
            'plugin': (str,),  # noqa: E501
            'release_app_version_standalone': (str,),  # noqa: E501
            'release_sdk_url': (str,),  # noqa: E501
            'release_sdk_version': (str,),  # noqa: E501
            'release_server_version_standalone': (str,),  # noqa: E501
            'sdk_developer_faq_url': (str,),  # noqa: E501
            'sdk_discord_url': (str,),  # noqa: E501
            'sdk_not_allowed_to_publish_message': (str,),  # noqa: E501
            'sdk_unity_version': (str,),  # noqa: E501
            'server_name': (str,),  # noqa: E501
            'support_email': (str,),  # noqa: E501
            'time_out_world_id': (WorldID,),  # noqa: E501
            'tutorial_world_id': (WorldID,),  # noqa: E501
            'update_rate_ms_maximum': (int,),  # noqa: E501
            'update_rate_ms_minimum': (int,),  # noqa: E501
            'update_rate_ms_normal': (int,),  # noqa: E501
            'update_rate_ms_udon_manual': (int,),  # noqa: E501
            'upload_analysis_percent': (int,),  # noqa: E501
            'url_list': ([str],),  # noqa: E501
            'use_reliable_udp_for_voice': (bool,),  # noqa: E501
            'user_update_period': (int,),  # noqa: E501
            'user_verification_delay': (int,),  # noqa: E501
            'user_verification_retry': (int,),  # noqa: E501
            'user_verification_timeout': (int,),  # noqa: E501
            'vive_windows_url': (str,),  # noqa: E501
            'white_listed_asset_urls': ([str],),  # noqa: E501
            'world_update_period': (int,),  # noqa: E501
            'youtubedl_hash': (str,),  # noqa: E501
            'youtubedl_version': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'voice_enable_degradation': 'VoiceEnableDegradation',  # noqa: E501
        'voice_enable_receiver_limiting': 'VoiceEnableReceiverLimiting',  # noqa: E501
        'address': 'address',  # noqa: E501
        'announcements': 'announcements',  # noqa: E501
        'api_key': 'apiKey',  # noqa: E501
        'app_name': 'appName',  # noqa: E501
        'build_version_tag': 'buildVersionTag',  # noqa: E501
        'client_api_key': 'clientApiKey',  # noqa: E501
        'client_bps_ceiling': 'clientBPSCeiling',  # noqa: E501
        'client_disconnect_timeout': 'clientDisconnectTimeout',  # noqa: E501
        'client_reserved_player_bps': 'clientReservedPlayerBPS',  # noqa: E501
        'client_sent_count_allowance': 'clientSentCountAllowance',  # noqa: E501
        'contact_email': 'contactEmail',  # noqa: E501
        'copyright_email': 'copyrightEmail',  # noqa: E501
        'current_tos_version': 'currentTOSVersion',  # noqa: E501
        'default_avatar': 'defaultAvatar',  # noqa: E501
        'deployment_group': 'deploymentGroup',  # noqa: E501
        'dev_app_version_standalone': 'devAppVersionStandalone',  # noqa: E501
        'dev_download_link_windows': 'devDownloadLinkWindows',  # noqa: E501
        'dev_sdk_url': 'devSdkUrl',  # noqa: E501
        'dev_sdk_version': 'devSdkVersion',  # noqa: E501
        'dev_server_version_standalone': 'devServerVersionStandalone',  # noqa: E501
        'dis_countdown': 'dis-countdown',  # noqa: E501
        'disable_avatar_copying': 'disableAvatarCopying',  # noqa: E501
        'disable_avatar_gating': 'disableAvatarGating',  # noqa: E501
        'disable_community_labs': 'disableCommunityLabs',  # noqa: E501
        'disable_community_labs_promotion': 'disableCommunityLabsPromotion',  # noqa: E501
        'disable_email': 'disableEmail',  # noqa: E501
        'disable_event_stream': 'disableEventStream',  # noqa: E501
        'disable_feedback_gating': 'disableFeedbackGating',  # noqa: E501
        'disable_frontend_builds': 'disableFrontendBuilds',  # noqa: E501
        'disable_hello': 'disableHello',  # noqa: E501
        'disable_oculus_subs': 'disableOculusSubs',  # noqa: E501
        'disable_registration': 'disableRegistration',  # noqa: E501
        'disable_steam_networking': 'disableSteamNetworking',  # noqa: E501
        'disable_two_factor_auth': 'disableTwoFactorAuth',  # noqa: E501
        'disable_udon': 'disableUdon',  # noqa: E501
        'disable_upgrade_account': 'disableUpgradeAccount',  # noqa: E501
        'download_link_windows': 'downloadLinkWindows',  # noqa: E501
        'download_urls': 'downloadUrls',  # noqa: E501
        'dynamic_world_rows': 'dynamicWorldRows',  # noqa: E501
        'events': 'events',  # noqa: E501
        'gear_demo_room_id': 'gearDemoRoomId',  # noqa: E501
        'home_world_id': 'homeWorldId',  # noqa: E501
        'homepage_redirect_target': 'homepageRedirectTarget',  # noqa: E501
        'hub_world_id': 'hubWorldId',  # noqa: E501
        'jobs_email': 'jobsEmail',  # noqa: E501
        'message_of_the_day': 'messageOfTheDay',  # noqa: E501
        'moderation_email': 'moderationEmail',  # noqa: E501
        'moderation_query_period': 'moderationQueryPeriod',  # noqa: E501
        'not_allowed_to_select_avatar_in_private_world_message': 'notAllowedToSelectAvatarInPrivateWorldMessage',  # noqa: E501
        'plugin': 'plugin',  # noqa: E501
        'release_app_version_standalone': 'releaseAppVersionStandalone',  # noqa: E501
        'release_sdk_url': 'releaseSdkUrl',  # noqa: E501
        'release_sdk_version': 'releaseSdkVersion',  # noqa: E501
        'release_server_version_standalone': 'releaseServerVersionStandalone',  # noqa: E501
        'sdk_developer_faq_url': 'sdkDeveloperFaqUrl',  # noqa: E501
        'sdk_discord_url': 'sdkDiscordUrl',  # noqa: E501
        'sdk_not_allowed_to_publish_message': 'sdkNotAllowedToPublishMessage',  # noqa: E501
        'sdk_unity_version': 'sdkUnityVersion',  # noqa: E501
        'server_name': 'serverName',  # noqa: E501
        'support_email': 'supportEmail',  # noqa: E501
        'time_out_world_id': 'timeOutWorldId',  # noqa: E501
        'tutorial_world_id': 'tutorialWorldId',  # noqa: E501
        'update_rate_ms_maximum': 'updateRateMsMaximum',  # noqa: E501
        'update_rate_ms_minimum': 'updateRateMsMinimum',  # noqa: E501
        'update_rate_ms_normal': 'updateRateMsNormal',  # noqa: E501
        'update_rate_ms_udon_manual': 'updateRateMsUdonManual',  # noqa: E501
        'upload_analysis_percent': 'uploadAnalysisPercent',  # noqa: E501
        'url_list': 'urlList',  # noqa: E501
        'use_reliable_udp_for_voice': 'useReliableUdpForVoice',  # noqa: E501
        'user_update_period': 'userUpdatePeriod',  # noqa: E501
        'user_verification_delay': 'userVerificationDelay',  # noqa: E501
        'user_verification_retry': 'userVerificationRetry',  # noqa: E501
        'user_verification_timeout': 'userVerificationTimeout',  # noqa: E501
        'vive_windows_url': 'viveWindowsUrl',  # noqa: E501
        'white_listed_asset_urls': 'whiteListedAssetUrls',  # noqa: E501
        'world_update_period': 'worldUpdatePeriod',  # noqa: E501
        'youtubedl_hash': 'youtubedl-hash',  # noqa: E501
        'youtubedl_version': 'youtubedl-version',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, address, announcements, api_key, build_version_tag, client_api_key, contact_email, copyright_email, current_tos_version, default_avatar, deployment_group, dev_app_version_standalone, dev_download_link_windows, dev_sdk_url, dev_sdk_version, dev_server_version_standalone, dis_countdown, download_link_windows, download_urls, dynamic_world_rows, events, gear_demo_room_id, home_world_id, hub_world_id, jobs_email, message_of_the_day, moderation_email, moderation_query_period, not_allowed_to_select_avatar_in_private_world_message, plugin, release_app_version_standalone, release_sdk_url, release_sdk_version, release_server_version_standalone, sdk_developer_faq_url, sdk_discord_url, sdk_not_allowed_to_publish_message, sdk_unity_version, server_name, support_email, time_out_world_id, tutorial_world_id, update_rate_ms_maximum, update_rate_ms_minimum, update_rate_ms_normal, update_rate_ms_udon_manual, upload_analysis_percent, url_list, user_update_period, user_verification_delay, user_verification_retry, user_verification_timeout, vive_windows_url, white_listed_asset_urls, world_update_period, youtubedl_hash, youtubedl_version, *args, **kwargs):  # noqa: E501
        """APIConfig - a model defined in OpenAPI

        Args:
            address (str): VRChat's office address
            announcements ([PublicAnnouncement]): Public Announcements
            api_key (str): apiKey to be used for all other requests
            build_version_tag (str): Build tag of the API server
            client_api_key (str): apiKey to be used for all other requests
            contact_email (str): VRChat's contact email
            copyright_email (str): VRChat's copyright-issues-related email
            current_tos_version (int): Current version number of the Terms of Service
            default_avatar (AvatarID):
            deployment_group (DeploymentGroup):
            dev_app_version_standalone (str): Version number for game development build
            dev_download_link_windows (str): Developer Download link
            dev_sdk_url (str): Link to download the development SDK, use downloadUrls instead
            dev_sdk_version (str): Version of the development SDK
            dev_server_version_standalone (str): Version number for server development build
            dis_countdown (datetime): Unknown, \"dis\" maybe for disconnect?
            download_link_windows (str): Download link for game on the Oculus Rift website.
            download_urls (DownloadURLList):
            dynamic_world_rows ([DynamicWorldRow]): Array of DynamicWorldRow objects, used by the game to display the list of world rows
            events (APIEventConfig):
            gear_demo_room_id (str): Unknown
            home_world_id (WorldID):
            hub_world_id (WorldID):
            jobs_email (str): VRChat's job application email
            message_of_the_day (str): MOTD
            moderation_email (str): VRChat's moderation related email
            moderation_query_period (int): Unknown
            not_allowed_to_select_avatar_in_private_world_message (str): Used in-game to notify a user they aren't allowed to select avatars in private worlds
            plugin (str): Extra [plugin](https://doc.photonengine.com/en-us/server/current/plugins/manual) to run in each instance
            release_app_version_standalone (str): Version number for game release build
            release_sdk_url (str): Link to download the release SDK
            release_sdk_version (str): Version of the release SDK
            release_server_version_standalone (str): Version number for server release build
            sdk_developer_faq_url (str): Link to the developer FAQ
            sdk_discord_url (str): Link to the official VRChat Discord
            sdk_not_allowed_to_publish_message (str): Used in the SDK to notify a user they aren't allowed to upload avatars/worlds yet
            sdk_unity_version (str): Unity version supported by the SDK
            server_name (str): Server name of the API server currently responding
            support_email (str): VRChat's support email
            time_out_world_id (WorldID):
            tutorial_world_id (WorldID):
            update_rate_ms_maximum (int): Unknown
            update_rate_ms_minimum (int): Unknown
            update_rate_ms_normal (int): Unknown
            update_rate_ms_udon_manual (int): Unknown
            upload_analysis_percent (int): Unknown
            url_list ([str]): List of allowed URLs that bypass the \"Allow untrusted URL's\" setting in-game
            user_update_period (int): Unknown
            user_verification_delay (int): Unknown
            user_verification_retry (int): Unknown
            user_verification_timeout (int): Unknown
            vive_windows_url (str): Download link for game on the Steam website.
            white_listed_asset_urls ([str]): List of allowed URLs that are allowed to host avatar assets
            world_update_period (int): Unknown
            youtubedl_hash (str): Currently used youtube-dl.exe hash in SHA-256-delimited format
            youtubedl_version (str): Currently used youtube-dl.exe version

        Keyword Args:
            voice_enable_degradation (bool): Unknown, probably voice optimization testing. defaults to False  # noqa: E501
            voice_enable_receiver_limiting (bool): Unknown, probably voice optimization testing. defaults to True  # noqa: E501
            app_name (str): Game name. defaults to "VrChat"  # noqa: E501
            client_bps_ceiling (int): Unknown. defaults to 18432  # noqa: E501
            client_disconnect_timeout (int): Unknown. defaults to 30000  # noqa: E501
            client_reserved_player_bps (int): Unknown. defaults to 7168  # noqa: E501
            client_sent_count_allowance (int): Unknown. defaults to 15  # noqa: E501
            disable_avatar_copying (bool): Toggles if copying avatars should be disabled. defaults to False  # noqa: E501
            disable_avatar_gating (bool): Toggles if avatar gating should be disabled. Avatar gating restricts uploading of avatars to people with the `system_avatar_access` Tag or `admin_avatar_access` Tag. defaults to False  # noqa: E501
            disable_community_labs (bool): Toggles if the Community Labs should be disabled. defaults to False  # noqa: E501
            disable_community_labs_promotion (bool): Toggles if promotion out of Community Labs should be disabled. defaults to False  # noqa: E501
            disable_email (bool): Unknown. defaults to False  # noqa: E501
            disable_event_stream (bool): Toggles if Analytics should be disabled.. defaults to False  # noqa: E501
            disable_feedback_gating (bool): Toggles if feedback gating should be disabled. Feedback gating restricts submission of feedback (reporting a World or User) to people with the `system_feedback_access` Tag.. defaults to False  # noqa: E501
            disable_frontend_builds (bool): Unknown, probably toggles compilation of frontend web builds? So internal flag?. defaults to False  # noqa: E501
            disable_hello (bool): Unknown. defaults to False  # noqa: E501
            disable_oculus_subs (bool): Toggles if signing up for Subscriptions in Oculus is disabled or not.. defaults to False  # noqa: E501
            disable_registration (bool): Toggles if new user account registration should be disabled.. defaults to False  # noqa: E501
            disable_steam_networking (bool): Toggles if Steam Networking should be disabled. VRChat these days uses Photon Unity Networking (PUN) instead.. defaults to True  # noqa: E501
            disable_two_factor_auth (bool): Toggles if 2FA should be disabled.. defaults to False  # noqa: E501
            disable_udon (bool): Toggles if Udon should be universally disabled in-game.. defaults to False  # noqa: E501
            disable_upgrade_account (bool): Toggles if account upgrading \"linking with Steam/Oculus\" should be disabled.. defaults to False  # noqa: E501
            homepage_redirect_target (str): Redirect target if you try to open the base API domain in your browser. defaults to "https://hello.vrchat.com"  # noqa: E501
            use_reliable_udp_for_voice (bool): Unknown. defaults to False  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
        """

        voice_enable_degradation = kwargs.get('voice_enable_degradation', False)
        voice_enable_receiver_limiting = kwargs.get('voice_enable_receiver_limiting', True)
        app_name = kwargs.get('app_name', "VrChat")
        client_bps_ceiling = kwargs.get('client_bps_ceiling', 18432)
        client_disconnect_timeout = kwargs.get('client_disconnect_timeout', 30000)
        client_reserved_player_bps = kwargs.get('client_reserved_player_bps', 7168)
        client_sent_count_allowance = kwargs.get('client_sent_count_allowance', 15)
        disable_avatar_copying = kwargs.get('disable_avatar_copying', False)
        disable_avatar_gating = kwargs.get('disable_avatar_gating', False)
        disable_community_labs = kwargs.get('disable_community_labs', False)
        disable_community_labs_promotion = kwargs.get('disable_community_labs_promotion', False)
        disable_email = kwargs.get('disable_email', False)
        disable_event_stream = kwargs.get('disable_event_stream', False)
        disable_feedback_gating = kwargs.get('disable_feedback_gating', False)
        disable_frontend_builds = kwargs.get('disable_frontend_builds', False)
        disable_hello = kwargs.get('disable_hello', False)
        disable_oculus_subs = kwargs.get('disable_oculus_subs', False)
        disable_registration = kwargs.get('disable_registration', False)
        disable_steam_networking = kwargs.get('disable_steam_networking', True)
        disable_two_factor_auth = kwargs.get('disable_two_factor_auth', False)
        disable_udon = kwargs.get('disable_udon', False)
        disable_upgrade_account = kwargs.get('disable_upgrade_account', False)
        homepage_redirect_target = kwargs.get('homepage_redirect_target', "https://hello.vrchat.com")
        use_reliable_udp_for_voice = kwargs.get('use_reliable_udp_for_voice', False)
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.voice_enable_degradation = voice_enable_degradation
        self.voice_enable_receiver_limiting = voice_enable_receiver_limiting
        self.address = address
        self.announcements = announcements
        self.api_key = api_key
        self.app_name = app_name
        self.build_version_tag = build_version_tag
        self.client_api_key = client_api_key
        self.client_bps_ceiling = client_bps_ceiling
        self.client_disconnect_timeout = client_disconnect_timeout
        self.client_reserved_player_bps = client_reserved_player_bps
        self.client_sent_count_allowance = client_sent_count_allowance
        self.contact_email = contact_email
        self.copyright_email = copyright_email
        self.current_tos_version = current_tos_version
        self.default_avatar = default_avatar
        self.deployment_group = deployment_group
        self.dev_app_version_standalone = dev_app_version_standalone
        self.dev_download_link_windows = dev_download_link_windows
        self.dev_sdk_url = dev_sdk_url
        self.dev_sdk_version = dev_sdk_version
        self.dev_server_version_standalone = dev_server_version_standalone
        self.dis_countdown = dis_countdown
        self.disable_avatar_copying = disable_avatar_copying
        self.disable_avatar_gating = disable_avatar_gating
        self.disable_community_labs = disable_community_labs
        self.disable_community_labs_promotion = disable_community_labs_promotion
        self.disable_email = disable_email
        self.disable_event_stream = disable_event_stream
        self.disable_feedback_gating = disable_feedback_gating
        self.disable_frontend_builds = disable_frontend_builds
        self.disable_hello = disable_hello
        self.disable_oculus_subs = disable_oculus_subs
        self.disable_registration = disable_registration
        self.disable_steam_networking = disable_steam_networking
        self.disable_two_factor_auth = disable_two_factor_auth
        self.disable_udon = disable_udon
        self.disable_upgrade_account = disable_upgrade_account
        self.download_link_windows = download_link_windows
        self.download_urls = download_urls
        self.dynamic_world_rows = dynamic_world_rows
        self.events = events
        self.gear_demo_room_id = gear_demo_room_id
        self.home_world_id = home_world_id
        self.homepage_redirect_target = homepage_redirect_target
        self.hub_world_id = hub_world_id
        self.jobs_email = jobs_email
        self.message_of_the_day = message_of_the_day
        self.moderation_email = moderation_email
        self.moderation_query_period = moderation_query_period
        self.not_allowed_to_select_avatar_in_private_world_message = not_allowed_to_select_avatar_in_private_world_message
        self.plugin = plugin
        self.release_app_version_standalone = release_app_version_standalone
        self.release_sdk_url = release_sdk_url
        self.release_sdk_version = release_sdk_version
        self.release_server_version_standalone = release_server_version_standalone
        self.sdk_developer_faq_url = sdk_developer_faq_url
        self.sdk_discord_url = sdk_discord_url
        self.sdk_not_allowed_to_publish_message = sdk_not_allowed_to_publish_message
        self.sdk_unity_version = sdk_unity_version
        self.server_name = server_name
        self.support_email = support_email
        self.time_out_world_id = time_out_world_id
        self.tutorial_world_id = tutorial_world_id
        self.update_rate_ms_maximum = update_rate_ms_maximum
        self.update_rate_ms_minimum = update_rate_ms_minimum
        self.update_rate_ms_normal = update_rate_ms_normal
        self.update_rate_ms_udon_manual = update_rate_ms_udon_manual
        self.upload_analysis_percent = upload_analysis_percent
        self.url_list = url_list
        self.use_reliable_udp_for_voice = use_reliable_udp_for_voice
        self.user_update_period = user_update_period
        self.user_verification_delay = user_verification_delay
        self.user_verification_retry = user_verification_retry
        self.user_verification_timeout = user_verification_timeout
        self.vive_windows_url = vive_windows_url
        self.white_listed_asset_urls = white_listed_asset_urls
        self.world_update_period = world_update_period
        self.youtubedl_hash = youtubedl_hash
        self.youtubedl_version = youtubedl_version
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, address, announcements, api_key, build_version_tag, client_api_key, contact_email, copyright_email, current_tos_version, default_avatar, deployment_group, dev_app_version_standalone, dev_download_link_windows, dev_sdk_url, dev_sdk_version, dev_server_version_standalone, dis_countdown, download_link_windows, download_urls, dynamic_world_rows, events, gear_demo_room_id, home_world_id, hub_world_id, jobs_email, message_of_the_day, moderation_email, moderation_query_period, not_allowed_to_select_avatar_in_private_world_message, plugin, release_app_version_standalone, release_sdk_url, release_sdk_version, release_server_version_standalone, sdk_developer_faq_url, sdk_discord_url, sdk_not_allowed_to_publish_message, sdk_unity_version, server_name, support_email, time_out_world_id, tutorial_world_id, update_rate_ms_maximum, update_rate_ms_minimum, update_rate_ms_normal, update_rate_ms_udon_manual, upload_analysis_percent, url_list, user_update_period, user_verification_delay, user_verification_retry, user_verification_timeout, vive_windows_url, white_listed_asset_urls, world_update_period, youtubedl_hash, youtubedl_version, *args, **kwargs):  # noqa: E501
        """APIConfig - a model defined in OpenAPI

        Args:
            address (str): VRChat's office address
            announcements ([PublicAnnouncement]): Public Announcements
            api_key (str): apiKey to be used for all other requests
            build_version_tag (str): Build tag of the API server
            client_api_key (str): apiKey to be used for all other requests
            contact_email (str): VRChat's contact email
            copyright_email (str): VRChat's copyright-issues-related email
            current_tos_version (int): Current version number of the Terms of Service
            default_avatar (AvatarID):
            deployment_group (DeploymentGroup):
            dev_app_version_standalone (str): Version number for game development build
            dev_download_link_windows (str): Developer Download link
            dev_sdk_url (str): Link to download the development SDK, use downloadUrls instead
            dev_sdk_version (str): Version of the development SDK
            dev_server_version_standalone (str): Version number for server development build
            dis_countdown (datetime): Unknown, \"dis\" maybe for disconnect?
            download_link_windows (str): Download link for game on the Oculus Rift website.
            download_urls (DownloadURLList):
            dynamic_world_rows ([DynamicWorldRow]): Array of DynamicWorldRow objects, used by the game to display the list of world rows
            events (APIEventConfig):
            gear_demo_room_id (str): Unknown
            home_world_id (WorldID):
            hub_world_id (WorldID):
            jobs_email (str): VRChat's job application email
            message_of_the_day (str): MOTD
            moderation_email (str): VRChat's moderation related email
            moderation_query_period (int): Unknown
            not_allowed_to_select_avatar_in_private_world_message (str): Used in-game to notify a user they aren't allowed to select avatars in private worlds
            plugin (str): Extra [plugin](https://doc.photonengine.com/en-us/server/current/plugins/manual) to run in each instance
            release_app_version_standalone (str): Version number for game release build
            release_sdk_url (str): Link to download the release SDK
            release_sdk_version (str): Version of the release SDK
            release_server_version_standalone (str): Version number for server release build
            sdk_developer_faq_url (str): Link to the developer FAQ
            sdk_discord_url (str): Link to the official VRChat Discord
            sdk_not_allowed_to_publish_message (str): Used in the SDK to notify a user they aren't allowed to upload avatars/worlds yet
            sdk_unity_version (str): Unity version supported by the SDK
            server_name (str): Server name of the API server currently responding
            support_email (str): VRChat's support email
            time_out_world_id (WorldID):
            tutorial_world_id (WorldID):
            update_rate_ms_maximum (int): Unknown
            update_rate_ms_minimum (int): Unknown
            update_rate_ms_normal (int): Unknown
            update_rate_ms_udon_manual (int): Unknown
            upload_analysis_percent (int): Unknown
            url_list ([str]): List of allowed URLs that bypass the \"Allow untrusted URL's\" setting in-game
            user_update_period (int): Unknown
            user_verification_delay (int): Unknown
            user_verification_retry (int): Unknown
            user_verification_timeout (int): Unknown
            vive_windows_url (str): Download link for game on the Steam website.
            white_listed_asset_urls ([str]): List of allowed URLs that are allowed to host avatar assets
            world_update_period (int): Unknown
            youtubedl_hash (str): Currently used youtube-dl.exe hash in SHA-256-delimited format
            youtubedl_version (str): Currently used youtube-dl.exe version

        Keyword Args:
            voice_enable_degradation (bool): Unknown, probably voice optimization testing. defaults to False  # noqa: E501
            voice_enable_receiver_limiting (bool): Unknown, probably voice optimization testing. defaults to True  # noqa: E501
            app_name (str): Game name. defaults to "VrChat"  # noqa: E501
            client_bps_ceiling (int): Unknown. defaults to 18432  # noqa: E501
            client_disconnect_timeout (int): Unknown. defaults to 30000  # noqa: E501
            client_reserved_player_bps (int): Unknown. defaults to 7168  # noqa: E501
            client_sent_count_allowance (int): Unknown. defaults to 15  # noqa: E501
            disable_avatar_copying (bool): Toggles if copying avatars should be disabled. defaults to False  # noqa: E501
            disable_avatar_gating (bool): Toggles if avatar gating should be disabled. Avatar gating restricts uploading of avatars to people with the `system_avatar_access` Tag or `admin_avatar_access` Tag. defaults to False  # noqa: E501
            disable_community_labs (bool): Toggles if the Community Labs should be disabled. defaults to False  # noqa: E501
            disable_community_labs_promotion (bool): Toggles if promotion out of Community Labs should be disabled. defaults to False  # noqa: E501
            disable_email (bool): Unknown. defaults to False  # noqa: E501
            disable_event_stream (bool): Toggles if Analytics should be disabled.. defaults to False  # noqa: E501
            disable_feedback_gating (bool): Toggles if feedback gating should be disabled. Feedback gating restricts submission of feedback (reporting a World or User) to people with the `system_feedback_access` Tag.. defaults to False  # noqa: E501
            disable_frontend_builds (bool): Unknown, probably toggles compilation of frontend web builds? So internal flag?. defaults to False  # noqa: E501
            disable_hello (bool): Unknown. defaults to False  # noqa: E501
            disable_oculus_subs (bool): Toggles if signing up for Subscriptions in Oculus is disabled or not.. defaults to False  # noqa: E501
            disable_registration (bool): Toggles if new user account registration should be disabled.. defaults to False  # noqa: E501
            disable_steam_networking (bool): Toggles if Steam Networking should be disabled. VRChat these days uses Photon Unity Networking (PUN) instead.. defaults to True  # noqa: E501
            disable_two_factor_auth (bool): Toggles if 2FA should be disabled.. defaults to False  # noqa: E501
            disable_udon (bool): Toggles if Udon should be universally disabled in-game.. defaults to False  # noqa: E501
            disable_upgrade_account (bool): Toggles if account upgrading \"linking with Steam/Oculus\" should be disabled.. defaults to False  # noqa: E501
            homepage_redirect_target (str): Redirect target if you try to open the base API domain in your browser. defaults to "https://hello.vrchat.com"  # noqa: E501
            use_reliable_udp_for_voice (bool): Unknown. defaults to False  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
        """

        voice_enable_degradation = kwargs.get('voice_enable_degradation', False)
        voice_enable_receiver_limiting = kwargs.get('voice_enable_receiver_limiting', True)
        app_name = kwargs.get('app_name', "VrChat")
        client_bps_ceiling = kwargs.get('client_bps_ceiling', 18432)
        client_disconnect_timeout = kwargs.get('client_disconnect_timeout', 30000)
        client_reserved_player_bps = kwargs.get('client_reserved_player_bps', 7168)
        client_sent_count_allowance = kwargs.get('client_sent_count_allowance', 15)
        disable_avatar_copying = kwargs.get('disable_avatar_copying', False)
        disable_avatar_gating = kwargs.get('disable_avatar_gating', False)
        disable_community_labs = kwargs.get('disable_community_labs', False)
        disable_community_labs_promotion = kwargs.get('disable_community_labs_promotion', False)
        disable_email = kwargs.get('disable_email', False)
        disable_event_stream = kwargs.get('disable_event_stream', False)
        disable_feedback_gating = kwargs.get('disable_feedback_gating', False)
        disable_frontend_builds = kwargs.get('disable_frontend_builds', False)
        disable_hello = kwargs.get('disable_hello', False)
        disable_oculus_subs = kwargs.get('disable_oculus_subs', False)
        disable_registration = kwargs.get('disable_registration', False)
        disable_steam_networking = kwargs.get('disable_steam_networking', True)
        disable_two_factor_auth = kwargs.get('disable_two_factor_auth', False)
        disable_udon = kwargs.get('disable_udon', False)
        disable_upgrade_account = kwargs.get('disable_upgrade_account', False)
        homepage_redirect_target = kwargs.get('homepage_redirect_target', "https://hello.vrchat.com")
        use_reliable_udp_for_voice = kwargs.get('use_reliable_udp_for_voice', False)
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.voice_enable_degradation = voice_enable_degradation
        self.voice_enable_receiver_limiting = voice_enable_receiver_limiting
        self.address = address
        self.announcements = announcements
        self.api_key = api_key
        self.app_name = app_name
        self.build_version_tag = build_version_tag
        self.client_api_key = client_api_key
        self.client_bps_ceiling = client_bps_ceiling
        self.client_disconnect_timeout = client_disconnect_timeout
        self.client_reserved_player_bps = client_reserved_player_bps
        self.client_sent_count_allowance = client_sent_count_allowance
        self.contact_email = contact_email
        self.copyright_email = copyright_email
        self.current_tos_version = current_tos_version
        self.default_avatar = default_avatar
        self.deployment_group = deployment_group
        self.dev_app_version_standalone = dev_app_version_standalone
        self.dev_download_link_windows = dev_download_link_windows
        self.dev_sdk_url = dev_sdk_url
        self.dev_sdk_version = dev_sdk_version
        self.dev_server_version_standalone = dev_server_version_standalone
        self.dis_countdown = dis_countdown
        self.disable_avatar_copying = disable_avatar_copying
        self.disable_avatar_gating = disable_avatar_gating
        self.disable_community_labs = disable_community_labs
        self.disable_community_labs_promotion = disable_community_labs_promotion
        self.disable_email = disable_email
        self.disable_event_stream = disable_event_stream
        self.disable_feedback_gating = disable_feedback_gating
        self.disable_frontend_builds = disable_frontend_builds
        self.disable_hello = disable_hello
        self.disable_oculus_subs = disable_oculus_subs
        self.disable_registration = disable_registration
        self.disable_steam_networking = disable_steam_networking
        self.disable_two_factor_auth = disable_two_factor_auth
        self.disable_udon = disable_udon
        self.disable_upgrade_account = disable_upgrade_account
        self.download_link_windows = download_link_windows
        self.download_urls = download_urls
        self.dynamic_world_rows = dynamic_world_rows
        self.events = events
        self.gear_demo_room_id = gear_demo_room_id
        self.home_world_id = home_world_id
        self.homepage_redirect_target = homepage_redirect_target
        self.hub_world_id = hub_world_id
        self.jobs_email = jobs_email
        self.message_of_the_day = message_of_the_day
        self.moderation_email = moderation_email
        self.moderation_query_period = moderation_query_period
        self.not_allowed_to_select_avatar_in_private_world_message = not_allowed_to_select_avatar_in_private_world_message
        self.plugin = plugin
        self.release_app_version_standalone = release_app_version_standalone
        self.release_sdk_url = release_sdk_url
        self.release_sdk_version = release_sdk_version
        self.release_server_version_standalone = release_server_version_standalone
        self.sdk_developer_faq_url = sdk_developer_faq_url
        self.sdk_discord_url = sdk_discord_url
        self.sdk_not_allowed_to_publish_message = sdk_not_allowed_to_publish_message
        self.sdk_unity_version = sdk_unity_version
        self.server_name = server_name
        self.support_email = support_email
        self.time_out_world_id = time_out_world_id
        self.tutorial_world_id = tutorial_world_id
        self.update_rate_ms_maximum = update_rate_ms_maximum
        self.update_rate_ms_minimum = update_rate_ms_minimum
        self.update_rate_ms_normal = update_rate_ms_normal
        self.update_rate_ms_udon_manual = update_rate_ms_udon_manual
        self.upload_analysis_percent = upload_analysis_percent
        self.url_list = url_list
        self.use_reliable_udp_for_voice = use_reliable_udp_for_voice
        self.user_update_period = user_update_period
        self.user_verification_delay = user_verification_delay
        self.user_verification_retry = user_verification_retry
        self.user_verification_timeout = user_verification_timeout
        self.vive_windows_url = vive_windows_url
        self.white_listed_asset_urls = white_listed_asset_urls
        self.world_update_period = world_update_period
        self.youtubedl_hash = youtubedl_hash
        self.youtubedl_version = youtubedl_version
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
