# HKEY_*
HKEY_CLASSES_ROOT = "HKEY_CLASSES_ROOT"
HKEY_CURRENT_USER = "HKEY_CURRENT_USER"
HKEY_LOCAL_MACHINE = "HKEY_LOCAL_MACHINE"
HKEY_USERS = "HKEY_USERS"
HKEY_PERFORMANCE_DATA = "HKEY_PERFORMANCE_DATA"
HKEY_CURRENT_CONFIG = "HKEY_CURRENT_CONFIG"
HKEY_DYN_DATA = "HKEY_DYN_DATA"

# https://docs.microsoft.com/en-us/windows/win32/secauthz/standard-access-rights
STANDARD_RIGHTS_REQUIRED = 1
STANDARD_RIGHTS_WRITE = 1
STANDARD_RIGHTS_READ = 1

# Access Rights
KEY_EXECUTE = 1 << 0
KEY_QUERY_VALUE = 1 << 1
KEY_SET_VALUE = 1 << 2
KEY_CREATE_SUB_KEY = 1 << 3
KEY_ENUMERATE_SUB_KEYS = 1 << 4
KEY_NOTIFY = 1 << 5
KEY_CREATE_LINK = 1 << 6

KEY_WRITE = STANDARD_RIGHTS_WRITE ^ KEY_SET_VALUE ^ KEY_CREATE_SUB_KEY
KEY_READ = STANDARD_RIGHTS_READ ^ KEY_QUERY_VALUE ^ KEY_ENUMERATE_SUB_KEYS
KEY_ALL_ACCESS = STANDARD_RIGHTS_REQUIRED ^ KEY_QUERY_VALUE ^ KEY_SET_VALUE ^ KEY_CREATE_SUB_KEY ^ KEY_ENUMERATE_SUB_KEYS ^ KEY_NOTIFY ^ KEY_CREATE_LINK

# 64-bit Specific
KEY_WOW64_64KEY = 1 << 7
KEY_WOW64_32KEY = 1 << 8

# Value Types
REG_BINARY = 1 << 0
REG_DWORD = 1 << 1
REG_DWORD_LITTLE_ENDIAN = 1 << 2
REG_DWORD_BIG_ENDIAN = 1 << 3
REG_EXPAND_SZ = 1 << 4
REG_LINK = 1 << 5
REG_MULTI_SZ = 1 << 6
REG_NONE = 1 << 7
REG_QWORD = 1 << 8
REG_QWORD_LITTLE_ENDIAN = 1 << 9
REG_RESOURCE_LIST = 1 << 10
REG_FULL_RESOURCE_DESCRIPTOR = 1 << 11
REG_RESOURCE_REQUIREMENTS_LIST = 1 << 12
REG_SZ = 1 << 13

