# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pylottie']

package_data = \
{'': ['*']}

install_requires = \
['Pillow>=8.1.0,<10', 'pyppeteer>=0.2.6,<2']

entry_points = \
{'console_scripts': ['pylottie = pylottie:cli']}

setup_kwargs = {
    'name': 'pylottie',
    'version': '2021.2.2',
    'description': 'Convert .tgs and .lottie to .webp or .gif using pyppeteer.',
    'long_description': '[![GitHub top language](https://img.shields.io/github/languages/top/FHPythonUtils/PyLottie.svg?style=for-the-badge)](../../)\n[![Repository size](https://img.shields.io/github/repo-size/FHPythonUtils/PyLottie.svg?style=for-the-badge)](../../)\n[![Issues](https://img.shields.io/github/issues/FHPythonUtils/PyLottie.svg?style=for-the-badge)](../../issues)\n[![License](https://img.shields.io/github/license/FHPythonUtils/PyLottie.svg?style=for-the-badge)](/LICENSE.md)\n[![Commit activity](https://img.shields.io/github/commit-activity/m/FHPythonUtils/PyLottie.svg?style=for-the-badge)](../../commits/master)\n[![Last commit](https://img.shields.io/github/last-commit/FHPythonUtils/PyLottie.svg?style=for-the-badge)](../../commits/master)\n[![PyPI Downloads](https://img.shields.io/pypi/dm/pylottie.svg?style=for-the-badge)](https://pypistats.org/packages/pylottie)\n[![PyPI Total Downloads](https://img.shields.io/badge/dynamic/json?style=for-the-badge&label=total%20downloads&query=%24.total_downloads&url=https%3A%2F%2Fapi.pepy.tech%2Fapi%2Fprojects%2Fpylottie)](https://pepy.tech/project/pylottie)\n[![PyPI Version](https://img.shields.io/pypi/v/pylottie.svg?style=for-the-badge)](https://pypi.org/project/pylottie)\n\n<!-- omit in TOC -->\n# PyLottie\n\n<img src="readme-assets/icons/name.png" alt="Project Icon" width="750">\n\nConvert .tgs and .lottie to .webp or .gif using pyppeteer.\n\n## PyRlottie\n\nIf using one of the below environments, using PyRlottie can offer significant\nspeed and quality improvements over pylottie (between 1.5x and 5x in most cases)\n\nGet it from:\n\n- Pypi: https://pypi.org/project/pyrlottie\n- Github: https://github.com/FHPythonUtils/PyRlottie\n\n| Environment | Supported |\n| ----------- | --------- |\n|linux_x86_64 | ✔         |\n|linux_aarch64| ✔         |\n|windows_amd64| ✔         |\n\n- [PyRlottie](#pyrlottie)\n- [Formats](#formats)\n- [Basic Usage](#basic-usage)\n- [Documentation](#documentation)\n- [Supported Environments (64bit)](#supported-environments-64bit)\n- [Install With PIP](#install-with-pip)\n- [Language information](#language-information)\n\t- [Built for](#built-for)\n- [Install Python on Windows](#install-python-on-windows)\n\t- [Chocolatey](#chocolatey)\n\t- [Windows - Python.org](#windows---pythonorg)\n- [Install Python on Linux](#install-python-on-linux)\n\t- [Apt](#apt)\n\t- [Dnf](#dnf)\n- [Install Python on MacOS](#install-python-on-macos)\n\t- [Homebrew](#homebrew)\n\t- [MacOS - Python.org](#macos---pythonorg)\n- [How to run](#how-to-run)\n\t- [Windows](#windows)\n\t- [Linux/ MacOS](#linux-macos)\n- [Download Project](#download-project)\n\t- [Clone](#clone)\n\t\t- [Using The Command Line](#using-the-command-line)\n\t\t- [Using GitHub Desktop](#using-github-desktop)\n\t- [Download Zip File](#download-zip-file)\n- [Community Files](#community-files)\n\t- [Licence](#licence)\n\t- [Changelog](#changelog)\n\t- [Code of Conduct](#code-of-conduct)\n\t- [Contributing](#contributing)\n\t- [Security](#security)\n\t- [Support](#support)\n\t- [Rationale](#rationale)\n\n## Formats\n\nconvertLottie2ALL, convertMultLottie2ALL, convertLottie2GIF, convertMultLottie2GIF, convertLottie2WEBP, convertMultLottie2WEBP\n| Format | Animated |\n| ------ | -------- |\n| .gif   | ✔        |\n| .webp  | ✔        |\n\nconvertLotties2PIL\n| Format | Animated |\n| ------ | -------- |\n| .gif   | ✔        |\n| .webp  | ✔        |\n| .apng  | ✔        |\n| .png   | :x:      |\n| .jpg   | :x:      |\n| etc... | ...      |\n\nhttps://pillow.readthedocs.io/en/stable/handbook/image-file-formats.html\n\n## Basic Usage\n\nConvert multiple tgs files to webp and gif\n\n```py\ninFiles = [f"test/file_43{idx}.tgs" for idx in range(7, 10)]\noutFiles = [f"test/file_0_43{idx}" for idx in range(7, 10)]\n\npylottie.convertMultLottie2ALL(inFiles, outFiles)\n```\n\n## Documentation\nSee the [Docs](/DOCS/) for more information.\n\n## Supported Environments (64bit)\n\n| Environment | Supported |\n| ----------- | --------- |\n|linux_x86_64 | ✔         |\n|linux_aarch64| :x:       |\n|windows_amd64| ✔         |\n|darwin_x86_64| ✔         |\n|darwin_arm64 | :x:       |\n\nFor a full list of machine architecures for Linux see https://stackoverflow.com/questions/45125516/possible-values-for-uname-m\n\n## Install With PIP\n\n```python\npip install pylottie\n```\n\nHead to https://pypi.org/project/pylottie/ for more info\n\n## Language information\n\n### Built for\nThis program has been written for Python versions 3.7 - 3.10 and has been tested with both 3.7 and\n3.10\n\n## Install Python on Windows\n\n### Chocolatey\n\n```powershell\nchoco install python\n```\n\n### Windows - Python.org\nTo install Python, go to https://www.python.org/downloads/windows/ and download the latest\nversion.\n\n## Install Python on Linux\n\n### Apt\n\n```bash\nsudo apt install python3.x\n```\n\n### Dnf\n\n```bash\nsudo dnf install python3.x\n```\n\n## Install Python on MacOS\n\n### Homebrew\n\n```bash\nbrew install python@3.x\n```\n\n### MacOS - Python.org\nTo install Python, go to https://www.python.org/downloads/macos/ and download the latest\nversion.\n\n## How to run\n\n### Windows\n\n- Module\n\t`py -3.x -m [module]` or `[module]` (if module installs a script)\n\n- File\n\t`py -3.x [file]` or `./[file]`\n\n### Linux/ MacOS\n\n- Module\n\t`python3.x -m [module]` or `[module]` (if module installs a script)\n\n- File\n\t`python3.x [file]` or `./[file]`\n\n## Download Project\n\n### Clone\n\n#### Using The Command Line\n\n1. Press the Clone or download button in the top right\n2. Copy the URL (link)\n3. Open the command line and change directory to where you wish to\nclone to\n4. Type \'git clone\' followed by URL in step 2\n\t```bash\n\tgit clone https://github.com/FHPythonUtils/PyLottie\n\t```\n\nMore information can be found at\nhttps://help.github.com/en/articles/cloning-a-repository\n\n#### Using GitHub Desktop\n\n1. Press the Clone or download button in the top right\n2. Click open in desktop\n3. Choose the path for where you want and click Clone\n\nMore information can be found at\nhttps://help.github.com/en/desktop/contributing-to-projects/cloning-a-repository-from-github-to-github-desktop\n\n### Download Zip File\n\n1. Download this GitHub repository\n2. Extract the zip archive\n3. Copy/ move to the desired location\n\n## Community Files\n\n### Licence\nMIT License\nCopyright (c) FredHappyface\n(See the [LICENSE](/LICENSE.md) for more information.)\n\n### Changelog\nSee the [Changelog](/CHANGELOG.md) for more information.\n\n### Code of Conduct\nOnline communities include people from many backgrounds. The *Project*\ncontributors are committed to providing a friendly, safe and welcoming\nenvironment for all. Please see the\n[Code of Conduct](https://github.com/FHPythonUtils/.github/blob/master/CODE_OF_CONDUCT.md)\n for more information.\n\n### Contributing\nContributions are welcome, please see the\n[Contributing Guidelines](https://github.com/FHPythonUtils/.github/blob/master/CONTRIBUTING.md)\nfor more information.\n\n### Security\nThank you for improving the security of the project, please see the\n[Security Policy](https://github.com/FHPythonUtils/.github/blob/master/SECURITY.md)\nfor more information.\n\n### Support\nThank you for using this project, I hope it is of use to you. Please be aware that\nthose involved with the project often do so for fun along with other commitments\n(such as work, family, etc). Please see the\n[Support Policy](https://github.com/FHPythonUtils/.github/blob/master/SUPPORT.md)\nfor more information.\n\n### Rationale\nThe rationale acts as a guide to various processes regarding projects such as\nthe versioning scheme and the programming styles used. Please see the\n[Rationale](https://github.com/FHPythonUtils/.github/blob/master/RATIONALE.md)\nfor more information.\n',
    'author': 'FredHappyface',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/FHPythonUtils/PyLottie',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
